
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * A data type for Shopping Request Business Object: PROGRAM Qualifiers.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProgramQualifierType">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="DiscountProgramQualifier" minOccurs="0"/>
 *     &lt;xs:element ref="IncentiveProgramQualifier" minOccurs="0"/>
 *     &lt;xs:element ref="PrePaidProgramQualifier" minOccurs="0"/>
 *     &lt;xs:element ref="ProgramStatusQualifier"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProgramQualifierType implements Serializable
{
    private DiscountProgramType discountProgramQualifier;
    private IncentiveProgramType incentiveProgramQualifier;
    private PrePaidProgramQualifier prePaidProgramQualifier;
    private ProgramStatusQualifier programStatusQualifier;

    /** 
     * Get the 'DiscountProgramQualifier' element value. Discount Program Qualifiers; fare type for this PTC.
    Notes:
    1. Supports pricing discounts and/ or other benefits from membership in Travel Discount Programs, such as AARP and AAA.
    2. Discount Programs may be associated to individual Travellers but will apply to ALL Travellers if no associations are specified.
     * 
     * @return value
     */
    public DiscountProgramType getDiscountProgramQualifier() {
        return discountProgramQualifier;
    }

    /** 
     * Set the 'DiscountProgramQualifier' element value. Discount Program Qualifiers; fare type for this PTC.
    Notes:
    1. Supports pricing discounts and/ or other benefits from membership in Travel Discount Programs, such as AARP and AAA.
    2. Discount Programs may be associated to individual Travellers but will apply to ALL Travellers if no associations are specified.
     * 
     * @param discountProgramQualifier
     */
    public void setDiscountProgramQualifier(
            DiscountProgramType discountProgramQualifier) {
        this.discountProgramQualifier = discountProgramQualifier;
    }

    /** 
     * Get the 'IncentiveProgramQualifier' element value.
     * 
     * @return value
     */
    public IncentiveProgramType getIncentiveProgramQualifier() {
        return incentiveProgramQualifier;
    }

    /** 
     * Set the 'IncentiveProgramQualifier' element value.
     * 
     * @param incentiveProgramQualifier
     */
    public void setIncentiveProgramQualifier(
            IncentiveProgramType incentiveProgramQualifier) {
        this.incentiveProgramQualifier = incentiveProgramQualifier;
    }

    /** 
     * Get the 'PrePaidProgramQualifier' element value.
     * 
     * @return value
     */
    public PrePaidProgramQualifier getPrePaidProgramQualifier() {
        return prePaidProgramQualifier;
    }

    /** 
     * Set the 'PrePaidProgramQualifier' element value.
     * 
     * @param prePaidProgramQualifier
     */
    public void setPrePaidProgramQualifier(
            PrePaidProgramQualifier prePaidProgramQualifier) {
        this.prePaidProgramQualifier = prePaidProgramQualifier;
    }

    /** 
     * Get the 'ProgramStatusQualifier' element value.
     * 
     * @return value
     */
    public ProgramStatusQualifier getProgramStatusQualifier() {
        return programStatusQualifier;
    }

    /** 
     * Set the 'ProgramStatusQualifier' element value.
     * 
     * @param programStatusQualifier
     */
    public void setProgramStatusQualifier(
            ProgramStatusQualifier programStatusQualifier) {
        this.programStatusQualifier = programStatusQualifier;
    }
}
