
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * A data type for Proximity Data Application list constraint.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProximityAppListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="ActualProximity"/>
 *     &lt;xs:enumeration value="SearchRadius"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum ProximityAppListType implements Serializable {
    ACTUAL_PROXIMITY("ActualProximity"), SEARCH_RADIUS("SearchRadius"), OTHER(
            "Other");
    private final String value;

    private ProximityAppListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static ProximityAppListType convert(String value) {
        for (ProximityAppListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
