
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Qualifier choices.

 These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of the capability is not dictated by this specification. 
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Qualifier">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="BaggagePricingQualifier" minOccurs="0"/>
 *       &lt;xs:element ref="ExistingOrderQualifier" minOccurs="0"/>
 *       &lt;xs:element ref="PaymentCardQualifiers" minOccurs="0" maxOccurs="unbounded"/>
 *       &lt;xs:element ref="ProgramQualifiers" minOccurs="0"/>
 *       &lt;xs:element ref="PromotionQualifiers" minOccurs="0"/>
 *       &lt;xs:element ref="SeatQualifier" minOccurs="0"/>
 *       &lt;xs:element ref="ServiceQualifier" minOccurs="0"/>
 *       &lt;xs:element ref="SocialMediaQualifiers" minOccurs="0"/>
 *       &lt;xs:element ref="SpecialFareQualifiers" minOccurs="0"/>
 *       &lt;xs:element ref="SpecialNeedQualifiers" minOccurs="0"/>
 *       &lt;xs:element ref="TripPurposeQualifier" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class Qualifier implements Serializable
{
    private BaggagePricingQualifierType baggagePricingQualifier;
    private ExistingOrderQualifier existingOrderQualifier;
    private List<CardQualifierType> paymentCardQualifierList = new ArrayList<CardQualifierType>();
    private ProgramQualifiers programQualifiers;
    private PromotionQualifiers promotionQualifiers;
    private SeatQualifier seatQualifier;
    private ServiceQualifierPriceType serviceQualifier;
    private SocialMediaQualifierType socialMediaQualifiers;
    private FareQualifierType specialFareQualifiers;
    private SpecialType specialNeedQualifiers;
    private TripPurposeQualifier tripPurposeQualifier;

    /** 
     * Get the 'BaggagePricingQualifier' element value.
     * 
     * @return value
     */
    public BaggagePricingQualifierType getBaggagePricingQualifier() {
        return baggagePricingQualifier;
    }

    /** 
     * Set the 'BaggagePricingQualifier' element value.
     * 
     * @param baggagePricingQualifier
     */
    public void setBaggagePricingQualifier(
            BaggagePricingQualifierType baggagePricingQualifier) {
        this.baggagePricingQualifier = baggagePricingQualifier;
    }

    /** 
     * Get the 'ExistingOrderQualifier' element value.
     * 
     * @return value
     */
    public ExistingOrderQualifier getExistingOrderQualifier() {
        return existingOrderQualifier;
    }

    /** 
     * Set the 'ExistingOrderQualifier' element value.
     * 
     * @param existingOrderQualifier
     */
    public void setExistingOrderQualifier(
            ExistingOrderQualifier existingOrderQualifier) {
        this.existingOrderQualifier = existingOrderQualifier;
    }

    /** 
     * Get the list of 'PaymentCardQualifiers' element items. Contains card type, and Issuer Identification Number. 
     * 
     * @return list
     */
    public List<CardQualifierType> getPaymentCardQualifierList() {
        return paymentCardQualifierList;
    }

    /** 
     * Set the list of 'PaymentCardQualifiers' element items. Contains card type, and Issuer Identification Number. 
     * 
     * @param list
     */
    public void setPaymentCardQualifierList(List<CardQualifierType> list) {
        paymentCardQualifierList = list;
    }

    /** 
     * Get the 'ProgramQualifiers' element value.
     * 
     * @return value
     */
    public ProgramQualifiers getProgramQualifiers() {
        return programQualifiers;
    }

    /** 
     * Set the 'ProgramQualifiers' element value.
     * 
     * @param programQualifiers
     */
    public void setProgramQualifiers(ProgramQualifiers programQualifiers) {
        this.programQualifiers = programQualifiers;
    }

    /** 
     * Get the 'PromotionQualifiers' element value.
     * 
     * @return value
     */
    public PromotionQualifiers getPromotionQualifiers() {
        return promotionQualifiers;
    }

    /** 
     * Set the 'PromotionQualifiers' element value.
     * 
     * @param promotionQualifiers
     */
    public void setPromotionQualifiers(PromotionQualifiers promotionQualifiers) {
        this.promotionQualifiers = promotionQualifiers;
    }

    /** 
     * Get the 'SeatQualifier' element value.
     * 
     * @return value
     */
    public SeatQualifier getSeatQualifier() {
        return seatQualifier;
    }

    /** 
     * Set the 'SeatQualifier' element value.
     * 
     * @param seatQualifier
     */
    public void setSeatQualifier(SeatQualifier seatQualifier) {
        this.seatQualifier = seatQualifier;
    }

    /** 
     * Get the 'ServiceQualifier' element value.
     * 
     * @return value
     */
    public ServiceQualifierPriceType getServiceQualifier() {
        return serviceQualifier;
    }

    /** 
     * Set the 'ServiceQualifier' element value.
     * 
     * @param serviceQualifier
     */
    public void setServiceQualifier(ServiceQualifierPriceType serviceQualifier) {
        this.serviceQualifier = serviceQualifier;
    }

    /** 
     * Get the 'SocialMediaQualifiers' element value.
     * 
     * @return value
     */
    public SocialMediaQualifierType getSocialMediaQualifiers() {
        return socialMediaQualifiers;
    }

    /** 
     * Set the 'SocialMediaQualifiers' element value.
     * 
     * @param socialMediaQualifiers
     */
    public void setSocialMediaQualifiers(
            SocialMediaQualifierType socialMediaQualifiers) {
        this.socialMediaQualifiers = socialMediaQualifiers;
    }

    /** 
     * Get the 'SpecialFareQualifiers' element value. Contains elements identifying eligibility for special pricing, which may be private or negotiated.

    Notes:
    1. Supports pricing discounts and/ or other benefits for Travelers affiliated with companies with private fare and/ or negotiated rate contracts.

    2. Private Fares apply to ALL Travelers.
     * 
     * @return value
     */
    public FareQualifierType getSpecialFareQualifiers() {
        return specialFareQualifiers;
    }

    /** 
     * Set the 'SpecialFareQualifiers' element value. Contains elements identifying eligibility for special pricing, which may be private or negotiated.

    Notes:
    1. Supports pricing discounts and/ or other benefits for Travelers affiliated with companies with private fare and/ or negotiated rate contracts.

    2. Private Fares apply to ALL Travelers.
     * 
     * @param specialFareQualifiers
     */
    public void setSpecialFareQualifiers(FareQualifierType specialFareQualifiers) {
        this.specialFareQualifiers = specialFareQualifiers;
    }

    /** 
     * Get the 'SpecialNeedQualifiers' element value.
     * 
     * @return value
     */
    public SpecialType getSpecialNeedQualifiers() {
        return specialNeedQualifiers;
    }

    /** 
     * Set the 'SpecialNeedQualifiers' element value.
     * 
     * @param specialNeedQualifiers
     */
    public void setSpecialNeedQualifiers(SpecialType specialNeedQualifiers) {
        this.specialNeedQualifiers = specialNeedQualifiers;
    }

    /** 
     * Get the 'TripPurposeQualifier' element value.
     * 
     * @return value
     */
    public TripPurposeQualifier getTripPurposeQualifier() {
        return tripPurposeQualifier;
    }

    /** 
     * Set the 'TripPurposeQualifier' element value.
     * 
     * @param tripPurposeQualifier
     */
    public void setTripPurposeQualifier(
            TripPurposeQualifier tripPurposeQualifier) {
        this.tripPurposeQualifier = tripPurposeQualifier;
    }
}
