
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

/** 
 * Flight Reservation (booking/ order) date and time.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ResDateTime">
 *   &lt;xs:complexType>
 *     &lt;xs:choice>
 *       &lt;xs:element type="xs:dateTime" name="Timestamp"/>
 *       &lt;xs:element name="Date">
 *         &lt;xs:complexType>
 *           &lt;xs:simpleContent>
 *             &lt;xs:extension base="xs:date">
 *               &lt;xs:attribute type="xs:string" use="optional" name="time"/>
 *             &lt;/xs:extension>
 *           &lt;/xs:simpleContent>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:choice>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class ResDateTime implements Serializable
{
    private int resDateTimeSelect = -1;
    private static final int TIMESTAMP_CHOICE = 0;
    private static final int DATE_CHOICE = 1;
    private DateTime timestamp;
    private LocalDate dateDate;
    private String dateTime;

    private void setResDateTimeSelect(int choice) {
        if (resDateTimeSelect == -1) {
            resDateTimeSelect = choice;
        } else if (resDateTimeSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearResDateTimeSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearResDateTimeSelect() {
        resDateTimeSelect = -1;
    }

    /** 
     * Check if Timestamp is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTimestamp() {
        return resDateTimeSelect == TIMESTAMP_CHOICE;
    }

    /** 
     * Get the 'Timestamp' element value. Reservation (order/ booking) timestamp.  Example: 2017-01-13T13:20:00
     * 
     * @return value
     */
    public DateTime getTimestamp() {
        return timestamp;
    }

    /** 
     * Set the 'Timestamp' element value. Reservation (order/ booking) timestamp.  Example: 2017-01-13T13:20:00
     * 
     * @param timestamp
     */
    public void setTimestamp(DateTime timestamp) {
        setResDateTimeSelect(TIMESTAMP_CHOICE);
        this.timestamp = timestamp;
    }

    /** 
     * Check if Date is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDate() {
        return resDateTimeSelect == DATE_CHOICE;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public LocalDate getDateDate() {
        return dateDate;
    }

    /** 
     * Set the extension value.
     * 
     * @param dateDate
     */
    public void setDateDate(LocalDate dateDate) {
        setResDateTimeSelect(DATE_CHOICE);
        this.dateDate = dateDate;
    }

    /** 
     * Get the 'time' attribute value. Order Reservation (booking) Time.  Example: 13:20
     * 
     * @return value
     */
    public String getDateTime() {
        return dateTime;
    }

    /** 
     * Set the 'time' attribute value. Order Reservation (booking) Time.  Example: 13:20
     * 
     * @param dateTime
     */
    public void setDateTime(String dateTime) {
        setResDateTimeSelect(DATE_CHOICE);
        this.dateTime = dateTime;
    }
}
