
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * Element to associate seat to a Traveler and s flight segment.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatAssociation">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="SegmentReferences"/>
 *       &lt;xs:element ref="PassengerReference"/>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class SeatAssociation implements Serializable
{
    private SegmentReferences segmentReferences;
    private PassengerReference passengerReference;

    /** 
     * Get the 'SegmentReferences' element value.
     * 
     * @return value
     */
    public SegmentReferences getSegmentReferences() {
        return segmentReferences;
    }

    /** 
     * Set the 'SegmentReferences' element value.
     * 
     * @param segmentReferences
     */
    public void setSegmentReferences(SegmentReferences segmentReferences) {
        this.segmentReferences = segmentReferences;
    }

    /** 
     * Get the 'PassengerReference' element value.
     * 
     * @return value
     */
    public PassengerReference getPassengerReference() {
        return passengerReference;
    }

    /** 
     * Set the 'PassengerReference' element value.
     * 
     * @param passengerReference
     */
    public void setPassengerReference(PassengerReference passengerReference) {
        this.passengerReference = passengerReference;
    }
}
