
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A SEAT OFFER with additional Seat Characteristics information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatItemType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="GenericPriceType" name="Price" minOccurs="0"/>
 *     &lt;xs:element type="Descriptions" name="Descriptions" minOccurs="0"/>
 *     &lt;xs:choice>
 *       &lt;xs:element type="SeatLocationType" name="Location" minOccurs="0"/>
 *       &lt;xs:element ref="SeatReference" maxOccurs="unbounded"/>
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class SeatItemType implements Serializable
{
    private GenericPriceType price;
    private Descriptions descriptions;
    private int choiceSelect = -1;
    private static final int LOCATION_CHOICE = 0;
    private static final int SEAT_REFERENCE_LIST_CHOICE = 1;
    private SeatLocationType location;
    private List<SeatReference> seatReferenceList = new ArrayList<SeatReference>();
    private String refs;

    /** 
     * Get the 'Price' element value. Price
     * 
     * @return value
     */
    public GenericPriceType getPrice() {
        return price;
    }

    /** 
     * Set the 'Price' element value. Price
     * 
     * @param price
     */
    public void setPrice(GenericPriceType price) {
        this.price = price;
    }

    /** 
     * Get the 'Descriptions' element value. Seat Description.
     * 
     * @return value
     */
    public Descriptions getDescriptions() {
        return descriptions;
    }

    /** 
     * Set the 'Descriptions' element value. Seat Description.
     * 
     * @param descriptions
     */
    public void setDescriptions(Descriptions descriptions) {
        this.descriptions = descriptions;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Location is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifLocation() {
        return choiceSelect == LOCATION_CHOICE;
    }

    /** 
     * Get the 'Location' element value. Seat Location information.
     * 
     * @return value
     */
    public SeatLocationType getLocation() {
        return location;
    }

    /** 
     * Set the 'Location' element value. Seat Location information.
     * 
     * @param location
     */
    public void setLocation(SeatLocationType location) {
        setChoiceSelect(LOCATION_CHOICE);
        this.location = location;
    }

    /** 
     * Check if SeatReferenceList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSeatReferenceList() {
        return choiceSelect == SEAT_REFERENCE_LIST_CHOICE;
    }

    /** 
     * Get the list of 'SeatReference' element items.
     * 
     * @return list
     */
    public List<SeatReference> getSeatReferenceList() {
        return seatReferenceList;
    }

    /** 
     * Set the list of 'SeatReference' element items.
     * 
     * @param list
     */
    public void setSeatReferenceList(List<SeatReference> list) {
        setChoiceSelect(SEAT_REFERENCE_LIST_CHOICE);
        seatReferenceList = list;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
