
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * SEAT Qualifier.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatQualifier">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="Assignment" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class Assignment -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class SeatQualifier implements Serializable
{
    private List<Assignment> assignmentList = new ArrayList<Assignment>();

    /** 
     * Get the list of 'Assignment' element items.
     * 
     * @return list
     */
    public List<Assignment> getAssignmentList() {
        return assignmentList;
    }

    /** 
     * Set the list of 'Assignment' element items.
     * 
     * @param list
     */
    public void setAssignmentList(List<Assignment> list) {
        assignmentList = list;
    }
    /** 
     * Seat assignment information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Assignment" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="SeatCoreType">
     *         &lt;xs:sequence>
     *           &lt;xs:element ref="SeatAssociation" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Assignment extends SeatCoreType implements Serializable
    {
        private SeatAssociation seatAssociation;

        /** 
         * Get the 'SeatAssociation' element value.
         * 
         * @return value
         */
        public SeatAssociation getSeatAssociation() {
            return seatAssociation;
        }

        /** 
         * Set the 'SeatAssociation' element value.
         * 
         * @param seatAssociation
         */
        public void setSeatAssociation(SeatAssociation seatAssociation) {
            this.seatAssociation = seatAssociation;
        }
    }
}
