
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * Offer-Associated Optional Services definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceInfoAssocType">
 *   &lt;xs:choice>
 *     &lt;xs:element ref="BundleReference"/>
 *     &lt;xs:element ref="ServiceReferences"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ServiceInfoAssocType implements Serializable
{
    private int choiceSelect = -1;
    private static final int BUNDLE_REFERENCE_CHOICE = 0;
    private static final int SERVICE_REFERENCES_CHOICE = 1;
    private BundleReference bundleReference;
    private ServiceReferences serviceReferences;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if BundleReference is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifBundleReference() {
        return choiceSelect == BUNDLE_REFERENCE_CHOICE;
    }

    /** 
     * Get the 'BundleReference' element value.
     * 
     * @return value
     */
    public BundleReference getBundleReference() {
        return bundleReference;
    }

    /** 
     * Set the 'BundleReference' element value.
     * 
     * @param bundleReference
     */
    public void setBundleReference(BundleReference bundleReference) {
        setChoiceSelect(BUNDLE_REFERENCE_CHOICE);
        this.bundleReference = bundleReference;
    }

    /** 
     * Check if ServiceReferences is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifServiceReferences() {
        return choiceSelect == SERVICE_REFERENCES_CHOICE;
    }

    /** 
     * Get the 'ServiceReferences' element value.
     * 
     * @return value
     */
    public ServiceReferences getServiceReferences() {
        return serviceReferences;
    }

    /** 
     * Set the 'ServiceReferences' element value.
     * 
     * @param serviceReferences
     */
    public void setServiceReferences(ServiceReferences serviceReferences) {
        setChoiceSelect(SERVICE_REFERENCES_CHOICE);
        this.serviceReferences = serviceReferences;
    }
}
