
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SettlementType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Surcharges" minOccurs="0">
 *       &lt;!-- Reference to inner class Surcharges -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="FeeSurchargeType" name="Fees" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SettlementType implements Serializable
{
    private Surcharges surcharges;
    private FeeSurchargeType fees;

    /** 
     * Get the 'Surcharges' element value.
     * 
     * @return value
     */
    public Surcharges getSurcharges() {
        return surcharges;
    }

    /** 
     * Set the 'Surcharges' element value.
     * 
     * @param surcharges
     */
    public void setSurcharges(Surcharges surcharges) {
        this.surcharges = surcharges;
    }

    /** 
     * Get the 'Fees' element value. Individual fee/ surcharge information would appear on the accountable document.
     * 
     * @return value
     */
    public FeeSurchargeType getFees() {
        return fees;
    }

    /** 
     * Set the 'Fees' element value. Individual fee/ surcharge information would appear on the accountable document.
     * 
     * @param fees
     */
    public void setFees(FeeSurchargeType fees) {
        this.fees = fees;
    }
    /** 
     * Applicable Surcharge(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Surcharges" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="FeeSurchargeType" name="Surcharge" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Surcharges implements Serializable
    {
        private List<FeeSurchargeType> surchargeList = new ArrayList<FeeSurchargeType>();

        /** 
         * Get the list of 'Surcharge' element items. Surcharge detail.
         * 
         * @return list
         */
        public List<FeeSurchargeType> getSurchargeList() {
            return surchargeList;
        }

        /** 
         * Set the list of 'Surcharge' element items. Surcharge detail.
         * 
         * @param list
         */
        public void setSurchargeList(List<FeeSurchargeType> list) {
            surchargeList = list;
        }
    }
}
