
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * STATE/PROVINCE RADIUS QUERY representation.NDC Capability Model: STATE OR PROVINCE QUERY

 ============
 Feature(s)
 ============
 • Query by list of State/ Province Codes
 • Query by list of State/ Province Keywords
 • Preference Level for all or individual Query ParameterGroups
 • Proximity information containing either the requested maximum distance search radius values, or the actual Proximity information (which is typically used to specify the results from the named location radius search.)

 ============
 Metadata
 ============
 • Yes
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StateProvQueryType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="StateCodes" minOccurs="0">
 *       &lt;!-- Reference to inner class StateCodes -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Keywords" minOccurs="0">
 *       &lt;!-- Reference to inner class Keywords -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="StateProvProximityType" name="Proximity" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="PreferenceAttrGroup"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class StateProvQueryType implements Serializable
{
    private StateCodes stateCodes;
    private Keywords keywords;
    private List<StateProvProximityType> proximityList = new ArrayList<StateProvProximityType>();
    private PreferenceAttrGroup preferenceAttrGroup;

    /** 
     * Get the 'StateCodes' element value.
     * 
     * @return value
     */
    public StateCodes getStateCodes() {
        return stateCodes;
    }

    /** 
     * Set the 'StateCodes' element value.
     * 
     * @param stateCodes
     */
    public void setStateCodes(StateCodes stateCodes) {
        this.stateCodes = stateCodes;
    }

    /** 
     * Get the 'Keywords' element value.
     * 
     * @return value
     */
    public Keywords getKeywords() {
        return keywords;
    }

    /** 
     * Set the 'Keywords' element value.
     * 
     * @param keywords
     */
    public void setKeywords(Keywords keywords) {
        this.keywords = keywords;
    }

    /** 
     * Get the list of 'Proximity' element items. State Proximity.

    Notes:
    1. This contains either the requested maximum distance search radius values -or- the actual Proximity information, which is typically used to specify the results from the named location radius search.
     * 
     * @return list
     */
    public List<StateProvProximityType> getProximityList() {
        return proximityList;
    }

    /** 
     * Set the list of 'Proximity' element items. State Proximity.

    Notes:
    1. This contains either the requested maximum distance search radius values -or- the actual Proximity information, which is typically used to specify the results from the named location radius search.
     * 
     * @param list
     */
    public void setProximityList(List<StateProvProximityType> list) {
        proximityList = list;
    }

    /** 
     * Get the 'PreferenceAttrGroup' attributeGroup value.
     * 
     * @return value
     */
    public PreferenceAttrGroup getPreferenceAttrGroup() {
        return preferenceAttrGroup;
    }

    /** 
     * Set the 'PreferenceAttrGroup' attributeGroup value.
     * 
     * @param preferenceAttrGroup
     */
    public void setPreferenceAttrGroup(PreferenceAttrGroup preferenceAttrGroup) {
        this.preferenceAttrGroup = preferenceAttrGroup;
    }
    /** 
     * State Code(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StateCodes" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="StateCode" maxOccurs="unbounded">
     *         &lt;xs:complexType>
     *           &lt;xs:complexContent>
     *             &lt;xs:extension base="xs:string">
     *               &lt;xs:attributeGroup ref="PreferenceAttrGroup"/>
     *             &lt;/xs:extension>
     *           &lt;/xs:complexContent>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class StateCodes implements Serializable
    {
        private List<PreferenceAttrGroup> stateCodeList = new ArrayList<PreferenceAttrGroup>();

        /** 
         * Get the list of 'StateCode' element items. State or Province Code.  Example: NY
         * 
         * @return list
         */
        public List<PreferenceAttrGroup> getStateCodeList() {
            return stateCodeList;
        }

        /** 
         * Set the list of 'StateCode' element items. State or Province Code.  Example: NY
         * 
         * @param list
         */
        public void setStateCodeList(List<PreferenceAttrGroup> list) {
            stateCodeList = list;
        }
    }
    /** 
     * Keyword/ Value Search Criteria.

    Notes:
    1. This capability may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of this capability is not dictated by this specification.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Keywords" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="KeyWord" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class KeyWord -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Keywords implements Serializable
    {
        private List<KeyWord> keyWordList = new ArrayList<KeyWord>();

        /** 
         * Get the list of 'KeyWord' element items.
         * 
         * @return list
         */
        public List<KeyWord> getKeyWordList() {
            return keyWordList;
        }

        /** 
         * Set the list of 'KeyWord' element items.
         * 
         * @param list
         */
        public void setKeyWordList(List<KeyWord> list) {
            keyWordList = list;
        }
        /** 
         * Keyword detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="KeyWord" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="KeyWordType">
         *         &lt;xs:attributeGroup ref="PreferenceAttrGroup"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class KeyWord extends KeyWordType implements Serializable
        {
            private PreferenceAttrGroup preferenceAttrGroup;

            /** 
             * Get the 'PreferenceAttrGroup' attributeGroup value.
             * 
             * @return value
             */
            public PreferenceAttrGroup getPreferenceAttrGroup() {
                return preferenceAttrGroup;
            }

            /** 
             * Set the 'PreferenceAttrGroup' attributeGroup value.
             * 
             * @param preferenceAttrGroup
             */
            public void setPreferenceAttrGroup(
                    PreferenceAttrGroup preferenceAttrGroup) {
                this.preferenceAttrGroup = preferenceAttrGroup;
            }
        }
    }
}
