
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;

/** 
 * Used for Historical Fare Rules retreival
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://ndc.farelogix.com/aug" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketingDateTime">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="xs:date" name="Date"/>
 *       &lt;xs:element type="xs:time" name="Time" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class TicketingDateTime implements Serializable
{
    private LocalDate date;
    private LocalTime time;

    /** 
     * Get the 'Date' element value. Specifies departure or arrival date in ISO 8601 format (yyyy-mm-dd). Example: 2001-12-25
     * 
     * @return value
     */
    public LocalDate getDate() {
        return date;
    }

    /** 
     * Set the 'Date' element value. Specifies departure or arrival date in ISO 8601 format (yyyy-mm-dd). Example: 2001-12-25
     * 
     * @param date
     */
    public void setDate(LocalDate date) {
        this.date = date;
    }

    /** 
     * Get the 'Time' element value. Departure or arrival time in ISO 8601 twenty-four hour clock format. Example: 14:00
     * 
     * @return value
     */
    public LocalTime getTime() {
        return time;
    }

    /** 
     * Set the 'Time' element value. Departure or arrival time in ISO 8601 twenty-four hour clock format. Example: 14:00
     * 
     * @param time
     */
    public void setTime(LocalTime time) {
        this.time = time;
    }
}
