
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for Traveler FORM OF IDENTIFICATION representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelerFOID_Type">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="FOID" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class FOID -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class TravelerFOIDType implements Serializable
{
    private List<FOID> FOIDList = new ArrayList<FOID>();
    private String refs;

    /** 
     * Get the list of 'FOID' element items.
     * 
     * @return list
     */
    public List<FOID> getFOIDList() {
        return FOIDList;
    }

    /** 
     * Set the list of 'FOID' element items.
     * 
     * @param list
     */
    public void setFOIDList(List<FOID> list) {
        FOIDList = list;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Passenger Form of Identification detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FOID" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Type"/>
     *       &lt;xs:element type="xs:string" name="ID"/>
     *       &lt;xs:element type="xs:string" name="Issuer" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FOID implements Serializable
    {
        private String type;
        private String ID;
        private String issuer;

        /** 
         * Get the 'Type' element value. ID form. Examples: PT (passport), CC (credit card), FF (frequent flyer), DL (drivers license)

        Encoding Scheme: IATA Padis Codeset - List for data element 7365 - Processing indicator, coded
         * 
         * @return value
         */
        public String getType() {
            return type;
        }

        /** 
         * Set the 'Type' element value. ID form. Examples: PT (passport), CC (credit card), FF (frequent flyer), DL (drivers license)

        Encoding Scheme: IATA Padis Codeset - List for data element 7365 - Processing indicator, coded
         * 
         * @param type
         */
        public void setType(String type) {
            this.type = type;
        }

        /** 
         * Get the 'ID' element value. FOID ID value. Example: NY122345
         * 
         * @return value
         */
        public String getID() {
            return ID;
        }

        /** 
         * Set the 'ID' element value. FOID ID value. Example: NY122345
         * 
         * @param ID
         */
        public void setID(String ID) {
            this.ID = ID;
        }

        /** 
         * Get the 'Issuer' element value. Owner/ Issuer of FOID. Example: United State Department Of State
         * 
         * @return value
         */
        public String getIssuer() {
            return issuer;
        }

        /** 
         * Set the 'Issuer' element value. Owner/ Issuer of FOID. Example: United State Department Of State
         * 
         * @param issuer
         */
        public void setIssuer(String issuer) {
            this.issuer = issuer;
        }
    }
}
