
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * A base type for a Transaction Processing Object.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TrxProcessObjectBaseType">
 *   &lt;xs:attributeGroup ref="TrxProcessObjAttrGroup"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="AuthResponseInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="MaximumTryInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="NotProcessedInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="RetryInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="AuthRequestInd"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TrxProcessObjectBaseType implements Serializable
{
    private TrxProcessObjAttrGroup trxProcessObjAttrGroup;
    private Boolean authResponseInd;
    private Boolean maximumTryInd;
    private Boolean notProcessedInd;
    private Boolean retryInd;
    private Boolean authRequestInd;

    /** 
     * Get the 'TrxProcessObjAttrGroup' attributeGroup value. Unique instance ID and object association(s).
     * 
     * @return value
     */
    public TrxProcessObjAttrGroup getTrxProcessObjAttrGroup() {
        return trxProcessObjAttrGroup;
    }

    /** 
     * Set the 'TrxProcessObjAttrGroup' attributeGroup value. Unique instance ID and object association(s).
     * 
     * @param trxProcessObjAttrGroup
     */
    public void setTrxProcessObjAttrGroup(
            TrxProcessObjAttrGroup trxProcessObjAttrGroup) {
        this.trxProcessObjAttrGroup = trxProcessObjAttrGroup;
    }

    /** 
     * Get the 'AuthResponseInd' attribute value. When true, Payer Authentication Response information is specified in the PayerAuth node.
     * 
     * @return value
     */
    public Boolean getAuthResponseInd() {
        return authResponseInd;
    }

    /** 
     * Set the 'AuthResponseInd' attribute value. When true, Payer Authentication Response information is specified in the PayerAuth node.
     * 
     * @param authResponseInd
     */
    public void setAuthResponseInd(Boolean authResponseInd) {
        this.authResponseInd = authResponseInd;
    }

    /** 
     * Get the 'MaximumTryInd' attribute value. When true, the maximum payment authentication attemps have been exceeded.
     * 
     * @return value
     */
    public Boolean getMaximumTryInd() {
        return maximumTryInd;
    }

    /** 
     * Set the 'MaximumTryInd' attribute value. When true, the maximum payment authentication attemps have been exceeded.
     * 
     * @param maximumTryInd
     */
    public void setMaximumTryInd(Boolean maximumTryInd) {
        this.maximumTryInd = maximumTryInd;
    }

    /** 
     * Get the 'NotProcessedInd' attribute value. When true, the Payment information has not been processed.
     * 
     * @return value
     */
    public Boolean getNotProcessedInd() {
        return notProcessedInd;
    }

    /** 
     * Set the 'NotProcessedInd' attribute value. When true, the Payment information has not been processed.
     * 
     * @param notProcessedInd
     */
    public void setNotProcessedInd(Boolean notProcessedInd) {
        this.notProcessedInd = notProcessedInd;
    }

    /** 
     * Get the 'RetryInd' attribute value. When true, the payment transaction should be resent.
     * 
     * @return value
     */
    public Boolean getRetryInd() {
        return retryInd;
    }

    /** 
     * Set the 'RetryInd' attribute value. When true, the payment transaction should be resent.
     * 
     * @param retryInd
     */
    public void setRetryInd(Boolean retryInd) {
        this.retryInd = retryInd;
    }

    /** 
     * Get the 'AuthRequestInd' attribute value. When true, Payer Authentication Request information is specified in the PayerAuth node.
     * 
     * @return value
     */
    public Boolean getAuthRequestInd() {
        return authRequestInd;
    }

    /** 
     * Set the 'AuthRequestInd' attribute value. When true, Payer Authentication Request information is specified in the PayerAuth node.
     * 
     * @param authRequestInd
     */
    public void setAuthRequestInd(Boolean authRequestInd) {
        this.authRequestInd = authRequestInd;
    }
}
