
package org.datacontract.schemas.radixx.connectpoint;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enumerations.ARTransactionTypes">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="BeginningBalance"/>
 *     &lt;xs:enumeration value="Payment"/>
 *     &lt;xs:enumeration value="Confirmation"/>
 *     &lt;xs:enumeration value="OnAccountPayment"/>
 *     &lt;xs:enumeration value="CreditMemo"/>
 *     &lt;xs:enumeration value="BadDebtWriteoff"/>
 *     &lt;xs:enumeration value="Invoice"/>
 *     &lt;xs:enumeration value="Undefined"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumerationsARTransactionTypes {
    BEGINNING_BALANCE("BeginningBalance"), PAYMENT("Payment"), CONFIRMATION(
            "Confirmation"), ON_ACCOUNT_PAYMENT("OnAccountPayment"), CREDIT_MEMO(
            "CreditMemo"), BAD_DEBT_WRITEOFF("BadDebtWriteoff"), /** 
                                                                  * 
                                                                 <summary> Invoice Enum </summary>
                                                                 <remarks> THU: 02/18/2015 This Enum was added for DT75385 to be
                                                                 used by the Transaction Report The actual Type for a Manual
                                                                 Invoice is still 2, but we needed the a new value so it would
                                                                 ""translate"" accordingly in the response". The report sproc
                                                                 should be returning a 6 for a manual invoice.
                                                                 </remarks>
                                                                 
                                                                  */
    INVOICE("Invoice"), UNDEFINED("Undefined");
    private final String value;

    private EnumerationsARTransactionTypes(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumerationsARTransactionTypes convert(String value) {
        for (EnumerationsARTransactionTypes inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
