
package org.datacontract.schemas.radixx.connectpoint;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enumerations.ContactTypes">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="HomePhone"/>
 *     &lt;xs:enumeration value="WorkPhone"/>
 *     &lt;xs:enumeration value="MobilePhone"/>
 *     &lt;xs:enumeration value="Pager"/>
 *     &lt;xs:enumeration value="Email"/>
 *     &lt;xs:enumeration value="Fax"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumerationsContactTypes {
    HOME_PHONE("HomePhone"), WORK_PHONE("WorkPhone"), MOBILE_PHONE(
            "MobilePhone"), PAGER("Pager"), EMAIL("Email"), FAX("Fax");
    private final String value;

    private EnumerationsContactTypes(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumerationsContactTypes convert(String value) {
        for (EnumerationsContactTypes inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
