
package org.datacontract.schemas.radixx.connectpoint;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enumerations.PNRStatus">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Cancelled"/>
 *     &lt;xs:enumeration value="Flown"/>
 *     &lt;xs:enumeration value="Confirm"/>
 *     &lt;xs:enumeration value="All"/>
 *     &lt;xs:enumeration value="PaymentOutstanding"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumerationsPNRStatus {
    CANCELLED("Cancelled"), FLOWN("Flown"), CONFIRM("Confirm"), ALL("All"), PAYMENT_OUTSTANDING(
            "PaymentOutstanding");
    private final String value;

    private EnumerationsPNRStatus(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumerationsPNRStatus convert(String value) {
        for (EnumerationsPNRStatus inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
