
package org.datacontract.schemas.radixx.connectpoint;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enumerations.TaxTypes">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Standard"/>
 *     &lt;xs:enumeration value="VAT"/>
 *     &lt;xs:enumeration value="FEE"/>
 *     &lt;xs:enumeration value="SVAT"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumerationsTaxTypes {
    STANDARD("Standard"), VAT("VAT"), FEE("FEE"), SVAT("SVAT");
    private final String value;

    private EnumerationsTaxTypes(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumerationsTaxTypes convert(String value) {
        for (EnumerationsTaxTypes inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
