
package org.datacontract.schemas.radixx.connectpoint;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enumerations.TravelAgencyTypes">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Corporation"/>
 *     &lt;xs:enumeration value="ParentTravelAgent"/>
 *     &lt;xs:enumeration value="ChildTravelAgent"/>
 *     &lt;xs:enumeration value="AtoCto"/>
 *     &lt;xs:enumeration value="ChildCtoAtoAgent"/>
 *     &lt;xs:enumeration value="Undefined"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumerationsTravelAgencyTypes {
    CORPORATION("Corporation"), PARENT_TRAVEL_AGENT("ParentTravelAgent"), CHILD_TRAVEL_AGENT(
            "ChildTravelAgent"), ATO_CTO("AtoCto"), CHILD_CTO_ATO_AGENT(
            "ChildCtoAtoAgent"), UNDEFINED("Undefined");
    private final String value;

    private EnumerationsTravelAgencyTypes(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumerationsTravelAgencyTypes convert(String value) {
        for (EnumerationsTravelAgencyTypes inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
