
package org.datacontract.schemas.radixx.connectpoint.fulfillment;

import org.datacontract.schemas.radixx.connectpoint.ReservationInfo;
import org.datacontract.schemas.radixx.connectpoint.TransactionInfo;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Fulfillment.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AddVoucherToReservation">
 *   &lt;xs:complexContent mixed="false">
 *     &lt;xs:extension base="ns:TransactionInfo">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:ReservationInfo" nillable="true" name="ReservationInfo"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="VoucherNumber"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AddVoucherToReservation extends TransactionInfo
{
    private ReservationInfo reservationInfo;
    private String voucherNumber;

    /** 
     * Get the 'ReservationInfo' element value. Description: .Constraints: Required.
     * 
     * @return value
     */
    public ReservationInfo getReservationInfo() {
        return reservationInfo;
    }

    /** 
     * Set the 'ReservationInfo' element value. Description: .Constraints: Required.
     * 
     * @param reservationInfo
     */
    public void setReservationInfo(ReservationInfo reservationInfo) {
        this.reservationInfo = reservationInfo;
    }

    /** 
     * Get the 'VoucherNumber' element value. 
    							Description: Expects the numeric voucher number which can be retrieved by
    							performing call to GetVoucherInfo which is currently on the
    							TPAPI.
    						Constraints: Required.Range: Length must be in the range 1 and 20.
    						
     * 
     * @return value
     */
    public String getVoucherNumber() {
        return voucherNumber;
    }

    /** 
     * Set the 'VoucherNumber' element value. 
    							Description: Expects the numeric voucher number which can be retrieved by
    							performing call to GetVoucherInfo which is currently on the
    							TPAPI.
    						Constraints: Required.Range: Length must be in the range 1 and 20.
    						
     * 
     * @param voucherNumber
     */
    public void setVoucherNumber(String voucherNumber) {
        this.voucherNumber = voucherNumber;
    }
}
