
package org.datacontract.schemas.radixx.connectpoint.fulfillment;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Fulfillment.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PNRPayments.ActionTypes">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="ProcessPNRPayment"/>
 *     &lt;xs:enumeration value="ProcessCrossAgencyPayments"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum PNRPaymentsActionTypes {
    /** 
     * 
    <summary>ProcessPNRPayment</summary>
    
     */
    PROCESS_PNR_PAYMENT("ProcessPNRPayment"), /** 
                                               * 
                                              <summary>Process Cross Agency Payments</summary>
                                              
                                               */
    PROCESS_CROSS_AGENCY_PAYMENTS("ProcessCrossAgencyPayments");
    private final String value;

    private PNRPaymentsActionTypes(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static PNRPaymentsActionTypes convert(String value) {
        for (PNRPaymentsActionTypes inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
