
package org.datacontract.schemas.radixx.connectpoint.fulfillment;

import java.math.BigDecimal;
import java.util.Date;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsCurrencyCodeTypes;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsPaymentMethodTypes;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsPaymentTransactionStatusTypes;
import org.datacontract.schemas.radixx.connectpoint.reservation.Person;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Fulfillment.Request" xmlns:ns2="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payment">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:decimal" name="BaseAmount"/>
 *     &lt;xs:element type="ns:Enumerations.CurrencyCodeTypes" name="BaseCurrency"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CardHolder"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CardNumber"/>
 *     &lt;xs:element type="xs:decimal" name="CheckNumber"/>
 *     &lt;xs:element type="ns:Enumerations.CurrencyCodeTypes" name="CurrencyPaid"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CVCode"/>
 *     &lt;xs:element type="xs:dateTime" name="DatePaid"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="DocumentReceivedBy"/>
 *     &lt;xs:element type="xs:dateTime" name="ExpirationDate"/>
 *     &lt;xs:element type="xs:decimal" name="ExchangeRate"/>
 *     &lt;xs:element type="xs:dateTime" name="ExchangeRateDate"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FFNumber"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="PaymentComment"/>
 *     &lt;xs:element type="xs:decimal" name="PaymentAmount"/>
 *     &lt;xs:element type="ns:Enumerations.PaymentMethodTypes" name="PaymentMethod"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Reference"/>
 *     &lt;xs:element type="xs:int" name="TerminalID"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="UserData"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="UserID"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="IataNumber"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ValueCode"/>
 *     &lt;xs:element type="xs:long" name="VoucherNumber"/>
 *     &lt;xs:element type="xs:boolean" name="IsTACreditCard"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="GcxID"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="GcxOptOption"/>
 *     &lt;xs:element type="ns:Enumerations.CurrencyCodeTypes" name="OriginalCurrency"/>
 *     &lt;xs:element type="xs:decimal" name="OriginalAmount"/>
 *     &lt;xs:element type="ns:Enumerations.PaymentTransactionStatusTypes" name="TransactionStatus"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="AuthorizationCode"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="PaymentReference"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ResponseMessage"/>
 *     &lt;xs:element type="ns:Enumerations.CurrencyCodeTypes" name="CardCurrency"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="BillingCountry"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FingerPrintingSessionID"/>
 *     &lt;xs:element type="ns2:Person" nillable="true" name="Payor"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Result" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="TransactionID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ResponseCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="AncillaryData01" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="AncillaryData02" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="AncillaryData03" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="AncillaryData04" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="AncillaryData05" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ProcessorID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="MerchantID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ProcessorName" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Payment
{
    private BigDecimal baseAmount;
    private EnumerationsCurrencyCodeTypes baseCurrency;
    private String cardHolder;
    private String cardNumber;
    private BigDecimal checkNumber;
    private EnumerationsCurrencyCodeTypes currencyPaid;
    private String CVCode;
    private Date datePaid;
    private String documentReceivedBy;
    private Date expirationDate;
    private BigDecimal exchangeRate;
    private Date exchangeRateDate;
    private String FFNumber;
    private String paymentComment;
    private BigDecimal paymentAmount;
    private EnumerationsPaymentMethodTypes paymentMethod;
    private String reference;
    private int terminalID;
    private String userData;
    private String userID;
    private String iataNumber;
    private String valueCode;
    private long voucherNumber;
    private boolean isTACreditCard;
    private String gcxID;
    private String gcxOptOption;
    private EnumerationsCurrencyCodeTypes originalCurrency;
    private BigDecimal originalAmount;
    private EnumerationsPaymentTransactionStatusTypes transactionStatus;
    private String authorizationCode;
    private String paymentReference;
    private String responseMessage;
    private EnumerationsCurrencyCodeTypes cardCurrency;
    private String billingCountry;
    private String fingerPrintingSessionID;
    private Person payor;
    private String result;
    private String transactionID;
    private String responseCode;
    private String ancillaryData01;
    private String ancillaryData02;
    private String ancillaryData03;
    private String ancillaryData04;
    private String ancillaryData05;
    private String processorID;
    private String merchantID;
    private String processorName;

    /** 
     * Get the 'BaseAmount' element value. 
    					Description: The amount of the payment in the Reporting Currency.
    				Constraints: Required.
     * 
     * @return value
     */
    public BigDecimal getBaseAmount() {
        return baseAmount;
    }

    /** 
     * Set the 'BaseAmount' element value. 
    					Description: The amount of the payment in the Reporting Currency.
    				Constraints: Required.
     * 
     * @param baseAmount
     */
    public void setBaseAmount(BigDecimal baseAmount) {
        this.baseAmount = baseAmount;
    }

    /** 
     * Get the 'BaseCurrency' element value. Description: The Reporting Currency of the
    					system.Constraints: Required.
     * 
     * @return value
     */
    public EnumerationsCurrencyCodeTypes getBaseCurrency() {
        return baseCurrency;
    }

    /** 
     * Set the 'BaseCurrency' element value. Description: The Reporting Currency of the
    					system.Constraints: Required.
     * 
     * @param baseCurrency
     */
    public void setBaseCurrency(EnumerationsCurrencyCodeTypes baseCurrency) {
        this.baseCurrency = baseCurrency;
    }

    /** 
     * Get the 'CardHolder' element value. 
    					Description: The name of the cardholder of the payment in the event that the
    					payment is a credit card payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCardHolder() {
        return cardHolder;
    }

    /** 
     * Set the 'CardHolder' element value. 
    					Description: The name of the cardholder of the payment in the event that the
    					payment is a credit card payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param cardHolder
     */
    public void setCardHolder(String cardHolder) {
        this.cardHolder = cardHolder;
    }

    /** 
     * Get the 'CardNumber' element value. 
    					Description: The credit card number for the payment. NOTE: This value will be
    					masked.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCardNumber() {
        return cardNumber;
    }

    /** 
     * Set the 'CardNumber' element value. 
    					Description: The credit card number for the payment. NOTE: This value will be
    					masked.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param cardNumber
     */
    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    /** 
     * Get the 'CheckNumber' element value. 
    					Description: The check number for the payment if this payment was made by
    					check.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getCheckNumber() {
        return checkNumber;
    }

    /** 
     * Set the 'CheckNumber' element value. 
    					Description: The check number for the payment if this payment was made by
    					check.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param checkNumber
     */
    public void setCheckNumber(BigDecimal checkNumber) {
        this.checkNumber = checkNumber;
    }

    /** 
     * Get the 'CurrencyPaid' element value. Description: The currency for this payment.
    				Constraints: Required.
     * 
     * @return value
     */
    public EnumerationsCurrencyCodeTypes getCurrencyPaid() {
        return currencyPaid;
    }

    /** 
     * Set the 'CurrencyPaid' element value. Description: The currency for this payment.
    				Constraints: Required.
     * 
     * @param currencyPaid
     */
    public void setCurrencyPaid(EnumerationsCurrencyCodeTypes currencyPaid) {
        this.currencyPaid = currencyPaid;
    }

    /** 
     * Get the 'CVCode' element value. 
    					Description: The CVV code on the back of most credit cards.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 3 and 5.
    				
     * 
     * @return value
     */
    public String getCVCode() {
        return CVCode;
    }

    /** 
     * Set the 'CVCode' element value. 
    					Description: The CVV code on the back of most credit cards.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 3 and 5.
    				
     * 
     * @param CVCode
     */
    public void setCVCode(String CVCode) {
        this.CVCode = CVCode;
    }

    /** 
     * Get the 'DatePaid' element value. 
    					Description: The accounting date, in GMT, for this payment.
    				Constraints: Required.
     * 
     * @return value
     */
    public Date getDatePaid() {
        return datePaid;
    }

    /** 
     * Set the 'DatePaid' element value. 
    					Description: The accounting date, in GMT, for this payment.
    				Constraints: Required.
     * 
     * @param datePaid
     */
    public void setDatePaid(Date datePaid) {
        this.datePaid = datePaid;
    }

    /** 
     * Get the 'DocumentReceivedBy' element value. Description: .Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 255.
    				
     * 
     * @return value
     */
    public String getDocumentReceivedBy() {
        return documentReceivedBy;
    }

    /** 
     * Set the 'DocumentReceivedBy' element value. Description: .Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 255.
    				
     * 
     * @param documentReceivedBy
     */
    public void setDocumentReceivedBy(String documentReceivedBy) {
        this.documentReceivedBy = documentReceivedBy;
    }

    /** 
     * Get the 'ExpirationDate' element value. 
    					Description: The expiration date for the payment type when applicable.
    				Constraints: Required.
     * 
     * @return value
     */
    public Date getExpirationDate() {
        return expirationDate;
    }

    /** 
     * Set the 'ExpirationDate' element value. 
    					Description: The expiration date for the payment type when applicable.
    				Constraints: Required.
     * 
     * @param expirationDate
     */
    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    /** 
     * Get the 'ExchangeRate' element value. 
    					Description: The exchange rate used to convert from the payment amount in the
    					CurrencyPaid to the ReservationCurrency.
    				Constraints: Required.
     * 
     * @return value
     */
    public BigDecimal getExchangeRate() {
        return exchangeRate;
    }

    /** 
     * Set the 'ExchangeRate' element value. 
    					Description: The exchange rate used to convert from the payment amount in the
    					CurrencyPaid to the ReservationCurrency.
    				Constraints: Required.
     * 
     * @param exchangeRate
     */
    public void setExchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    /** 
     * Get the 'ExchangeRateDate' element value. 
    					Description: The effect date of the exchange rate used to convert from the
    					payment amount in the CurrencyPaid to the ReservationCurrency.
    				Constraints: Required.
     * 
     * @return value
     */
    public Date getExchangeRateDate() {
        return exchangeRateDate;
    }

    /** 
     * Set the 'ExchangeRateDate' element value. 
    					Description: The effect date of the exchange rate used to convert from the
    					payment amount in the CurrencyPaid to the ReservationCurrency.
    				Constraints: Required.
     * 
     * @param exchangeRateDate
     */
    public void setExchangeRateDate(Date exchangeRateDate) {
        this.exchangeRateDate = exchangeRateDate;
    }

    /** 
     * Get the 'FFNumber' element value. 
    					Description: The frequent flyer number for the passenger making this payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getFFNumber() {
        return FFNumber;
    }

    /** 
     * Set the 'FFNumber' element value. 
    					Description: The frequent flyer number for the passenger making this payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param FFNumber
     */
    public void setFFNumber(String FFNumber) {
        this.FFNumber = FFNumber;
    }

    /** 
     * Get the 'PaymentComment' element value. 
    					Description: Any comments added to the payment by the Call Center user or
    					application.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getPaymentComment() {
        return paymentComment;
    }

    /** 
     * Set the 'PaymentComment' element value. 
    					Description: Any comments added to the payment by the Call Center user or
    					application.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param paymentComment
     */
    public void setPaymentComment(String paymentComment) {
        this.paymentComment = paymentComment;
    }

    /** 
     * Get the 'PaymentAmount' element value. 
    					Description: The amount for the payment in the payment currency in the
    					CurrencyPaid field.
    				Constraints: Required.
     * 
     * @return value
     */
    public BigDecimal getPaymentAmount() {
        return paymentAmount;
    }

    /** 
     * Set the 'PaymentAmount' element value. 
    					Description: The amount for the payment in the payment currency in the
    					CurrencyPaid field.
    				Constraints: Required.
     * 
     * @param paymentAmount
     */
    public void setPaymentAmount(BigDecimal paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    /** 
     * Get the 'PaymentMethod' element value. Description: The method or type of payment.
    				Constraints: Required.
     * 
     * @return value
     */
    public EnumerationsPaymentMethodTypes getPaymentMethod() {
        return paymentMethod;
    }

    /** 
     * Set the 'PaymentMethod' element value. Description: The method or type of payment.
    				Constraints: Required.
     * 
     * @param paymentMethod
     */
    public void setPaymentMethod(EnumerationsPaymentMethodTypes paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    /** 
     * Get the 'Reference' element value. 
    					Description: A Reference code that can be used for refunds that is used by
    					certain credit card processors.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 50.
    				
     * 
     * @return value
     */
    public String getReference() {
        return reference;
    }

    /** 
     * Set the 'Reference' element value. 
    					Description: A Reference code that can be used for refunds that is used by
    					certain credit card processors.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 50.
    				
     * 
     * @param reference
     */
    public void setReference(String reference) {
        this.reference = reference;
    }

    /** 
     * Get the 'TerminalID' element value. 
    					Description: Integer representing the credit card terminal that processed this
    					transaction.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public int getTerminalID() {
        return terminalID;
    }

    /** 
     * Set the 'TerminalID' element value. 
    					Description: Integer representing the credit card terminal that processed this
    					transaction.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param terminalID
     */
    public void setTerminalID(int terminalID) {
        this.terminalID = terminalID;
    }

    /** 
     * Get the 'UserData' element value. Description: Any miscellaneous user data.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getUserData() {
        return userData;
    }

    /** 
     * Set the 'UserData' element value. Description: Any miscellaneous user data.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param userData
     */
    public void setUserData(String userData) {
        this.userData = userData;
    }

    /** 
     * Get the 'UserID' element value. 
    					Description: The user ID of the person or system processing the payment.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 15.
    				
     * 
     * @return value
     */
    public String getUserID() {
        return userID;
    }

    /** 
     * Set the 'UserID' element value. 
    					Description: The user ID of the person or system processing the payment.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 15.
    				
     * 
     * @param userID
     */
    public void setUserID(String userID) {
        this.userID = userID;
    }

    /** 
     * Get the 'IataNumber' element value. 
    					Description: The IATA number for the agency who's credit limit was used for
    					this payment..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 8.
    				Format: AlphaNumericCodeMixedDotDash.
    				
     * 
     * @return value
     */
    public String getIataNumber() {
        return iataNumber;
    }

    /** 
     * Set the 'IataNumber' element value. 
    					Description: The IATA number for the agency who's credit limit was used for
    					this payment..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 8.
    				Format: AlphaNumericCodeMixedDotDash.
    				
     * 
     * @param iataNumber
     */
    public void setIataNumber(String iataNumber) {
        this.iataNumber = iataNumber;
    }

    /** 
     * Get the 'ValueCode' element value. Description: .Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 4.
    				
     * 
     * @return value
     */
    public String getValueCode() {
        return valueCode;
    }

    /** 
     * Set the 'ValueCode' element value. Description: .Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 4.
    				
     * 
     * @param valueCode
     */
    public void setValueCode(String valueCode) {
        this.valueCode = valueCode;
    }

    /** 
     * Get the 'VoucherNumber' element value. 
    					Description: The voucher number for the Radixx voucher that was used for this
    					payment in the event that this payment is a voucher payment.
    				Constraints: Required.
     * 
     * @return value
     */
    public long getVoucherNumber() {
        return voucherNumber;
    }

    /** 
     * Set the 'VoucherNumber' element value. 
    					Description: The voucher number for the Radixx voucher that was used for this
    					payment in the event that this payment is a voucher payment.
    				Constraints: Required.
     * 
     * @param voucherNumber
     */
    public void setVoucherNumber(long voucherNumber) {
        this.voucherNumber = voucherNumber;
    }

    /** 
     * Get the 'IsTACreditCard' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public boolean isIsTACreditCard() {
        return isTACreditCard;
    }

    /** 
     * Set the 'IsTACreditCard' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param isTACreditCard
     */
    public void setIsTACreditCard(boolean isTACreditCard) {
        this.isTACreditCard = isTACreditCard;
    }

    /** 
     * Get the 'GcxID' element value. 
    					Description: In the event that this payment was made using GCX Dynamic
    					Currency Conversion, this field is the transaction ID received
    					from GCX.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getGcxID() {
        return gcxID;
    }

    /** 
     * Set the 'GcxID' element value. 
    					Description: In the event that this payment was made using GCX Dynamic
    					Currency Conversion, this field is the transaction ID received
    					from GCX.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param gcxID
     */
    public void setGcxID(String gcxID) {
        this.gcxID = gcxID;
    }

    /** 
     * Get the 'GcxOptOption' element value. 
    					Description: In the event that this payment was made using GCX Dynamic
    					Currency Conversion, this field represents the GCX options that
    					was used in the conversion..
    				Constraints: Required.Range: Length must be in the range 1 and 1.
    				
     * 
     * @return value
     */
    public String getGcxOptOption() {
        return gcxOptOption;
    }

    /** 
     * Set the 'GcxOptOption' element value. 
    					Description: In the event that this payment was made using GCX Dynamic
    					Currency Conversion, this field represents the GCX options that
    					was used in the conversion..
    				Constraints: Required.Range: Length must be in the range 1 and 1.
    				
     * 
     * @param gcxOptOption
     */
    public void setGcxOptOption(String gcxOptOption) {
        this.gcxOptOption = gcxOptOption;
    }

    /** 
     * Get the 'OriginalCurrency' element value. 
    					Description: The Original Currency for this payment in the event this payment
    					represents a refund.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public EnumerationsCurrencyCodeTypes getOriginalCurrency() {
        return originalCurrency;
    }

    /** 
     * Set the 'OriginalCurrency' element value. 
    					Description: The Original Currency for this payment in the event this payment
    					represents a refund.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param originalCurrency
     */
    public void setOriginalCurrency(
            EnumerationsCurrencyCodeTypes originalCurrency) {
        this.originalCurrency = originalCurrency;
    }

    /** 
     * Get the 'OriginalAmount' element value. 
    					Description: The Original amount for this payment in the event this payment
    					represents a refund.
    				Constraints: Required.
     * 
     * @return value
     */
    public BigDecimal getOriginalAmount() {
        return originalAmount;
    }

    /** 
     * Set the 'OriginalAmount' element value. 
    					Description: The Original amount for this payment in the event this payment
    					represents a refund.
    				Constraints: Required.
     * 
     * @param originalAmount
     */
    public void setOriginalAmount(BigDecimal originalAmount) {
        this.originalAmount = originalAmount;
    }

    /** 
     * Get the 'TransactionStatus' element value. 
    					Description: The payment effective status for this payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public EnumerationsPaymentTransactionStatusTypes getTransactionStatus() {
        return transactionStatus;
    }

    /** 
     * Set the 'TransactionStatus' element value. 
    					Description: The payment effective status for this payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param transactionStatus
     */
    public void setTransactionStatus(
            EnumerationsPaymentTransactionStatusTypes transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    /** 
     * Get the 'AuthorizationCode' element value. 
    					Description: The authorization code received by the credit card processor
    					authorizing the payment.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 20.
    				
     * 
     * @return value
     */
    public String getAuthorizationCode() {
        return authorizationCode;
    }

    /** 
     * Set the 'AuthorizationCode' element value. 
    					Description: The authorization code received by the credit card processor
    					authorizing the payment.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 20.
    				
     * 
     * @param authorizationCode
     */
    public void setAuthorizationCode(String authorizationCode) {
        this.authorizationCode = authorizationCode;
    }

    /** 
     * Get the 'PaymentReference' element value. 
    					Description: Value Required=C (Required if InsertExternalProcessedPayment).
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 50.
    				
     * 
     * @return value
     */
    public String getPaymentReference() {
        return paymentReference;
    }

    /** 
     * Set the 'PaymentReference' element value. 
    					Description: Value Required=C (Required if InsertExternalProcessedPayment).
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 50.
    				
     * 
     * @param paymentReference
     */
    public void setPaymentReference(String paymentReference) {
        this.paymentReference = paymentReference;
    }

    /** 
     * Get the 'ResponseMessage' element value. 
    					Description: The response message received from certain credit card processors
    					- Note-Value Required=C (Required if
    					InsertExternalProcessedPayment).
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 255.
    				
     * 
     * @return value
     */
    public String getResponseMessage() {
        return responseMessage;
    }

    /** 
     * Set the 'ResponseMessage' element value. 
    					Description: The response message received from certain credit card processors
    					- Note-Value Required=C (Required if
    					InsertExternalProcessedPayment).
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 255.
    				
     * 
     * @param responseMessage
     */
    public void setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
    }

    /** 
     * Get the 'CardCurrency' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public EnumerationsCurrencyCodeTypes getCardCurrency() {
        return cardCurrency;
    }

    /** 
     * Set the 'CardCurrency' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param cardCurrency
     */
    public void setCardCurrency(EnumerationsCurrencyCodeTypes cardCurrency) {
        this.cardCurrency = cardCurrency;
    }

    /** 
     * Get the 'BillingCountry' element value. 
    					Description: This value is routinely required by payment gateways to perform
    					fraud management. Normal value is the country 2 Letter
    					abbreviation but can be the 3 letter country code or the ISO
    					Country code. This varies by payment gateway.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 0 and 3.
    				Format: AlphaNumeric.
     * 
     * @return value
     */
    public String getBillingCountry() {
        return billingCountry;
    }

    /** 
     * Set the 'BillingCountry' element value. 
    					Description: This value is routinely required by payment gateways to perform
    					fraud management. Normal value is the country 2 Letter
    					abbreviation but can be the 3 letter country code or the ISO
    					Country code. This varies by payment gateway.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 0 and 3.
    				Format: AlphaNumeric.
     * 
     * @param billingCountry
     */
    public void setBillingCountry(String billingCountry) {
        this.billingCountry = billingCountry;
    }

    /** 
     * Get the 'FingerPrintingSessionID' element value. 
    					Description: This is the value that is supplied by the front end websites. It
    					contains encrypted data that the payment processors use for
    					matching front end processing data with authorization requests.
    				Constraints: Optional (Not Required).
    				Format: AlphaNumeric.
     * 
     * @return value
     */
    public String getFingerPrintingSessionID() {
        return fingerPrintingSessionID;
    }

    /** 
     * Set the 'FingerPrintingSessionID' element value. 
    					Description: This is the value that is supplied by the front end websites. It
    					contains encrypted data that the payment processors use for
    					matching front end processing data with authorization requests.
    				Constraints: Optional (Not Required).
    				Format: AlphaNumeric.
     * 
     * @param fingerPrintingSessionID
     */
    public void setFingerPrintingSessionID(String fingerPrintingSessionID) {
        this.fingerPrintingSessionID = fingerPrintingSessionID;
    }

    /** 
     * Get the 'Payor' element value. Description: .Constraints: Required.
     * 
     * @return value
     */
    public Person getPayor() {
        return payor;
    }

    /** 
     * Set the 'Payor' element value. Description: .Constraints: Required.
     * 
     * @param payor
     */
    public void setPayor(Person payor) {
        this.payor = payor;
    }

    /** 
     * Get the 'Result' element value. 
    					Description: The result field that is used by certain credit card processors.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getResult() {
        return result;
    }

    /** 
     * Set the 'Result' element value. 
    					Description: The result field that is used by certain credit card processors.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param result
     */
    public void setResult(String result) {
        this.result = result;
    }

    /** 
     * Get the 'TransactionID' element value. 
    					Description: The transaction ID that can be used for refunds by certain credit
    					card processors.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getTransactionID() {
        return transactionID;
    }

    /** 
     * Set the 'TransactionID' element value. 
    					Description: The transaction ID that can be used for refunds by certain credit
    					card processors.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param transactionID
     */
    public void setTransactionID(String transactionID) {
        this.transactionID = transactionID;
    }

    /** 
     * Get the 'ResponseCode' element value. 
    					Description: The response code received from certain credit card processors.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getResponseCode() {
        return responseCode;
    }

    /** 
     * Set the 'ResponseCode' element value. 
    					Description: The response code received from certain credit card processors.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param responseCode
     */
    public void setResponseCode(String responseCode) {
        this.responseCode = responseCode;
    }

    /** 
     * Get the 'AncillaryData01' element value. 
    					Description: Ancillary field 1 used by Radixx to store data specific to
    					certain payment processor types. Please refer to client account
    					manager to query on data stored within.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getAncillaryData01() {
        return ancillaryData01;
    }

    /** 
     * Set the 'AncillaryData01' element value. 
    					Description: Ancillary field 1 used by Radixx to store data specific to
    					certain payment processor types. Please refer to client account
    					manager to query on data stored within.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param ancillaryData01
     */
    public void setAncillaryData01(String ancillaryData01) {
        this.ancillaryData01 = ancillaryData01;
    }

    /** 
     * Get the 'AncillaryData02' element value. 
    					Description: Ancillary field 2 used by Radixx to store data specific to
    					certain payment processor types. Please refer to client account
    					manager to query on data stored within.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getAncillaryData02() {
        return ancillaryData02;
    }

    /** 
     * Set the 'AncillaryData02' element value. 
    					Description: Ancillary field 2 used by Radixx to store data specific to
    					certain payment processor types. Please refer to client account
    					manager to query on data stored within.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param ancillaryData02
     */
    public void setAncillaryData02(String ancillaryData02) {
        this.ancillaryData02 = ancillaryData02;
    }

    /** 
     * Get the 'AncillaryData03' element value. 
    					Description: Ancillary field 3 used by Radixx to store data specific to
    					certain payment processor types. Please refer to client account
    					manager to query on data stored within.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getAncillaryData03() {
        return ancillaryData03;
    }

    /** 
     * Set the 'AncillaryData03' element value. 
    					Description: Ancillary field 3 used by Radixx to store data specific to
    					certain payment processor types. Please refer to client account
    					manager to query on data stored within.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param ancillaryData03
     */
    public void setAncillaryData03(String ancillaryData03) {
        this.ancillaryData03 = ancillaryData03;
    }

    /** 
     * Get the 'AncillaryData04' element value. 
    					Description: Ancillary field 4 used by Radixx to store data specific to
    					certain payment processor types. Please refer to client account
    					manager to query on data stored within.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getAncillaryData04() {
        return ancillaryData04;
    }

    /** 
     * Set the 'AncillaryData04' element value. 
    					Description: Ancillary field 4 used by Radixx to store data specific to
    					certain payment processor types. Please refer to client account
    					manager to query on data stored within.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param ancillaryData04
     */
    public void setAncillaryData04(String ancillaryData04) {
        this.ancillaryData04 = ancillaryData04;
    }

    /** 
     * Get the 'AncillaryData05' element value. 
    					Description: Ancillary field 5 used by Radixx to store data specific to
    					certain payment processor types. Please refer to client account
    					manager to query on data stored within.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getAncillaryData05() {
        return ancillaryData05;
    }

    /** 
     * Set the 'AncillaryData05' element value. 
    					Description: Ancillary field 5 used by Radixx to store data specific to
    					certain payment processor types. Please refer to client account
    					manager to query on data stored within.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param ancillaryData05
     */
    public void setAncillaryData05(String ancillaryData05) {
        this.ancillaryData05 = ancillaryData05;
    }

    /** 
     * Get the 'ProcessorID' element value. 
    					Description: The backend processor ID to be submitted when payment processing
    					is performed outside of Radixx system so that can be used for
    					refunds by certain credit card processors.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getProcessorID() {
        return processorID;
    }

    /** 
     * Set the 'ProcessorID' element value. 
    					Description: The backend processor ID to be submitted when payment processing
    					is performed outside of Radixx system so that can be used for
    					refunds by certain credit card processors.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param processorID
     */
    public void setProcessorID(String processorID) {
        this.processorID = processorID;
    }

    /** 
     * Get the 'MerchantID' element value. 
    					Description: The merchant ID to be submitted when payment processing is
    					performed outside of Radixx system so that can be used for refunds
    					by certain credit card processors.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getMerchantID() {
        return merchantID;
    }

    /** 
     * Set the 'MerchantID' element value. 
    					Description: The merchant ID to be submitted when payment processing is
    					performed outside of Radixx system so that can be used for refunds
    					by certain credit card processors.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param merchantID
     */
    public void setMerchantID(String merchantID) {
        this.merchantID = merchantID;
    }

    /** 
     * Get the 'ProcessorName' element value. 
    					Description: The backend processor name to be submitted when payment
    					processing is performed outside of Radixx system so that can be
    					used for refunds by certain credit card processors.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getProcessorName() {
        return processorName;
    }

    /** 
     * Set the 'ProcessorName' element value. 
    					Description: The backend processor name to be submitted when payment
    					processing is performed outside of Radixx system so that can be
    					used for refunds by certain credit card processors.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param processorName
     */
    public void setProcessorName(String processorName) {
        this.processorName = processorName;
    }
}
