
package org.datacontract.schemas.radixx.connectpoint.fulfillment;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Fulfillment.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UpdateExternalProcessedPayment.ActionTypes">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="UpdateAndProcessMIG3DSecurePayment"/>
 *     &lt;xs:enumeration value="SetNotYetProcessedPaymentsToRejected"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum UpdateExternalProcessedPaymentActionTypes {
    /** 
     * 
    <summary>Process Response from MIGS 3DSecure</summary>
    
     */
    UPDATE_AND_PROCESS_MI_G3_D_SECURE_PAYMENT(
            "UpdateAndProcessMIG3DSecurePayment"), /** 
                                                    * 
                                                   <summary>This will be used in the event there is a failure and the
                                                   front end needs to set the status to rejected.</summary>
                                                   
                                                    */
    SET_NOT_YET_PROCESSED_PAYMENTS_TO_REJECTED(
            "SetNotYetProcessedPaymentsToRejected");
    private final String value;

    private UpdateExternalProcessedPaymentActionTypes(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static UpdateExternalProcessedPaymentActionTypes convert(String value) {
        for (UpdateExternalProcessedPaymentActionTypes inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
