
package org.datacontract.schemas.radixx.connectpoint.fulfillment;

import java.util.Date;
import org.datacontract.schemas.radixx.connectpoint.ReservationInfo;
import org.datacontract.schemas.radixx.connectpoint.TransactionInfo;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Fulfillment.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UpdateTicketingTimeLimit">
 *   &lt;xs:complexContent mixed="false">
 *     &lt;xs:extension base="ns:TransactionInfo">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:ReservationInfo" nillable="true" name="ReservationInfo"/>
 *         &lt;xs:element type="xs:dateTime" name="TicketingTimeLimit"/>
 *         &lt;xs:element type="xs:boolean" name="PayLaterOptionSelected"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class UpdateTicketingTimeLimit extends TransactionInfo
{
    private ReservationInfo reservationInfo;
    private Date ticketingTimeLimit;
    private boolean payLaterOptionSelected;

    /** 
     * Get the 'ReservationInfo' element value. 
    							Description: Reservation Information which is needed to allow for cross
    							check on processing.
    						Constraints: Required.
     * 
     * @return value
     */
    public ReservationInfo getReservationInfo() {
        return reservationInfo;
    }

    /** 
     * Set the 'ReservationInfo' element value. 
    							Description: Reservation Information which is needed to allow for cross
    							check on processing.
    						Constraints: Required.
     * 
     * @param reservationInfo
     */
    public void setReservationInfo(ReservationInfo reservationInfo) {
        this.reservationInfo = reservationInfo;
    }

    /** 
     * Get the 'TicketingTimeLimit' element value. 
    							Description: The Date Time (GMT) that a unpaid PNR will be Cancelled. If a
    							date greater than Date MinValue is supplied then that date stamp
    							will be used as the new ticketing time limit. If the value
    							supplied is Date Minvalue then the ticketing time limit will be
    							set based on the fare rules.
    						Constraints: Required.
     * 
     * @return value
     */
    public Date getTicketingTimeLimit() {
        return ticketingTimeLimit;
    }

    /** 
     * Set the 'TicketingTimeLimit' element value. 
    							Description: The Date Time (GMT) that a unpaid PNR will be Cancelled. If a
    							date greater than Date MinValue is supplied then that date stamp
    							will be used as the new ticketing time limit. If the value
    							supplied is Date Minvalue then the ticketing time limit will be
    							set based on the fare rules.
    						Constraints: Required.
     * 
     * @param ticketingTimeLimit
     */
    public void setTicketingTimeLimit(Date ticketingTimeLimit) {
        this.ticketingTimeLimit = ticketingTimeLimit;
    }

    /** 
     * Get the 'PayLaterOptionSelected' element value. 
    							Description: This is an indicator as to whether this functionality is being
    							called due to a payleter booking.
    						Constraints: Required.
     * 
     * @return value
     */
    public boolean isPayLaterOptionSelected() {
        return payLaterOptionSelected;
    }

    /** 
     * Set the 'PayLaterOptionSelected' element value. 
    							Description: This is an indicator as to whether this functionality is being
    							called due to a payleter booking.
    						Constraints: Required.
     * 
     * @param payLaterOptionSelected
     */
    public void setPayLaterOptionSelected(boolean payLaterOptionSelected) {
        this.payLaterOptionSelected = payLaterOptionSelected;
    }
}
