
package org.datacontract.schemas.radixx.connectpoint.pricing;

/** 
 * 
 <summary>Date Search Type for Fast Fare Search</summary>
 <remarks/>

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Pricing.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enums.DateSearchType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Flexible"/>
 *     &lt;xs:enumeration value="DateRange"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumsDateSearchType {
    /** 
     * 
    <summary>Search 0 to (n) flight days before and after selected
    date</summary>
    
     */
    FLEXIBLE("Flexible"), /** 
                           * 
                          <summary>Search by a specified date range</summary>
                          
                           */
    DATE_RANGE("DateRange");
    private final String value;

    private EnumsDateSearchType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumsDateSearchType convert(String value) {
        for (EnumsDateSearchType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
