
package org.datacontract.schemas.radixx.connectpoint.pricing;

/** 
 * 
 <summary>Changes grouping type for "PerFareType" (When
 FareFilterMethod =
 CombinabilityNestedRoundtripLowestFarePerFareType,
 CombinabilityNestedRoundtripOnlyLowestFarePerFareType,
 NoCombinabilityRoundtripLowestFarePerFareType, and
 NoCombinabilityRoundtripOnlyLowestFarePerFareType)</summary>
 <remarks/>

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Pricing.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enums.FareGroupMethodType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="WebFareTypes"/>
 *     &lt;xs:enumeration value="FareClassFareBasis"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumsFareGroupMethodType {
    /** 
     * 
    <summary>Group by Settings in table WebFareTypes</summary>
    
     */
    WEB_FARE_TYPES("WebFareTypes"), /** 
                                     * 
                                    <summary>Group by Fare Class and Fare Basis Code</summary>
                                    
                                     */
    FARE_CLASS_FARE_BASIS("FareClassFareBasis");
    private final String value;

    private EnumsFareGroupMethodType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumsFareGroupMethodType convert(String value) {
        for (EnumsFareGroupMethodType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
