
package org.datacontract.schemas.radixx.connectpoint.pricing;

/** 
 * 
 <summary>Availability filter options</summary>
 <remarks/>

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Pricing.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enums.InventoryFilterMethodType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Available"/>
 *     &lt;xs:enumeration value="All"/>
 *     &lt;xs:enumeration value="AvailablePreference"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumsInventoryFilterMethodType {
    /** 
     * 
    <summary>Returns only available fares</summary>
    
     */
    AVAILABLE("Available"), /** 
                             * 
                            <summary>Returns all fares (available and sold out fares)</summary>
                            
                             */
    ALL("All"), /** 
                 * 
                			<summary>Returns all fares (available and sold out fares). When
                				fare filters are applied, available fares take precendence over
                				sold out fares</summary>
                		
                 */
    AVAILABLE_PREFERENCE("AvailablePreference");
    private final String value;

    private EnumsInventoryFilterMethodType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumsInventoryFilterMethodType convert(String value) {
        for (EnumsInventoryFilterMethodType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
