
package org.datacontract.schemas.radixx.connectpoint.pricing;

import java.math.BigDecimal;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Pricing.Response" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightDetail">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:int" name="FlightDetailIdentifier"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="OriginLocation"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="DestinationLocation"/>
 *     &lt;xs:element type="xs:dateTime" name="DepartureDate"/>
 *     &lt;xs:element type="xs:dateTime" name="ArrivalDate"/>
 *     &lt;xs:element type="xs:decimal" name="TotalFlightDuration"/>
 *     &lt;xs:element type="xs:int" name="SeatsAvailable"/>
 *     &lt;xs:element type="ns:ArrayOfLegDetailIdentifier" nillable="true" name="LegDetailIdentifiers"/>
 *     &lt;xs:element type="xs:int" name="LogicalFlightID"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FlightDetail
{
    private int flightDetailIdentifier;
    private String originLocation;
    private String destinationLocation;
    private Date departureDate;
    private Date arrivalDate;
    private BigDecimal totalFlightDuration;
    private int seatsAvailable;
    private ArrayOfLegDetailIdentifier legDetailIdentifiers;
    private int logicalFlightID;

    /** 
     * Get the 'FlightDetailIdentifier' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public int getFlightDetailIdentifier() {
        return flightDetailIdentifier;
    }

    /** 
     * Set the 'FlightDetailIdentifier' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param flightDetailIdentifier
     */
    public void setFlightDetailIdentifier(int flightDetailIdentifier) {
        this.flightDetailIdentifier = flightDetailIdentifier;
    }

    /** 
     * Get the 'OriginLocation' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getOriginLocation() {
        return originLocation;
    }

    /** 
     * Set the 'OriginLocation' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param originLocation
     */
    public void setOriginLocation(String originLocation) {
        this.originLocation = originLocation;
    }

    /** 
     * Get the 'DestinationLocation' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getDestinationLocation() {
        return destinationLocation;
    }

    /** 
     * Set the 'DestinationLocation' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param destinationLocation
     */
    public void setDestinationLocation(String destinationLocation) {
        this.destinationLocation = destinationLocation;
    }

    /** 
     * Get the 'DepartureDate' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getDepartureDate() {
        return departureDate;
    }

    /** 
     * Set the 'DepartureDate' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param departureDate
     */
    public void setDepartureDate(Date departureDate) {
        this.departureDate = departureDate;
    }

    /** 
     * Get the 'ArrivalDate' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getArrivalDate() {
        return arrivalDate;
    }

    /** 
     * Set the 'ArrivalDate' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param arrivalDate
     */
    public void setArrivalDate(Date arrivalDate) {
        this.arrivalDate = arrivalDate;
    }

    /** 
     * Get the 'TotalFlightDuration' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getTotalFlightDuration() {
        return totalFlightDuration;
    }

    /** 
     * Set the 'TotalFlightDuration' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param totalFlightDuration
     */
    public void setTotalFlightDuration(BigDecimal totalFlightDuration) {
        this.totalFlightDuration = totalFlightDuration;
    }

    /** 
     * Get the 'SeatsAvailable' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public int getSeatsAvailable() {
        return seatsAvailable;
    }

    /** 
     * Set the 'SeatsAvailable' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param seatsAvailable
     */
    public void setSeatsAvailable(int seatsAvailable) {
        this.seatsAvailable = seatsAvailable;
    }

    /** 
     * Get the 'LegDetailIdentifiers' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public ArrayOfLegDetailIdentifier getLegDetailIdentifiers() {
        return legDetailIdentifiers;
    }

    /** 
     * Set the 'LegDetailIdentifiers' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param legDetailIdentifiers
     */
    public void setLegDetailIdentifiers(
            ArrayOfLegDetailIdentifier legDetailIdentifiers) {
        this.legDetailIdentifiers = legDetailIdentifiers;
    }

    /** 
     * Get the 'LogicalFlightID' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public int getLogicalFlightID() {
        return logicalFlightID;
    }

    /** 
     * Set the 'LogicalFlightID' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param logicalFlightID
     */
    public void setLogicalFlightID(int logicalFlightID) {
        this.logicalFlightID = logicalFlightID;
    }
}
