
package org.datacontract.schemas.radixx.connectpoint.pricing.request;

import java.util.Date;

/** 
 * 
 <summary>Flight leg to search</summary>

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Pricing.Request.FareQuote" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareQuoteDetailDateRange">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="Origin"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Destination"/>
 *     &lt;xs:element type="xs:boolean" name="UseAirportsNotMetroGroups"/>
 *     &lt;xs:element type="xs:boolean" name="UseAirportsNotMetroGroupsAsRule" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="UseAirportsNotMetroGroupsForFrom" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="UseAirportsNotMetroGroupsForTo" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="DateOfDepartureStart"/>
 *     &lt;xs:element type="xs:dateTime" name="DateOfDepartureEnd"/>
 *     &lt;xs:element type="xs:int" name="FareTypeCategory"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FareClass"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FareBasisCode"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Cabin"/>
 *     &lt;xs:element type="xs:int" name="LFID"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="OperatingCarrierCode"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="MarketingCarrierCode"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="LanguageCode"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="TicketPackageID"/>
 *     &lt;xs:element type="ns:ArrayOfFareQuoteRequestInfo" nillable="true" name="FareQuoteRequestInfos"/>
 *     &lt;xs:element type="xs:dateTime" name="OverrideEffectiveDate" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareQuoteDetailDateRange
{
    private String origin;
    private String destination;
    private boolean useAirportsNotMetroGroups;
    private Boolean useAirportsNotMetroGroupsAsRule;
    private Boolean useAirportsNotMetroGroupsForFrom;
    private Boolean useAirportsNotMetroGroupsForTo;
    private Date dateOfDepartureStart;
    private Date dateOfDepartureEnd;
    private int fareTypeCategory;
    private String fareClass;
    private String fareBasisCode;
    private String cabin;
    private int LFID;
    private String operatingCarrierCode;
    private String marketingCarrierCode;
    private String languageCode;
    private String ticketPackageID;
    private ArrayOfFareQuoteRequestInfo fareQuoteRequestInfos;
    private Date overrideEffectiveDate;

    /** 
     * Get the 'Origin' element value. Description: Origin airport code.
    				Constraints: Required.Range: Length must be in the range 3 and 4.
    				Format: AlphaNumericUpper.
     * 
     * @return value
     */
    public String getOrigin() {
        return origin;
    }

    /** 
     * Set the 'Origin' element value. Description: Origin airport code.
    				Constraints: Required.Range: Length must be in the range 3 and 4.
    				Format: AlphaNumericUpper.
     * 
     * @param origin
     */
    public void setOrigin(String origin) {
        this.origin = origin;
    }

    /** 
     * Get the 'Destination' element value. Description: Destination airport code.
    				Constraints: Required.Range: Length must be in the range 3 and 4.
    				Format: AlphaNumericUpper.
     * 
     * @return value
     */
    public String getDestination() {
        return destination;
    }

    /** 
     * Set the 'Destination' element value. Description: Destination airport code.
    				Constraints: Required.Range: Length must be in the range 3 and 4.
    				Format: AlphaNumericUpper.
     * 
     * @param destination
     */
    public void setDestination(String destination) {
        this.destination = destination;
    }

    /** 
     * Get the 'UseAirportsNotMetroGroups' element value. 
    					Description: A value of True indicates that the Origin and Destination are
    					airport codes. False indicates they are metro groups.
    				Constraints: Required.
     * 
     * @return value
     */
    public boolean isUseAirportsNotMetroGroups() {
        return useAirportsNotMetroGroups;
    }

    /** 
     * Set the 'UseAirportsNotMetroGroups' element value. 
    					Description: A value of True indicates that the Origin and Destination are
    					airport codes. False indicates they are metro groups.
    				Constraints: Required.
     * 
     * @param useAirportsNotMetroGroups
     */
    public void setUseAirportsNotMetroGroups(boolean useAirportsNotMetroGroups) {
        this.useAirportsNotMetroGroups = useAirportsNotMetroGroups;
    }

    /** 
     * Get the 'UseAirportsNotMetroGroupsAsRule' element value. 
    					Description: This determines if the general rule of UseAirportsNotMetroGroups
    					will be used, by default the value is True . False indicates the
    					settings UseAirportsNotMetroGroupsForFrom and
    					UseAirportsNotMetroGroupsForTo will be used..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Boolean getUseAirportsNotMetroGroupsAsRule() {
        return useAirportsNotMetroGroupsAsRule;
    }

    /** 
     * Set the 'UseAirportsNotMetroGroupsAsRule' element value. 
    					Description: This determines if the general rule of UseAirportsNotMetroGroups
    					will be used, by default the value is True . False indicates the
    					settings UseAirportsNotMetroGroupsForFrom and
    					UseAirportsNotMetroGroupsForTo will be used..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param useAirportsNotMetroGroupsAsRule
     */
    public void setUseAirportsNotMetroGroupsAsRule(
            Boolean useAirportsNotMetroGroupsAsRule) {
        this.useAirportsNotMetroGroupsAsRule = useAirportsNotMetroGroupsAsRule;
    }

    /** 
     * Get the 'UseAirportsNotMetroGroupsForFrom' element value. 
    					Description: A value of True indicates that the From code provided is either
    					Airport code or metro group, also this value will only be
    					evaluated if UseAirportsNotMetroGroupsAsRule is False (default is
    					true) . False indicates they are metro groups..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Boolean getUseAirportsNotMetroGroupsForFrom() {
        return useAirportsNotMetroGroupsForFrom;
    }

    /** 
     * Set the 'UseAirportsNotMetroGroupsForFrom' element value. 
    					Description: A value of True indicates that the From code provided is either
    					Airport code or metro group, also this value will only be
    					evaluated if UseAirportsNotMetroGroupsAsRule is False (default is
    					true) . False indicates they are metro groups..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param useAirportsNotMetroGroupsForFrom
     */
    public void setUseAirportsNotMetroGroupsForFrom(
            Boolean useAirportsNotMetroGroupsForFrom) {
        this.useAirportsNotMetroGroupsForFrom = useAirportsNotMetroGroupsForFrom;
    }

    /** 
     * Get the 'UseAirportsNotMetroGroupsForTo' element value. 
    					Description: A value of True indicates that the To code provided is either
    					Airport code or metro group, also this value will only be
    					evaluated if UseAirportsNotMetroGroupsAsRule is False (default is
    					true) . False indicates they are metro groups..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Boolean getUseAirportsNotMetroGroupsForTo() {
        return useAirportsNotMetroGroupsForTo;
    }

    /** 
     * Set the 'UseAirportsNotMetroGroupsForTo' element value. 
    					Description: A value of True indicates that the To code provided is either
    					Airport code or metro group, also this value will only be
    					evaluated if UseAirportsNotMetroGroupsAsRule is False (default is
    					true) . False indicates they are metro groups..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param useAirportsNotMetroGroupsForTo
     */
    public void setUseAirportsNotMetroGroupsForTo(
            Boolean useAirportsNotMetroGroupsForTo) {
        this.useAirportsNotMetroGroupsForTo = useAirportsNotMetroGroupsForTo;
    }

    /** 
     * Get the 'DateOfDepartureStart' element value. 
    					Description: The starting date of the departure date range.
    				Constraints: Required.
     * 
     * @return value
     */
    public Date getDateOfDepartureStart() {
        return dateOfDepartureStart;
    }

    /** 
     * Set the 'DateOfDepartureStart' element value. 
    					Description: The starting date of the departure date range.
    				Constraints: Required.
     * 
     * @param dateOfDepartureStart
     */
    public void setDateOfDepartureStart(Date dateOfDepartureStart) {
        this.dateOfDepartureStart = dateOfDepartureStart;
    }

    /** 
     * Get the 'DateOfDepartureEnd' element value. 
    					Description: The ending date of the departure date range.
    				Constraints: Required.
     * 
     * @return value
     */
    public Date getDateOfDepartureEnd() {
        return dateOfDepartureEnd;
    }

    /** 
     * Set the 'DateOfDepartureEnd' element value. 
    					Description: The ending date of the departure date range.
    				Constraints: Required.
     * 
     * @param dateOfDepartureEnd
     */
    public void setDateOfDepartureEnd(Date dateOfDepartureEnd) {
        this.dateOfDepartureEnd = dateOfDepartureEnd;
    }

    /** 
     * Get the 'FareTypeCategory' element value. 
    					Description: Limit the search results to this fare type category (alias:
    					sub_web_fare_type.
    				Constraints: Required.
    					Range: Value must be in the range 0 and 2147483647.
    				
     * 
     * @return value
     */
    public int getFareTypeCategory() {
        return fareTypeCategory;
    }

    /** 
     * Set the 'FareTypeCategory' element value. 
    					Description: Limit the search results to this fare type category (alias:
    					sub_web_fare_type.
    				Constraints: Required.
    					Range: Value must be in the range 0 and 2147483647.
    				
     * 
     * @param fareTypeCategory
     */
    public void setFareTypeCategory(int fareTypeCategory) {
        this.fareTypeCategory = fareTypeCategory;
    }

    /** 
     * Get the 'FareClass' element value. 
    					Description: Limit the search results to this fare class.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 2.
    				Format: AlphaNumericCode.
     * 
     * @return value
     */
    public String getFareClass() {
        return fareClass;
    }

    /** 
     * Set the 'FareClass' element value. 
    					Description: Limit the search results to this fare class.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 2.
    				Format: AlphaNumericCode.
     * 
     * @param fareClass
     */
    public void setFareClass(String fareClass) {
        this.fareClass = fareClass;
    }

    /** 
     * Get the 'FareBasisCode' element value. 
    					Description: Limit the search results to this fare basis code.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 15.
    				Format: AlphaNumericCode.
     * 
     * @return value
     */
    public String getFareBasisCode() {
        return fareBasisCode;
    }

    /** 
     * Set the 'FareBasisCode' element value. 
    					Description: Limit the search results to this fare basis code.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 15.
    				Format: AlphaNumericCode.
     * 
     * @param fareBasisCode
     */
    public void setFareBasisCode(String fareBasisCode) {
        this.fareBasisCode = fareBasisCode;
    }

    /** 
     * Get the 'Cabin' element value. 
    					Description: Limit the search results to this cabin.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 13.
    				Format: AlphaNumericCode.
     * 
     * @return value
     */
    public String getCabin() {
        return cabin;
    }

    /** 
     * Set the 'Cabin' element value. 
    					Description: Limit the search results to this cabin.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 13.
    				Format: AlphaNumericCode.
     * 
     * @param cabin
     */
    public void setCabin(String cabin) {
        this.cabin = cabin;
    }

    /** 
     * Get the 'LFID' element value. 
    					Description: Limit the search results to this logical flight ID. (-1 for no
    					filter.
    				Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @return value
     */
    public int getLFID() {
        return LFID;
    }

    /** 
     * Set the 'LFID' element value. 
    					Description: Limit the search results to this logical flight ID. (-1 for no
    					filter.
    				Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @param LFID
     */
    public void setLFID(int LFID) {
        this.LFID = LFID;
    }

    /** 
     * Get the 'OperatingCarrierCode' element value. 
    					Description: Limit the search results to this operating carrier code.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 0 and 3.
    				Format: AlphaNumericUpper.
     * 
     * @return value
     */
    public String getOperatingCarrierCode() {
        return operatingCarrierCode;
    }

    /** 
     * Set the 'OperatingCarrierCode' element value. 
    					Description: Limit the search results to this operating carrier code.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 0 and 3.
    				Format: AlphaNumericUpper.
     * 
     * @param operatingCarrierCode
     */
    public void setOperatingCarrierCode(String operatingCarrierCode) {
        this.operatingCarrierCode = operatingCarrierCode;
    }

    /** 
     * Get the 'MarketingCarrierCode' element value. 
    					Description: Limit the search results to this marketing carrier code.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 0 and 3.
    				Format: AlphaNumericUpper.
     * 
     * @return value
     */
    public String getMarketingCarrierCode() {
        return marketingCarrierCode;
    }

    /** 
     * Set the 'MarketingCarrierCode' element value. 
    					Description: Limit the search results to this marketing carrier code.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 0 and 3.
    				Format: AlphaNumericUpper.
     * 
     * @param marketingCarrierCode
     */
    public void setMarketingCarrierCode(String marketingCarrierCode) {
        this.marketingCarrierCode = marketingCarrierCode;
    }

    /** 
     * Get the 'LanguageCode' element value. 
    					Description: Number of scheduled days before departure date to include in
    					search.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getLanguageCode() {
        return languageCode;
    }

    /** 
     * Set the 'LanguageCode' element value. 
    					Description: Number of scheduled days before departure date to include in
    					search.
    				Constraints: Required.
     * 
     * @param languageCode
     */
    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    /** 
     * Get the 'TicketPackageID' element value. 
    					Description: Number of scheduled days after departure date to include in
    					search.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getTicketPackageID() {
        return ticketPackageID;
    }

    /** 
     * Set the 'TicketPackageID' element value. 
    					Description: Number of scheduled days after departure date to include in
    					search.
    				Constraints: Required.
     * 
     * @param ticketPackageID
     */
    public void setTicketPackageID(String ticketPackageID) {
        this.ticketPackageID = ticketPackageID;
    }

    /** 
     * Get the 'FareQuoteRequestInfos' element value. 
    					Description: Language code - not currently in use. Possible future use.
    				Constraints: Required.Range: Value must be in the range 1 and 10.
    				Format: AlphaNumericCodeMixed.
     * 
     * @return value
     */
    public ArrayOfFareQuoteRequestInfo getFareQuoteRequestInfos() {
        return fareQuoteRequestInfos;
    }

    /** 
     * Set the 'FareQuoteRequestInfos' element value. 
    					Description: Language code - not currently in use. Possible future use.
    				Constraints: Required.Range: Value must be in the range 1 and 10.
    				Format: AlphaNumericCodeMixed.
     * 
     * @param fareQuoteRequestInfos
     */
    public void setFareQuoteRequestInfos(
            ArrayOfFareQuoteRequestInfo fareQuoteRequestInfos) {
        this.fareQuoteRequestInfos = fareQuoteRequestInfos;
    }

    /** 
     * Get the 'OverrideEffectiveDate' element value. 
    					Description: Optional Effective date of search - defaults to Current
    					Date/Time. Only submit if plan is to override the effective date
    					of the search.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getOverrideEffectiveDate() {
        return overrideEffectiveDate;
    }

    /** 
     * Set the 'OverrideEffectiveDate' element value. 
    					Description: Optional Effective date of search - defaults to Current
    					Date/Time. Only submit if plan is to override the effective date
    					of the search.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param overrideEffectiveDate
     */
    public void setOverrideEffectiveDate(Date overrideEffectiveDate) {
        this.overrideEffectiveDate = overrideEffectiveDate;
    }
}
