
package org.datacontract.schemas.radixx.connectpoint.pricing.request;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Pricing.Request.FastFareSearch" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FastFareSearchTravelerInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:int" name="PassengerTypeID"/>
 *     &lt;xs:element type="xs:int" name="TotalSeatsRequired"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FastFareSearchTravelerInfo
{
    private int passengerTypeID;
    private int totalSeatsRequired;

    /** 
     * Get the 'PassengerTypeID' element value. 
    					Description: Passenger type ID. Standard types are: 1=Adult, 5=Infant,
    					6=Child. Others may exist per airline setup..
    				Constraints: Required.Range: Value must be in the range 1 and 99.
    				Format: Number.
     * 
     * @return value
     */
    public int getPassengerTypeID() {
        return passengerTypeID;
    }

    /** 
     * Set the 'PassengerTypeID' element value. 
    					Description: Passenger type ID. Standard types are: 1=Adult, 5=Infant,
    					6=Child. Others may exist per airline setup..
    				Constraints: Required.Range: Value must be in the range 1 and 99.
    				Format: Number.
     * 
     * @param passengerTypeID
     */
    public void setPassengerTypeID(int passengerTypeID) {
        this.passengerTypeID = passengerTypeID;
    }

    /** 
     * Get the 'TotalSeatsRequired' element value. 
    					Description: Number of seats requested for this passenger type..
    				Constraints: Required.Range: Value must be in the range 1 and 99.
    				Format: Number.
     * 
     * @return value
     */
    public int getTotalSeatsRequired() {
        return totalSeatsRequired;
    }

    /** 
     * Set the 'TotalSeatsRequired' element value. 
    					Description: Number of seats requested for this passenger type..
    				Constraints: Required.Range: Value must be in the range 1 and 99.
    				Format: Number.
     * 
     * @param totalSeatsRequired
     */
    public void setTotalSeatsRequired(int totalSeatsRequired) {
        this.totalSeatsRequired = totalSeatsRequired;
    }
}
