
package org.datacontract.schemas.radixx.connectpoint.reservation;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CancelPNR.ActionTypes">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="CancelReservation"/>
 *     &lt;xs:enumeration value="RevertReservation"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum CancelPNRActionTypes {
    /** 
     * 
    <summary>Action to cancels PNR in session and applies all refunds
    and penalties so that consumer can make final decision whether to
    cancel or not</summary>
    
     */
    CANCEL_RESERVATION("CancelReservation"), /** 
                                              * 
                                             <summary>Action reverts all in session work (Pre CreatePNR
                                             (SaveReservation)) back to original database loaded state</summary>
                                             
                                              */
    REVERT_RESERVATION("RevertReservation");
    private final String value;

    private CancelPNRActionTypes(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static CancelPNRActionTypes convert(String value) {
        for (CancelPNRActionTypes inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
