
package org.datacontract.schemas.radixx.connectpoint.reservation;

import org.datacontract.schemas.radixx.connectpoint.EnumerationsContactTypes;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:int" name="ContactID"/>
 *     &lt;xs:element type="xs:int" name="PersonOrgID"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ContactField"/>
 *     &lt;xs:element type="ns:Enumerations.ContactTypes" name="ContactType"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Extension"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CountryCode"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="AreaCode"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="PhoneNumber"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Display"/>
 *     &lt;xs:element type="xs:boolean" name="PreferredContactMethod"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ContactInfo
{
    private int contactID;
    private int personOrgID;
    private String contactField;
    private EnumerationsContactTypes contactType;
    private String extension;
    private String countryCode;
    private String areaCode;
    private String phoneNumber;
    private String display;
    private boolean preferredContactMethod;

    /** 
     * Get the 'ContactID' element value. 
    					Description: The automatically system generated unique identifier for the
    					passenger's contact person..
    				Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @return value
     */
    public int getContactID() {
        return contactID;
    }

    /** 
     * Set the 'ContactID' element value. 
    					Description: The automatically system generated unique identifier for the
    					passenger's contact person..
    				Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @param contactID
     */
    public void setContactID(int contactID) {
        this.contactID = contactID;
    }

    /** 
     * Get the 'PersonOrgID' element value. 
    					Description: The automatically system generated unique identifier for the
    					passenger..
    				Constraints: Required.
     * 
     * @return value
     */
    public int getPersonOrgID() {
        return personOrgID;
    }

    /** 
     * Set the 'PersonOrgID' element value. 
    					Description: The automatically system generated unique identifier for the
    					passenger..
    				Constraints: Required.
     * 
     * @param personOrgID
     */
    public void setPersonOrgID(int personOrgID) {
        this.personOrgID = personOrgID;
    }

    /** 
     * Get the 'ContactField' element value. Description: The field for the contact..
    				Constraints: Required.
    					Range: Length must be in the range -2147483648 and 2147483647.
    				
     * 
     * @return value
     */
    public String getContactField() {
        return contactField;
    }

    /** 
     * Set the 'ContactField' element value. Description: The field for the contact..
    				Constraints: Required.
    					Range: Length must be in the range -2147483648 and 2147483647.
    				
     * 
     * @param contactField
     */
    public void setContactField(String contactField) {
        this.contactField = contactField;
    }

    /** 
     * Get the 'ContactType' element value. 
    					Description: The code that represents the specified mode for the contact.
    					Use:0 = Home Phone 1 = Work Phone 2 = Mobile Phone 3 = Pager 4 =
    					E-mail 5 = Fax.
    				Constraints: Required.
     * 
     * @return value
     */
    public EnumerationsContactTypes getContactType() {
        return contactType;
    }

    /** 
     * Set the 'ContactType' element value. 
    					Description: The code that represents the specified mode for the contact.
    					Use:0 = Home Phone 1 = Work Phone 2 = Mobile Phone 3 = Pager 4 =
    					E-mail 5 = Fax.
    				Constraints: Required.
     * 
     * @param contactType
     */
    public void setContactType(EnumerationsContactTypes contactType) {
        this.contactType = contactType;
    }

    /** 
     * Get the 'Extension' element value. 
    					Description: The extension number for the contact..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 8.
    				
     * 
     * @return value
     */
    public String getExtension() {
        return extension;
    }

    /** 
     * Set the 'Extension' element value. 
    					Description: The extension number for the contact..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 8.
    				
     * 
     * @param extension
     */
    public void setExtension(String extension) {
        this.extension = extension;
    }

    /** 
     * Get the 'CountryCode' element value. 
    					Description: The code that represents the country where the contact resides..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 8.
    				
     * 
     * @return value
     */
    public String getCountryCode() {
        return countryCode;
    }

    /** 
     * Set the 'CountryCode' element value. 
    					Description: The code that represents the country where the contact resides..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 8.
    				
     * 
     * @param countryCode
     */
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    /** 
     * Get the 'AreaCode' element value. 
    					Description: The three-digit code that identifies the telephone area for the
    					contact..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 8.
    				
     * 
     * @return value
     */
    public String getAreaCode() {
        return areaCode;
    }

    /** 
     * Set the 'AreaCode' element value. 
    					Description: The three-digit code that identifies the telephone area for the
    					contact..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 8.
    				
     * 
     * @param areaCode
     */
    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    /** 
     * Get the 'PhoneNumber' element value. Description: The contact's phone number..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 17.
    				
     * 
     * @return value
     */
    public String getPhoneNumber() {
        return phoneNumber;
    }

    /** 
     * Set the 'PhoneNumber' element value. Description: The contact's phone number..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 17.
    				
     * 
     * @param phoneNumber
     */
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    /** 
     * Get the 'Display' element value. 
    					Description: Logical value indicating that this contact information is to be
    					displayed to the user.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				
     * 
     * @return value
     */
    public String getDisplay() {
        return display;
    }

    /** 
     * Set the 'Display' element value. 
    					Description: Logical value indicating that this contact information is to be
    					displayed to the user.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				
     * 
     * @param display
     */
    public void setDisplay(String display) {
        this.display = display;
    }

    /** 
     * Get the 'PreferredContactMethod' element value. 
    					Description: Logical value indicating that this is to be used as the preferred
    					means of contact.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public boolean isPreferredContactMethod() {
        return preferredContactMethod;
    }

    /** 
     * Set the 'PreferredContactMethod' element value. 
    					Description: Logical value indicating that this is to be used as the preferred
    					means of contact.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param preferredContactMethod
     */
    public void setPreferredContactMethod(boolean preferredContactMethod) {
        this.preferredContactMethod = preferredContactMethod;
    }
}
