
package org.datacontract.schemas.radixx.connectpoint.reservation;

import org.datacontract.schemas.radixx.connectpoint.ReservationInfo;
import org.datacontract.schemas.radixx.connectpoint.TransactionInfo;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EvaluateModificationOfPNR">
 *   &lt;xs:complexContent mixed="false">
 *     &lt;xs:extension base="ns:TransactionInfo">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:ReservationInfo" nillable="true" name="ReservationInfo"/>
 *         &lt;xs:element type="ns1:EvaluateModificationOfPNR.ActionTypes" name="ActionType"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="LogicalFlightKeyToRemove"/>
 *         &lt;xs:element type="xs:int" name="PersonOrgIdentifierToRemove"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class EvaluateModificationOfPNR extends TransactionInfo
{
    private ReservationInfo reservationInfo;
    private EvaluateModificationOfPNRActionTypes actionType;
    private String logicalFlightKeyToRemove;
    private int personOrgIdentifierToRemove;

    /** 
     * Get the 'ReservationInfo' element value. 
    							Description: Reservation Information must be populated.
    						Constraints: Required.
     * 
     * @return value
     */
    public ReservationInfo getReservationInfo() {
        return reservationInfo;
    }

    /** 
     * Set the 'ReservationInfo' element value. 
    							Description: Reservation Information must be populated.
    						Constraints: Required.
     * 
     * @param reservationInfo
     */
    public void setReservationInfo(ReservationInfo reservationInfo) {
        this.reservationInfo = reservationInfo;
    }

    /** 
     * Get the 'ActionType' element value.
     * 
     * @return value
     */
    public EvaluateModificationOfPNRActionTypes getActionType() {
        return actionType;
    }

    /** 
     * Set the 'ActionType' element value.
     * 
     * @param actionType
     */
    public void setActionType(EvaluateModificationOfPNRActionTypes actionType) {
        this.actionType = actionType;
    }

    /** 
     * Get the 'LogicalFlightKeyToRemove' element value.
     * 
     * @return value
     */
    public String getLogicalFlightKeyToRemove() {
        return logicalFlightKeyToRemove;
    }

    /** 
     * Set the 'LogicalFlightKeyToRemove' element value.
     * 
     * @param logicalFlightKeyToRemove
     */
    public void setLogicalFlightKeyToRemove(String logicalFlightKeyToRemove) {
        this.logicalFlightKeyToRemove = logicalFlightKeyToRemove;
    }

    /** 
     * Get the 'PersonOrgIdentifierToRemove' element value.
     * 
     * @return value
     */
    public int getPersonOrgIdentifierToRemove() {
        return personOrgIdentifierToRemove;
    }

    /** 
     * Set the 'PersonOrgIdentifierToRemove' element value.
     * 
     * @param personOrgIdentifierToRemove
     */
    public void setPersonOrgIdentifierToRemove(int personOrgIdentifierToRemove) {
        this.personOrgIdentifierToRemove = personOrgIdentifierToRemove;
    }
}
