
package org.datacontract.schemas.radixx.connectpoint.reservation;

import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Response" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="History">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:int" name="HistoryID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Key" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="RecordNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="HistoryType" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="ActivityDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Passenger" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FirstName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="LastName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Segment" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="UserIPAddress" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Action" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="UserID" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="PersonOrgID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Details" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="ReservationChannelID" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class History
{
    private Integer historyID;
    private String key;
    private Integer recordNumber;
    private Integer historyType;
    private Date activityDate;
    private String passenger;
    private String firstName;
    private String lastName;
    private String segment;
    private String userIPAddress;
    private String action;
    private String userID;
    private Integer personOrgID;
    private String details;
    private Integer reservationChannelID;

    /** 
     * Get the 'HistoryID' element value. 
    					Description: The database identifier for this history record.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getHistoryID() {
        return historyID;
    }

    /** 
     * Set the 'HistoryID' element value. 
    					Description: The database identifier for this history record.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param historyID
     */
    public void setHistoryID(Integer historyID) {
        this.historyID = historyID;
    }

    /** 
     * Get the 'Key' element value. 
    					Description: The object key for this history record.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getKey() {
        return key;
    }

    /** 
     * Set the 'Key' element value. 
    					Description: The object key for this history record.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param key
     */
    public void setKey(String key) {
        this.key = key;
    }

    /** 
     * Get the 'RecordNumber' element value. 
    					Description: The Record Number for the passenger segment related to this
    					history record.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getRecordNumber() {
        return recordNumber;
    }

    /** 
     * Set the 'RecordNumber' element value. 
    					Description: The Record Number for the passenger segment related to this
    					history record.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param recordNumber
     */
    public void setRecordNumber(Integer recordNumber) {
        this.recordNumber = recordNumber;
    }

    /** 
     * Get the 'HistoryType' element value. 
    					Description: The Type of transaction that was used to generate the history
    					record.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getHistoryType() {
        return historyType;
    }

    /** 
     * Set the 'HistoryType' element value. 
    					Description: The Type of transaction that was used to generate the history
    					record.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param historyType
     */
    public void setHistoryType(Integer historyType) {
        this.historyType = historyType;
    }

    /** 
     * Get the 'ActivityDate' element value. 
    					Description: The date and time , in GMT, that the transaction occurred..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getActivityDate() {
        return activityDate;
    }

    /** 
     * Set the 'ActivityDate' element value. 
    					Description: The date and time , in GMT, that the transaction occurred..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param activityDate
     */
    public void setActivityDate(Date activityDate) {
        this.activityDate = activityDate;
    }

    /** 
     * Get the 'Passenger' element value. 
    					Description: The string representing the passenger that was affected by this
    					booking.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getPassenger() {
        return passenger;
    }

    /** 
     * Set the 'Passenger' element value. 
    					Description: The string representing the passenger that was affected by this
    					booking.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param passenger
     */
    public void setPassenger(String passenger) {
        this.passenger = passenger;
    }

    /** 
     * Get the 'FirstName' element value. 
    					Description: The firstName of the passenger affected by this change.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getFirstName() {
        return firstName;
    }

    /** 
     * Set the 'FirstName' element value. 
    					Description: The firstName of the passenger affected by this change.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param firstName
     */
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    /** 
     * Get the 'LastName' element value. 
    					Description: The lastname of the passenger affected by this change.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getLastName() {
        return lastName;
    }

    /** 
     * Set the 'LastName' element value. 
    					Description: The lastname of the passenger affected by this change.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param lastName
     */
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    /** 
     * Get the 'Segment' element value. 
    					Description: The string representation of the reservation segment affected by
    					this change.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getSegment() {
        return segment;
    }

    /** 
     * Set the 'Segment' element value. 
    					Description: The string representation of the reservation segment affected by
    					this change.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param segment
     */
    public void setSegment(String segment) {
        this.segment = segment;
    }

    /** 
     * Get the 'UserIPAddress' element value. 
    					Description: The Internet Protocol (IP) address of the client that generated
    					this change.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getUserIPAddress() {
        return userIPAddress;
    }

    /** 
     * Set the 'UserIPAddress' element value. 
    					Description: The Internet Protocol (IP) address of the client that generated
    					this change.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param userIPAddress
     */
    public void setUserIPAddress(String userIPAddress) {
        this.userIPAddress = userIPAddress;
    }

    /** 
     * Get the 'Action' element value. Description: The type of change .
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getAction() {
        return action;
    }

    /** 
     * Set the 'Action' element value. Description: The type of change .
    				Constraints: Optional (Not Required).
    				
     * 
     * @param action
     */
    public void setAction(String action) {
        this.action = action;
    }

    /** 
     * Get the 'UserID' element value. 
    					Description: The UserID of the person or application that made the change.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getUserID() {
        return userID;
    }

    /** 
     * Set the 'UserID' element value. 
    					Description: The UserID of the person or application that made the change.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param userID
     */
    public void setUserID(String userID) {
        this.userID = userID;
    }

    /** 
     * Get the 'PersonOrgID' element value. 
    					Description: The PersonOrgID affected by this change.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getPersonOrgID() {
        return personOrgID;
    }

    /** 
     * Set the 'PersonOrgID' element value. 
    					Description: The PersonOrgID affected by this change.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param personOrgID
     */
    public void setPersonOrgID(Integer personOrgID) {
        this.personOrgID = personOrgID;
    }

    /** 
     * Get the 'Details' element value. 
    					Description: Any additional details provided by the process making this
    					change.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getDetails() {
        return details;
    }

    /** 
     * Set the 'Details' element value. 
    					Description: Any additional details provided by the process making this
    					change.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param details
     */
    public void setDetails(String details) {
        this.details = details;
    }

    /** 
     * Get the 'ReservationChannelID' element value. 
    					Description: The reservation channel through which the change was made.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getReservationChannelID() {
        return reservationChannelID;
    }

    /** 
     * Set the 'ReservationChannelID' element value. 
    					Description: The reservation channel through which the change was made.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param reservationChannelID
     */
    public void setReservationChannelID(Integer reservationChannelID) {
        this.reservationChannelID = reservationChannelID;
    }
}
