
package org.datacontract.schemas.radixx.connectpoint.reservation;

import org.datacontract.schemas.radixx.connectpoint.TransactionInfo;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ImportPNR">
 *   &lt;xs:complexContent mixed="false">
 *     &lt;xs:extension base="ns:TransactionInfo">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns1:ImportPNR.ActionTypes" name="ActionType"/>
 *         &lt;xs:element type="ns1:ImportPNR.Reservation" nillable="true" name="ImportPNR"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ImportPNR extends TransactionInfo
{
    private ImportPNRActionTypes actionType;
    private ImportPNRReservation importPNR;

    /** 
     * Get the 'ActionType' element value. 
    							Description: Action type to perform pnr import operations..
    						Constraints: Required.
     * 
     * @return value
     */
    public ImportPNRActionTypes getActionType() {
        return actionType;
    }

    /** 
     * Set the 'ActionType' element value. 
    							Description: Action type to perform pnr import operations..
    						Constraints: Required.
     * 
     * @param actionType
     */
    public void setActionType(ImportPNRActionTypes actionType) {
        this.actionType = actionType;
    }

    /** 
     * Get the 'ImportPNR' element value. Description: PNR Information to Import..
    						Constraints: Required.
     * 
     * @return value
     */
    public ImportPNRReservation getImportPNR() {
        return importPNR;
    }

    /** 
     * Set the 'ImportPNR' element value. Description: PNR Information to Import..
    						Constraints: Required.
     * 
     * @param importPNR
     */
    public void setImportPNR(ImportPNRReservation importPNR) {
        this.importPNR = importPNR;
    }
}
