
package org.datacontract.schemas.radixx.connectpoint.reservation;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ImportPNR.ActionTypes">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="ImportPNR"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum ImportPNRActionTypes {
    /** 
     * 
    <summary>Action to perform global pnr import operation. This
    action handles Creation, Modification, and cancellations on PNR's</summary>
    
     */
    IMPORT_PNR("ImportPNR");
    private final String value;

    private ImportPNRActionTypes(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static ImportPNRActionTypes convert(String value) {
        for (ImportPNRActionTypes inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
