
package org.datacontract.schemas.radixx.connectpoint.reservation;

import org.datacontract.schemas.radixx.connectpoint.ReservationInfo;
import org.datacontract.schemas.radixx.connectpoint.TransactionInfo;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ModifyPNR">
 *   &lt;xs:complexContent mixed="false">
 *     &lt;xs:extension base="ns:TransactionInfo">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns1:ModifyPNR.ActionTypes" name="ActionType"/>
 *         &lt;xs:element type="ns:ReservationInfo" nillable="true" name="ReservationInfo"/>
 *         &lt;xs:element type="xs:int" name="FareInformationID"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="LogicalFlightKeyToReplace"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="LogicalFlightKeyToRemove"/>
 *         &lt;xs:element type="xs:int" name="PersonOrgIdentifierToRemove"/>
 *         &lt;xs:element type="ns1:ArrayOfModifyPNR.Passenger" nillable="true" name="PassengersToAdd"/>
 *         &lt;xs:element type="ns1:ArrayOfModifyPNR.UpdatePassenger" nillable="true" name="PassengersToUpdate"/>
 *         &lt;xs:element type="ns1:ArrayOfSpecialService" nillable="true" name="SpecialServices"/>
 *         &lt;xs:element type="ns1:ArrayOfSpecialServiceToCancel" nillable="true" name="SpecialServicesToCancel"/>
 *         &lt;xs:element type="ns1:ArrayOfModifyPNR.AddContactInfo" nillable="true" name="ContactInformationToAdd"/>
 *         &lt;xs:element type="ns1:ArrayOfModifyPNR.UpdateContactInfo" nillable="true" name="ContactInformationToUpdate"/>
 *         &lt;xs:element type="ns1:Comment" nillable="true" name="CommentToAdd"/>
 *         &lt;xs:element type="ns1:ArrayOfModifyPNR.EmergencyContact" nillable="true" name="EmergencyContactsToAddToSegments" minOccurs="0"/>
 *         &lt;xs:element type="ns1:ArrayOfModifyPNR.UpdateRecordLocator" nillable="true" name="PassengerSegmentsToUpdateRecordLocator" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ModifyPNR extends TransactionInfo
{
    private ModifyPNRActionTypes actionType;
    private ReservationInfo reservationInfo;
    private int fareInformationID;
    private String logicalFlightKeyToReplace;
    private String logicalFlightKeyToRemove;
    private int personOrgIdentifierToRemove;
    private ArrayOfModifyPNRPassenger passengersToAdd;
    private ArrayOfModifyPNRUpdatePassenger passengersToUpdate;
    private ArrayOfSpecialService specialServices;
    private ArrayOfSpecialServiceToCancel specialServicesToCancel;
    private ArrayOfModifyPNRAddContactInfo contactInformationToAdd;
    private ArrayOfModifyPNRUpdateContactInfo contactInformationToUpdate;
    private Comment commentToAdd;
    private ArrayOfModifyPNREmergencyContact emergencyContactsToAddToSegments;
    private ArrayOfModifyPNRUpdateRecordLocator passengerSegmentsToUpdateRecordLocator;

    /** 
     * Get the 'ActionType' element value. 
    							Description: Action type indicating the option to add or remove flight,
    							passenger or special services.
    						Constraints: Required.
     * 
     * @return value
     */
    public ModifyPNRActionTypes getActionType() {
        return actionType;
    }

    /** 
     * Set the 'ActionType' element value. 
    							Description: Action type indicating the option to add or remove flight,
    							passenger or special services.
    						Constraints: Required.
     * 
     * @param actionType
     */
    public void setActionType(ModifyPNRActionTypes actionType) {
        this.actionType = actionType;
    }

    /** 
     * Get the 'ReservationInfo' element value. 
    							Description: Reservation Information must be populated.
    						Constraints: Required.
     * 
     * @return value
     */
    public ReservationInfo getReservationInfo() {
        return reservationInfo;
    }

    /** 
     * Set the 'ReservationInfo' element value. 
    							Description: Reservation Information must be populated.
    						Constraints: Required.
     * 
     * @param reservationInfo
     */
    public void setReservationInfo(ReservationInfo reservationInfo) {
        this.reservationInfo = reservationInfo;
    }

    /** 
     * Get the 'FareInformationID' element value. 
    							Description: The value of this field is returned in the Fare Quote Response.
    							It will be the FareID of the flight chosen by the consumer via
    							the User Interface.
    						Constraints: Required.
    							Range: Value must be in the range -2147483648 and 2147483647.
    						
     * 
     * @return value
     */
    public int getFareInformationID() {
        return fareInformationID;
    }

    /** 
     * Set the 'FareInformationID' element value. 
    							Description: The value of this field is returned in the Fare Quote Response.
    							It will be the FareID of the flight chosen by the consumer via
    							the User Interface.
    						Constraints: Required.
    							Range: Value must be in the range -2147483648 and 2147483647.
    						
     * 
     * @param fareInformationID
     */
    public void setFareInformationID(int fareInformationID) {
        this.fareInformationID = fareInformationID;
    }

    /** 
     * Get the 'LogicalFlightKeyToReplace' element value. Description: Logical flight key to replace.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getLogicalFlightKeyToReplace() {
        return logicalFlightKeyToReplace;
    }

    /** 
     * Set the 'LogicalFlightKeyToReplace' element value. Description: Logical flight key to replace.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param logicalFlightKeyToReplace
     */
    public void setLogicalFlightKeyToReplace(String logicalFlightKeyToReplace) {
        this.logicalFlightKeyToReplace = logicalFlightKeyToReplace;
    }

    /** 
     * Get the 'LogicalFlightKeyToRemove' element value. Description: Logical flight key to remove.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getLogicalFlightKeyToRemove() {
        return logicalFlightKeyToRemove;
    }

    /** 
     * Set the 'LogicalFlightKeyToRemove' element value. Description: Logical flight key to remove.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param logicalFlightKeyToRemove
     */
    public void setLogicalFlightKeyToRemove(String logicalFlightKeyToRemove) {
        this.logicalFlightKeyToRemove = logicalFlightKeyToRemove;
    }

    /** 
     * Get the 'PersonOrgIdentifierToRemove' element value. 
    							Description: Identifier of the passenger to be removed. The value of this
    							property can be obtained from the AirLine Person nod of ViewPNR.
    						Constraints: Required.
    							Range: Value must be in the range -2147483648 and 2147483647.
    						
     * 
     * @return value
     */
    public int getPersonOrgIdentifierToRemove() {
        return personOrgIdentifierToRemove;
    }

    /** 
     * Set the 'PersonOrgIdentifierToRemove' element value. 
    							Description: Identifier of the passenger to be removed. The value of this
    							property can be obtained from the AirLine Person nod of ViewPNR.
    						Constraints: Required.
    							Range: Value must be in the range -2147483648 and 2147483647.
    						
     * 
     * @param personOrgIdentifierToRemove
     */
    public void setPersonOrgIdentifierToRemove(int personOrgIdentifierToRemove) {
        this.personOrgIdentifierToRemove = personOrgIdentifierToRemove;
    }

    /** 
     * Get the 'PassengersToAdd' element value. Description: Collection of passengers.
    						Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 0 and 2147483647.
    						
     * 
     * @return value
     */
    public ArrayOfModifyPNRPassenger getPassengersToAdd() {
        return passengersToAdd;
    }

    /** 
     * Set the 'PassengersToAdd' element value. Description: Collection of passengers.
    						Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 0 and 2147483647.
    						
     * 
     * @param passengersToAdd
     */
    public void setPassengersToAdd(ArrayOfModifyPNRPassenger passengersToAdd) {
        this.passengersToAdd = passengersToAdd;
    }

    /** 
     * Get the 'PassengersToUpdate' element value. 
    							Description: Collection of passengers who are in need of name updates.
    						Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 0 and 2147483647.
    						
     * 
     * @return value
     */
    public ArrayOfModifyPNRUpdatePassenger getPassengersToUpdate() {
        return passengersToUpdate;
    }

    /** 
     * Set the 'PassengersToUpdate' element value. 
    							Description: Collection of passengers who are in need of name updates.
    						Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 0 and 2147483647.
    						
     * 
     * @param passengersToUpdate
     */
    public void setPassengersToUpdate(
            ArrayOfModifyPNRUpdatePassenger passengersToUpdate) {
        this.passengersToUpdate = passengersToUpdate;
    }

    /** 
     * Get the 'SpecialServices' element value. Description: Collection of special services.
    						Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 0 and 2147483647.
    						
     * 
     * @return value
     */
    public ArrayOfSpecialService getSpecialServices() {
        return specialServices;
    }

    /** 
     * Set the 'SpecialServices' element value. Description: Collection of special services.
    						Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 0 and 2147483647.
    						
     * 
     * @param specialServices
     */
    public void setSpecialServices(ArrayOfSpecialService specialServices) {
        this.specialServices = specialServices;
    }

    /** 
     * Get the 'SpecialServicesToCancel' element value. 
    							Description: Collection of special services to be removed/cancelled from a
    							PNR.
    						Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 0 and 2147483647.
    						
     * 
     * @return value
     */
    public ArrayOfSpecialServiceToCancel getSpecialServicesToCancel() {
        return specialServicesToCancel;
    }

    /** 
     * Set the 'SpecialServicesToCancel' element value. 
    							Description: Collection of special services to be removed/cancelled from a
    							PNR.
    						Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 0 and 2147483647.
    						
     * 
     * @param specialServicesToCancel
     */
    public void setSpecialServicesToCancel(
            ArrayOfSpecialServiceToCancel specialServicesToCancel) {
        this.specialServicesToCancel = specialServicesToCancel;
    }

    /** 
     * Get the 'ContactInformationToAdd' element value. 
    							Description: Collection of contact information that are in need of being
    							added.
    						Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 0 and 2147483647.
    						
     * 
     * @return value
     */
    public ArrayOfModifyPNRAddContactInfo getContactInformationToAdd() {
        return contactInformationToAdd;
    }

    /** 
     * Set the 'ContactInformationToAdd' element value. 
    							Description: Collection of contact information that are in need of being
    							added.
    						Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 0 and 2147483647.
    						
     * 
     * @param contactInformationToAdd
     */
    public void setContactInformationToAdd(
            ArrayOfModifyPNRAddContactInfo contactInformationToAdd) {
        this.contactInformationToAdd = contactInformationToAdd;
    }

    /** 
     * Get the 'ContactInformationToUpdate' element value. 
    							Description: Collection of contact information that are in need of updates.
    						Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 0 and 2147483647.
    						
     * 
     * @return value
     */
    public ArrayOfModifyPNRUpdateContactInfo getContactInformationToUpdate() {
        return contactInformationToUpdate;
    }

    /** 
     * Set the 'ContactInformationToUpdate' element value. 
    							Description: Collection of contact information that are in need of updates.
    						Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 0 and 2147483647.
    						
     * 
     * @param contactInformationToUpdate
     */
    public void setContactInformationToUpdate(
            ArrayOfModifyPNRUpdateContactInfo contactInformationToUpdate) {
        this.contactInformationToUpdate = contactInformationToUpdate;
    }

    /** 
     * Get the 'CommentToAdd' element value. 
    							Description: Comment that will be added to the PNR.
    						Constraints: Optional (Not Required).
    						Range: Value must be in the range 0 and 1.
    						
     * 
     * @return value
     */
    public Comment getCommentToAdd() {
        return commentToAdd;
    }

    /** 
     * Set the 'CommentToAdd' element value. 
    							Description: Comment that will be added to the PNR.
    						Constraints: Optional (Not Required).
    						Range: Value must be in the range 0 and 1.
    						
     * 
     * @param commentToAdd
     */
    public void setCommentToAdd(Comment commentToAdd) {
        this.commentToAdd = commentToAdd;
    }

    /** 
     * Get the 'EmergencyContactsToAddToSegments' element value. 
    							Description: Collection of Emergency Contacts to add to passenger segments.
    						Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 0 and 2147483647.
    						
     * 
     * @return value
     */
    public ArrayOfModifyPNREmergencyContact getEmergencyContactsToAddToSegments() {
        return emergencyContactsToAddToSegments;
    }

    /** 
     * Set the 'EmergencyContactsToAddToSegments' element value. 
    							Description: Collection of Emergency Contacts to add to passenger segments.
    						Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 0 and 2147483647.
    						
     * 
     * @param emergencyContactsToAddToSegments
     */
    public void setEmergencyContactsToAddToSegments(
            ArrayOfModifyPNREmergencyContact emergencyContactsToAddToSegments) {
        this.emergencyContactsToAddToSegments = emergencyContactsToAddToSegments;
    }

    /** 
     * Get the 'PassengerSegmentsToUpdateRecordLocator' element value. 
    							Description: Collection of Emergency Contacts to add to passenger segments.
    						Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 0 and 2147483647.
    						
     * 
     * @return value
     */
    public ArrayOfModifyPNRUpdateRecordLocator getPassengerSegmentsToUpdateRecordLocator() {
        return passengerSegmentsToUpdateRecordLocator;
    }

    /** 
     * Set the 'PassengerSegmentsToUpdateRecordLocator' element value. 
    							Description: Collection of Emergency Contacts to add to passenger segments.
    						Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 0 and 2147483647.
    						
     * 
     * @param passengerSegmentsToUpdateRecordLocator
     */
    public void setPassengerSegmentsToUpdateRecordLocator(
            ArrayOfModifyPNRUpdateRecordLocator passengerSegmentsToUpdateRecordLocator) {
        this.passengerSegmentsToUpdateRecordLocator = passengerSegmentsToUpdateRecordLocator;
    }
}
