
package org.datacontract.schemas.radixx.connectpoint.reservation;

import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ModifyPNR.FlightInformation">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:int" name="LogicalFlightID"/>
 *     &lt;xs:element type="xs:dateTime" name="DepartureDate"/>
 *     &lt;xs:element type="xs:int" name="FareInformationID"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ModifyPNRFlightInformation
{
    private int logicalFlightID;
    private Date departureDate;
    private int fareInformationID;

    /** 
     * Get the 'LogicalFlightID' element value. 
    					Description: The automatically system generated unique identifier for the
    					booked light (known as a logical flight)..
    				Constraints: Required.
     * 
     * @return value
     */
    public int getLogicalFlightID() {
        return logicalFlightID;
    }

    /** 
     * Set the 'LogicalFlightID' element value. 
    					Description: The automatically system generated unique identifier for the
    					booked light (known as a logical flight)..
    				Constraints: Required.
     * 
     * @param logicalFlightID
     */
    public void setLogicalFlightID(int logicalFlightID) {
        this.logicalFlightID = logicalFlightID;
    }

    /** 
     * Get the 'DepartureDate' element value. Description: The day the flight takes leave..
    				Constraints: Required.
     * 
     * @return value
     */
    public Date getDepartureDate() {
        return departureDate;
    }

    /** 
     * Set the 'DepartureDate' element value. Description: The day the flight takes leave..
    				Constraints: Required.
     * 
     * @param departureDate
     */
    public void setDepartureDate(Date departureDate) {
        this.departureDate = departureDate;
    }

    /** 
     * Get the 'FareInformationID' element value. 
    					Description: Logical flight fare information ID that is obtained from the Fare
    					Quote response call.
    				Constraints: Required.
     * 
     * @return value
     */
    public int getFareInformationID() {
        return fareInformationID;
    }

    /** 
     * Set the 'FareInformationID' element value. 
    					Description: Logical flight fare information ID that is obtained from the Fare
    					Quote response call.
    				Constraints: Required.
     * 
     * @param fareInformationID
     */
    public void setFareInformationID(int fareInformationID) {
        this.fareInformationID = fareInformationID;
    }
}
