
package org.datacontract.schemas.radixx.connectpoint.reservation;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ModifyPNR.Passenger">
 *   &lt;xs:complexContent mixed="false">
 *     &lt;xs:extension base="ns:ModifyPNR.Person">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:int" name="DropOffID" minOccurs="0"/>
 *         &lt;xs:element type="xs:int" name="PickUpID" minOccurs="0"/>
 *         &lt;xs:element type="xs:int" name="LapChildID" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="FrequentFlyerNumber" minOccurs="0"/>
 *         &lt;xs:element type="xs:int" name="SelecteeStatus" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="StoreFrontID" minOccurs="0"/>
 *         &lt;xs:element type="xs:int" name="TravelsWithPersonOrgID"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="RedressNumber"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="KnownTravelerNumber"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="RecordLocator" minOccurs="0"/>
 *         &lt;xs:element type="ns:ArrayOfModifyPNR.FlightInformation" nillable="true" name="FlightInformations" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ModifyPNRPassenger extends ModifyPNRPerson
{
    private Integer dropOffID;
    private Integer pickUpID;
    private Integer lapChildID;
    private String frequentFlyerNumber;
    private Integer selecteeStatus;
    private String storeFrontID;
    private int travelsWithPersonOrgID;
    private String redressNumber;
    private String knownTravelerNumber;
    private String recordLocator;
    private ArrayOfModifyPNRFlightInformation flightInformations;

    /** 
     * Get the 'DropOffID' element value. 
    							Description: The PersonOrgID of the individual that is authorized to drop
    							off an unaccompanied minor..
    						Constraints: Required.
    							Range: Value must be in the range -2147483648 and 2147483647.
    						
     * 
     * @return value
     */
    public Integer getDropOffID() {
        return dropOffID;
    }

    /** 
     * Set the 'DropOffID' element value. 
    							Description: The PersonOrgID of the individual that is authorized to drop
    							off an unaccompanied minor..
    						Constraints: Required.
    							Range: Value must be in the range -2147483648 and 2147483647.
    						
     * 
     * @param dropOffID
     */
    public void setDropOffID(Integer dropOffID) {
        this.dropOffID = dropOffID;
    }

    /** 
     * Get the 'PickUpID' element value. 
    							Description: The PersonOrgID of the individual that is authorized to pick up
    							an unaccompanied minor..
    						Constraints: Required.
    							Range: Value must be in the range -2147483648 and 2147483647.
    						
     * 
     * @return value
     */
    public Integer getPickUpID() {
        return pickUpID;
    }

    /** 
     * Set the 'PickUpID' element value. 
    							Description: The PersonOrgID of the individual that is authorized to pick up
    							an unaccompanied minor..
    						Constraints: Required.
    							Range: Value must be in the range -2147483648 and 2147483647.
    						
     * 
     * @param pickUpID
     */
    public void setPickUpID(Integer pickUpID) {
        this.pickUpID = pickUpID;
    }

    /** 
     * Get the 'LapChildID' element value. 
    							Description: The PersonOrgID of the passenger who is going to be carrying an
    							Infant on his/her lap..
    						Constraints: Required.
    							Range: Value must be in the range -2147483648 and 2147483647.
    						
     * 
     * @return value
     */
    public Integer getLapChildID() {
        return lapChildID;
    }

    /** 
     * Set the 'LapChildID' element value. 
    							Description: The PersonOrgID of the passenger who is going to be carrying an
    							Infant on his/her lap..
    						Constraints: Required.
    							Range: Value must be in the range -2147483648 and 2147483647.
    						
     * 
     * @param lapChildID
     */
    public void setLapChildID(Integer lapChildID) {
        this.lapChildID = lapChildID;
    }

    /** 
     * Get the 'FrequentFlyerNumber' element value. 
    							Description: The frequent flyer number for this passenger as entered in the
    							DCS.
    						Constraints: Optional (Not Required).
    						Range: Length must be in the range 1 and 20.
    						
     * 
     * @return value
     */
    public String getFrequentFlyerNumber() {
        return frequentFlyerNumber;
    }

    /** 
     * Set the 'FrequentFlyerNumber' element value. 
    							Description: The frequent flyer number for this passenger as entered in the
    							DCS.
    						Constraints: Optional (Not Required).
    						Range: Length must be in the range 1 and 20.
    						
     * 
     * @param frequentFlyerNumber
     */
    public void setFrequentFlyerNumber(String frequentFlyerNumber) {
        this.frequentFlyerNumber = frequentFlyerNumber;
    }

    /** 
     * Get the 'SelecteeStatus' element value. 
    							Description: A range of values that describes the passengers identification
    							under various governmental security regimes.
    						Constraints: Required.
    							Range: Value must be in the range -2147483648 and 2147483647.
    						
     * 
     * @return value
     */
    public Integer getSelecteeStatus() {
        return selecteeStatus;
    }

    /** 
     * Set the 'SelecteeStatus' element value. 
    							Description: A range of values that describes the passengers identification
    							under various governmental security regimes.
    						Constraints: Required.
    							Range: Value must be in the range -2147483648 and 2147483647.
    						
     * 
     * @param selecteeStatus
     */
    public void setSelecteeStatus(Integer selecteeStatus) {
        this.selecteeStatus = selecteeStatus;
    }

    /** 
     * Get the 'StoreFrontID' element value. 
    							Description: In the event that an airline has multiple storefronts, this
    							field indicates the StoreFrontID that this booking was made
    							under.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getStoreFrontID() {
        return storeFrontID;
    }

    /** 
     * Set the 'StoreFrontID' element value. 
    							Description: In the event that an airline has multiple storefronts, this
    							field indicates the StoreFrontID that this booking was made
    							under.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param storeFrontID
     */
    public void setStoreFrontID(String storeFrontID) {
        this.storeFrontID = storeFrontID;
    }

    /** 
     * Get the 'TravelsWithPersonOrgID' element value. 
    							Description: If an infant is traveling with an adult then the infants person
    							org id will be populated in this property.
    						Constraints: Required.
    							Range: Value must be in the range -2147483648 and 2147483647.
    						
     * 
     * @return value
     */
    public int getTravelsWithPersonOrgID() {
        return travelsWithPersonOrgID;
    }

    /** 
     * Set the 'TravelsWithPersonOrgID' element value. 
    							Description: If an infant is traveling with an adult then the infants person
    							org id will be populated in this property.
    						Constraints: Required.
    							Range: Value must be in the range -2147483648 and 2147483647.
    						
     * 
     * @param travelsWithPersonOrgID
     */
    public void setTravelsWithPersonOrgID(int travelsWithPersonOrgID) {
        this.travelsWithPersonOrgID = travelsWithPersonOrgID;
    }

    /** 
     * Get the 'RedressNumber' element value. Description: Secure Flight Information.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getRedressNumber() {
        return redressNumber;
    }

    /** 
     * Set the 'RedressNumber' element value. Description: Secure Flight Information.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param redressNumber
     */
    public void setRedressNumber(String redressNumber) {
        this.redressNumber = redressNumber;
    }

    /** 
     * Get the 'KnownTravelerNumber' element value. Description: Secure Flight Information.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getKnownTravelerNumber() {
        return knownTravelerNumber;
    }

    /** 
     * Set the 'KnownTravelerNumber' element value. Description: Secure Flight Information.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param knownTravelerNumber
     */
    public void setKnownTravelerNumber(String knownTravelerNumber) {
        this.knownTravelerNumber = knownTravelerNumber;
    }

    /** 
     * Get the 'RecordLocator' element value. 
    							Description: If this field is populated then the recordlocator passed in
    							will be populated in the reservation segment of the person that
    							it is passed under.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getRecordLocator() {
        return recordLocator;
    }

    /** 
     * Set the 'RecordLocator' element value. 
    							Description: If this field is populated then the recordlocator passed in
    							will be populated in the reservation segment of the person that
    							it is passed under.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param recordLocator
     */
    public void setRecordLocator(String recordLocator) {
        this.recordLocator = recordLocator;
    }

    /** 
     * Get the 'FlightInformations' element value. Description: Collection of flight information.
    						Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 1 and 2147483647.
    						
     * 
     * @return value
     */
    public ArrayOfModifyPNRFlightInformation getFlightInformations() {
        return flightInformations;
    }

    /** 
     * Set the 'FlightInformations' element value. Description: Collection of flight information.
    						Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 1 and 2147483647.
    						
     * 
     * @param flightInformations
     */
    public void setFlightInformations(
            ArrayOfModifyPNRFlightInformation flightInformations) {
        this.flightInformations = flightInformations;
    }
}
