
package org.datacontract.schemas.radixx.connectpoint.reservation;

import java.util.Date;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsGenderTypes;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsRelationshipTypes;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ModifyPNR.Person">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:int" name="PersonOrgID"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FirstName"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="LastName"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="MiddleName"/>
 *     &lt;xs:element type="xs:int" name="Age"/>
 *     &lt;xs:element type="xs:dateTime" name="DOB"/>
 *     &lt;xs:element type="ns:Enumerations.GenderTypes" name="Gender"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Title"/>
 *     &lt;xs:element type="xs:int" name="NationalityLaguageID"/>
 *     &lt;xs:element type="ns:Enumerations.RelationshipTypes" name="RelationType"/>
 *     &lt;xs:element type="xs:int" name="WBCID"/>
 *     &lt;xs:element type="xs:int" name="PTCID"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="PTC"/>
 *     &lt;xs:element type="xs:boolean" name="UseInventory"/>
 *     &lt;xs:element type="ns1:Address" nillable="true" name="Address"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Company"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Comments"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Passport"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Nationality"/>
 *     &lt;xs:element type="xs:long" name="ProfileId"/>
 *     &lt;xs:element type="ns1:ArrayOfContactInfo" nillable="true" name="ContactInfos"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ModifyPNRPerson
{
    private int personOrgID;
    private String firstName;
    private String lastName;
    private String middleName;
    private int age;
    private Date DOB;
    private EnumerationsGenderTypes gender;
    private String title;
    private int nationalityLaguageID;
    private EnumerationsRelationshipTypes relationType;
    private int WBCID;
    private int PTCID;
    private String PTC;
    private boolean useInventory;
    private Address address;
    private String company;
    private String comments;
    private String passport;
    private String nationality;
    private long profileId;
    private ArrayOfContactInfo contactInfos;

    /** 
     * Get the 'PersonOrgID' element value. 
    					Description: The automatically system generated unique identifier for the
    					passenger. Unless Performing a passenger Name Change then it will
    					be the personOrgID rendered from the ViewPNR Response.
    				Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @return value
     */
    public int getPersonOrgID() {
        return personOrgID;
    }

    /** 
     * Set the 'PersonOrgID' element value. 
    					Description: The automatically system generated unique identifier for the
    					passenger. Unless Performing a passenger Name Change then it will
    					be the personOrgID rendered from the ViewPNR Response.
    				Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @param personOrgID
     */
    public void setPersonOrgID(int personOrgID) {
        this.personOrgID = personOrgID;
    }

    /** 
     * Get the 'FirstName' element value. Description: The passenger's first name..
    				Constraints: Required.Range: Length must be in the range 1 and 64.
    				
     * 
     * @return value
     */
    public String getFirstName() {
        return firstName;
    }

    /** 
     * Set the 'FirstName' element value. Description: The passenger's first name..
    				Constraints: Required.Range: Length must be in the range 1 and 64.
    				
     * 
     * @param firstName
     */
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    /** 
     * Get the 'LastName' element value. Description: The passenger's last name..
    				Constraints: Required.Range: Length must be in the range 1 and 64.
    				
     * 
     * @return value
     */
    public String getLastName() {
        return lastName;
    }

    /** 
     * Set the 'LastName' element value. Description: The passenger's last name..
    				Constraints: Required.Range: Length must be in the range 1 and 64.
    				
     * 
     * @param lastName
     */
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    /** 
     * Get the 'MiddleName' element value. Description: The passenger's middle name..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				
     * 
     * @return value
     */
    public String getMiddleName() {
        return middleName;
    }

    /** 
     * Set the 'MiddleName' element value. Description: The passenger's middle name..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				
     * 
     * @param middleName
     */
    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    /** 
     * Get the 'Age' element value. 
    					Description: The age of the passenger at the time of the booking..
    				Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @return value
     */
    public int getAge() {
        return age;
    }

    /** 
     * Set the 'Age' element value. 
    					Description: The age of the passenger at the time of the booking..
    				Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @param age
     */
    public void setAge(int age) {
        this.age = age;
    }

    /** 
     * Get the 'DOB' element value. Description: The passenger's date of birth..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getDOB() {
        return DOB;
    }

    /** 
     * Set the 'DOB' element value. Description: The passenger's date of birth..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param DOB
     */
    public void setDOB(Date DOB) {
        this.DOB = DOB;
    }

    /** 
     * Get the 'Gender' element value. 
    					Description: The code specifying the gender of the passenger..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public EnumerationsGenderTypes getGender() {
        return gender;
    }

    /** 
     * Set the 'Gender' element value. 
    					Description: The code specifying the gender of the passenger..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param gender
     */
    public void setGender(EnumerationsGenderTypes gender) {
        this.gender = gender;
    }

    /** 
     * Get the 'Title' element value. 
    					Description: The salutation for the passenger (e.g. Mr., Miss.)..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 20.
    				
     * 
     * @return value
     */
    public String getTitle() {
        return title;
    }

    /** 
     * Set the 'Title' element value. 
    					Description: The salutation for the passenger (e.g. Mr., Miss.)..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 20.
    				
     * 
     * @param title
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /** 
     * Get the 'NationalityLaguageID' element value. 
    					Description: The unique identifier that represents the passenger's native
    					language..
    				Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @return value
     */
    public int getNationalityLaguageID() {
        return nationalityLaguageID;
    }

    /** 
     * Set the 'NationalityLaguageID' element value. 
    					Description: The unique identifier that represents the passenger's native
    					language..
    				Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @param nationalityLaguageID
     */
    public void setNationalityLaguageID(int nationalityLaguageID) {
        this.nationalityLaguageID = nationalityLaguageID;
    }

    /** 
     * Get the 'RelationType' element value. 
    					Description: The relation of the person booking the flight to that of the
    					passenger..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public EnumerationsRelationshipTypes getRelationType() {
        return relationType;
    }

    /** 
     * Set the 'RelationType' element value. 
    					Description: The relation of the person booking the flight to that of the
    					passenger..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param relationType
     */
    public void setRelationType(EnumerationsRelationshipTypes relationType) {
        this.relationType = relationType;
    }

    /** 
     * Get the 'WBCID' element value. 
    					Description: Wieght and Balance Passenger Type Code ID for this passenger.
    				Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @return value
     */
    public int getWBCID() {
        return WBCID;
    }

    /** 
     * Set the 'WBCID' element value. 
    					Description: Wieght and Balance Passenger Type Code ID for this passenger.
    				Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @param WBCID
     */
    public void setWBCID(int WBCID) {
        this.WBCID = WBCID;
    }

    /** 
     * Get the 'PTCID' element value. 
    					Description: The code representing the Passenger Type Code for the passenger
    					segment..
    				Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @return value
     */
    public int getPTCID() {
        return PTCID;
    }

    /** 
     * Set the 'PTCID' element value. 
    					Description: The code representing the Passenger Type Code for the passenger
    					segment..
    				Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @param PTCID
     */
    public void setPTCID(int PTCID) {
        this.PTCID = PTCID;
    }

    /** 
     * Get the 'PTC' element value. 
    					Description: The iata standard code representing the Passenger Type Code for
    					the passenger segment. (industry predefined Codes ADT, INF, CHD).
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getPTC() {
        return PTC;
    }

    /** 
     * Set the 'PTC' element value. 
    					Description: The iata standard code representing the Passenger Type Code for
    					the passenger segment. (industry predefined Codes ADT, INF, CHD).
    				Constraints: Optional (Not Required).
    				
     * 
     * @param PTC
     */
    public void setPTC(String PTC) {
        this.PTC = PTC;
    }

    /** 
     * Get the 'UseInventory' element value. 
    					Description: Indicates whether the passenger uses an inventory space..
    				Constraints: Required.Range: Value must be in the range 1 and 3.
    				
     * 
     * @return value
     */
    public boolean isUseInventory() {
        return useInventory;
    }

    /** 
     * Set the 'UseInventory' element value. 
    					Description: Indicates whether the passenger uses an inventory space..
    				Constraints: Required.Range: Value must be in the range 1 and 3.
    				
     * 
     * @param useInventory
     */
    public void setUseInventory(boolean useInventory) {
        this.useInventory = useInventory;
    }

    /** 
     * Get the 'Address' element value. Description: The passenger's address..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Address getAddress() {
        return address;
    }

    /** 
     * Set the 'Address' element value. Description: The passenger's address..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param address
     */
    public void setAddress(Address address) {
        this.address = address;
    }

    /** 
     * Get the 'Company' element value. 
    					Description: The company where the passenger works..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCompany() {
        return company;
    }

    /** 
     * Set the 'Company' element value. 
    					Description: The company where the passenger works..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param company
     */
    public void setCompany(String company) {
        this.company = company;
    }

    /** 
     * Get the 'Comments' element value. Description: A comment for the passenger..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getComments() {
        return comments;
    }

    /** 
     * Set the 'Comments' element value. Description: A comment for the passenger..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param comments
     */
    public void setComments(String comments) {
        this.comments = comments;
    }

    /** 
     * Get the 'Passport' element value. Description: The passenger's passport number..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getPassport() {
        return passport;
    }

    /** 
     * Set the 'Passport' element value. Description: The passenger's passport number..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param passport
     */
    public void setPassport(String passport) {
        this.passport = passport;
    }

    /** 
     * Get the 'Nationality' element value. Description: The nationality of the passenger..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getNationality() {
        return nationality;
    }

    /** 
     * Set the 'Nationality' element value. Description: The nationality of the passenger..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param nationality
     */
    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    /** 
     * Get the 'ProfileId' element value. 
    					Description: The Radixx profile ID that is associated with this reservation.
    				Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @return value
     */
    public long getProfileId() {
        return profileId;
    }

    /** 
     * Set the 'ProfileId' element value. 
    					Description: The Radixx profile ID that is associated with this reservation.
    				Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @param profileId
     */
    public void setProfileId(long profileId) {
        this.profileId = profileId;
    }

    /** 
     * Get the 'ContactInfos' element value. Description: Collection of passenger contacts.
    				Constraints: Optional (Not Required).
    				
    					Range: Value must be in the range 1 and 2147483647.
    				
     * 
     * @return value
     */
    public ArrayOfContactInfo getContactInfos() {
        return contactInfos;
    }

    /** 
     * Set the 'ContactInfos' element value. Description: Collection of passenger contacts.
    				Constraints: Optional (Not Required).
    				
    					Range: Value must be in the range 1 and 2147483647.
    				
     * 
     * @param contactInfos
     */
    public void setContactInfos(ArrayOfContactInfo contactInfos) {
        this.contactInfos = contactInfos;
    }
}
