
package org.datacontract.schemas.radixx.connectpoint.reservation;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ModifyPNR.UpdateRecordLocator">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="RecordLocator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ReservationKey"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="LogicalFlightKey"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="PhysicalFlightKey"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CustomerKey"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="AirlinePersonKey"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ModifyPNRUpdateRecordLocator
{
    private String recordLocator;
    private String reservationKey;
    private String logicalFlightKey;
    private String physicalFlightKey;
    private String customerKey;
    private String airlinePersonKey;

    /** 
     * Get the 'RecordLocator' element value. 
    					Description: The Record Locator from an excternal system that identifies this
    					passenger segment.
    				Constraints: Required.Range: Length must be in the range 1 and 20.
    				
     * 
     * @return value
     */
    public String getRecordLocator() {
        return recordLocator;
    }

    /** 
     * Set the 'RecordLocator' element value. 
    					Description: The Record Locator from an excternal system that identifies this
    					passenger segment.
    				Constraints: Required.Range: Length must be in the range 1 and 20.
    				
     * 
     * @param recordLocator
     */
    public void setRecordLocator(String recordLocator) {
        this.recordLocator = recordLocator;
    }

    /** 
     * Get the 'ReservationKey' element value. 
    					Description: The Reservation Key returned in the PNR response.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getReservationKey() {
        return reservationKey;
    }

    /** 
     * Set the 'ReservationKey' element value. 
    					Description: The Reservation Key returned in the PNR response.
    				Constraints: Required.
     * 
     * @param reservationKey
     */
    public void setReservationKey(String reservationKey) {
        this.reservationKey = reservationKey;
    }

    /** 
     * Get the 'LogicalFlightKey' element value. 
    					Description: The Logical Flight Key returned in the PNR response.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getLogicalFlightKey() {
        return logicalFlightKey;
    }

    /** 
     * Set the 'LogicalFlightKey' element value. 
    					Description: The Logical Flight Key returned in the PNR response.
    				Constraints: Required.
     * 
     * @param logicalFlightKey
     */
    public void setLogicalFlightKey(String logicalFlightKey) {
        this.logicalFlightKey = logicalFlightKey;
    }

    /** 
     * Get the 'PhysicalFlightKey' element value. 
    					Description: The Physical Flight Key returned in the PNR response.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getPhysicalFlightKey() {
        return physicalFlightKey;
    }

    /** 
     * Set the 'PhysicalFlightKey' element value. 
    					Description: The Physical Flight Key returned in the PNR response.
    				Constraints: Required.
     * 
     * @param physicalFlightKey
     */
    public void setPhysicalFlightKey(String physicalFlightKey) {
        this.physicalFlightKey = physicalFlightKey;
    }

    /** 
     * Get the 'CustomerKey' element value. 
    					Description: The Customer Key returned in the PNR response.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getCustomerKey() {
        return customerKey;
    }

    /** 
     * Set the 'CustomerKey' element value. 
    					Description: The Customer Key returned in the PNR response.
    				Constraints: Required.
     * 
     * @param customerKey
     */
    public void setCustomerKey(String customerKey) {
        this.customerKey = customerKey;
    }

    /** 
     * Get the 'AirlinePersonKey' element value. 
    					Description: The Airline Person Key returned in the PNR response.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getAirlinePersonKey() {
        return airlinePersonKey;
    }

    /** 
     * Set the 'AirlinePersonKey' element value. 
    					Description: The Airline Person Key returned in the PNR response.
    				Constraints: Required.
     * 
     * @param airlinePersonKey
     */
    public void setAirlinePersonKey(String airlinePersonKey) {
        this.airlinePersonKey = airlinePersonKey;
    }
}
