
package org.datacontract.schemas.radixx.connectpoint.reservation;

import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Response" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OAFlight">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="Key" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="OALogicalFlightID" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="DepartureDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Origin" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Destination" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="OperatingCarrier" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="OperatingFlightNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="DepartureTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="Arrivaltime" minOccurs="0"/>
 *     &lt;xs:element type="ns:ArrayOfOAFlightPerson" nillable="true" name="OAFlightPersons"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OAFlight
{
    private String key;
    private Integer OALogicalFlightID;
    private Date departureDate;
    private String origin;
    private String destination;
    private String operatingCarrier;
    private String operatingFlightNumber;
    private Date departureTime;
    private Date arrivaltime;
    private ArrayOfOAFlightPerson OAFlightPersons;

    /** 
     * Get the 'Key' element value. 
    					Description: The internal unique identifier for the logical flight. The Key
    					consists of the LogicalFlightID, a ':', and the departure date and
    					time. Example: If the departure date and time is 3/16/2011 4:00:00
    					PM and the LogicalFlightID is 1422781, then the Key is
    					1422781:3/16/2011 4:00:00 PM..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getKey() {
        return key;
    }

    /** 
     * Set the 'Key' element value. 
    					Description: The internal unique identifier for the logical flight. The Key
    					consists of the LogicalFlightID, a ':', and the departure date and
    					time. Example: If the departure date and time is 3/16/2011 4:00:00
    					PM and the LogicalFlightID is 1422781, then the Key is
    					1422781:3/16/2011 4:00:00 PM..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param key
     */
    public void setKey(String key) {
        this.key = key;
    }

    /** 
     * Get the 'OALogicalFlightID' element value. 
    					Description: The automatically system generated unique identifier for the
    					booked light (known as a logical flight)..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getOALogicalFlightID() {
        return OALogicalFlightID;
    }

    /** 
     * Set the 'OALogicalFlightID' element value. 
    					Description: The automatically system generated unique identifier for the
    					booked light (known as a logical flight)..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param OALogicalFlightID
     */
    public void setOALogicalFlightID(Integer OALogicalFlightID) {
        this.OALogicalFlightID = OALogicalFlightID;
    }

    /** 
     * Get the 'DepartureDate' element value. Description: The day the flight takes leave..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getDepartureDate() {
        return departureDate;
    }

    /** 
     * Set the 'DepartureDate' element value. Description: The day the flight takes leave..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param departureDate
     */
    public void setDepartureDate(Date departureDate) {
        this.departureDate = departureDate;
    }

    /** 
     * Get the 'Origin' element value. 
    					Description: The code identifying the point of departure..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getOrigin() {
        return origin;
    }

    /** 
     * Set the 'Origin' element value. 
    					Description: The code identifying the point of departure..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param origin
     */
    public void setOrigin(String origin) {
        this.origin = origin;
    }

    /** 
     * Get the 'Destination' element value. 
    					Description: The code identifying the final landing place..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getDestination() {
        return destination;
    }

    /** 
     * Set the 'Destination' element value. 
    					Description: The code identifying the final landing place..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param destination
     */
    public void setDestination(String destination) {
        this.destination = destination;
    }

    /** 
     * Get the 'OperatingCarrier' element value. 
    					Description: The two letter IATA code for the carrier operating the
    					flight/leg..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getOperatingCarrier() {
        return operatingCarrier;
    }

    /** 
     * Set the 'OperatingCarrier' element value. 
    					Description: The two letter IATA code for the carrier operating the
    					flight/leg..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param operatingCarrier
     */
    public void setOperatingCarrier(String operatingCarrier) {
        this.operatingCarrier = operatingCarrier;
    }

    /** 
     * Get the 'OperatingFlightNumber' element value. 
    					Description: The flight number for the operating flight for the leg.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getOperatingFlightNumber() {
        return operatingFlightNumber;
    }

    /** 
     * Set the 'OperatingFlightNumber' element value. 
    					Description: The flight number for the operating flight for the leg.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param operatingFlightNumber
     */
    public void setOperatingFlightNumber(String operatingFlightNumber) {
        this.operatingFlightNumber = operatingFlightNumber;
    }

    /** 
     * Get the 'DepartureTime' element value. 
    					Description: The specified time the logical flight departs in the time zone of
    					the point of departure.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getDepartureTime() {
        return departureTime;
    }

    /** 
     * Set the 'DepartureTime' element value. 
    					Description: The specified time the logical flight departs in the time zone of
    					the point of departure.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param departureTime
     */
    public void setDepartureTime(Date departureTime) {
        this.departureTime = departureTime;
    }

    /** 
     * Get the 'Arrivaltime' element value. 
    					Description: The time that the logical flight arrives at its destination in
    					the time zone of the destination.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getArrivaltime() {
        return arrivaltime;
    }

    /** 
     * Set the 'Arrivaltime' element value. 
    					Description: The time that the logical flight arrives at its destination in
    					the time zone of the destination.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param arrivaltime
     */
    public void setArrivaltime(Date arrivaltime) {
        this.arrivaltime = arrivaltime;
    }

    /** 
     * Get the 'OAFlightPersons' element value. 
    					Description: List of Person Pointers for passenger of this PNR on Other
    					Airline flights.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public ArrayOfOAFlightPerson getOAFlightPersons() {
        return OAFlightPersons;
    }

    /** 
     * Set the 'OAFlightPersons' element value. 
    					Description: List of Person Pointers for passenger of this PNR on Other
    					Airline flights.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param OAFlightPersons
     */
    public void setOAFlightPersons(ArrayOfOAFlightPerson OAFlightPersons) {
        this.OAFlightPersons = OAFlightPersons;
    }
}
