
package org.datacontract.schemas.radixx.connectpoint.reservation;

import java.math.BigDecimal;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Response" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payment">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="Key" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="ReservationPaymentID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CardHolder" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="PaymentAmount" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="ExpirationDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CardNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CVCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Authorizationcode" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="TerminalID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CurrencyPaid" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="CheckNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Reference" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Result" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="TransactionID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ValueCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="TransactionIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="SettlementBatch" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="AuthorizedAmount" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="VoucherNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FFNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="Miles" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="PaymentComment" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="BaseCurrency" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="BaseAmount" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="ExchangeRate" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="ExchangeRateDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="DocumentReceivedBy" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="BatchProcessStart" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="BatchProcessExtracted" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="TicketCouponNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="ATCANDateProcessed" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="TicketType" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="GcxID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="GcxOptOption" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="GcxExported" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="GcxExportedDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="OriginalCurrency" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="OriginalAmount" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="IATANum" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ProcessorID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="MerchantID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ProcessorName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="OriginalPaymentMethod" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="TransactionStatus" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ResponseMessage" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ResponseCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="PersonOrgID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FirstName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="LastName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CompanyName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Address" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Address2" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="City" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="State" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Postal" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Country" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="PaymentMethod" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="DatePaid" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="UserData" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CardVerification" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="GrossAmtResCurrency" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="GrossAmtPayCurrency" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="NetAmtResCurrency" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="CommissionDeductedResCurrency" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="CommissionDeductedPayCurrency" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="RptNetFrmResCurrency" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="RptCommissionFromResCurrency" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="RptCommissionFromPayCurrency" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="TotalRefundResCurrency" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="TotalRefundRptCurrency" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="TotalRefundPayCurrency" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="RedeemedVoucherAmount" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="UserID" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="OriginalPaymentID" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="PaymentReservationChannelID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="AncillaryData01" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="AncillaryData02" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="AncillaryData03" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="AncillaryData04" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="AncillaryData05" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Payment1
{
    private String key;
    private Integer reservationPaymentID;
    private String cardHolder;
    private BigDecimal paymentAmount;
    private Date expirationDate;
    private String cardNumber;
    private String CVCode;
    private String authorizationcode;
    private Integer terminalID;
    private String currencyPaid;
    private Integer checkNumber;
    private String reference;
    private String result;
    private String transactionID;
    private String valueCode;
    private Integer transactionIndicator;
    private String settlementBatch;
    private BigDecimal authorizedAmount;
    private Integer voucherNumber;
    private String FFNumber;
    private Integer miles;
    private String paymentComment;
    private String baseCurrency;
    private BigDecimal baseAmount;
    private BigDecimal exchangeRate;
    private Date exchangeRateDate;
    private String documentReceivedBy;
    private Date batchProcessStart;
    private Integer batchProcessExtracted;
    private String ticketCouponNumber;
    private Date ATCANDateProcessed;
    private String ticketType;
    private String gcxID;
    private String gcxOptOption;
    private Integer gcxExported;
    private Date gcxExportedDate;
    private String originalCurrency;
    private BigDecimal originalAmount;
    private String IATANum;
    private String processorID;
    private String merchantID;
    private String processorName;
    private String originalPaymentMethod;
    private Integer transactionStatus;
    private String responseMessage;
    private String responseCode;
    private Integer personOrgID;
    private String firstName;
    private String lastName;
    private String companyName;
    private String address;
    private String address2;
    private String city;
    private String state;
    private String postal;
    private String country;
    private String paymentMethod;
    private Date datePaid;
    private String userData;
    private String cardVerification;
    private BigDecimal grossAmtResCurrency;
    private BigDecimal grossAmtPayCurrency;
    private BigDecimal netAmtResCurrency;
    private BigDecimal commissionDeductedResCurrency;
    private BigDecimal commissionDeductedPayCurrency;
    private BigDecimal rptNetFrmResCurrency;
    private BigDecimal rptCommissionFromResCurrency;
    private BigDecimal rptCommissionFromPayCurrency;
    private BigDecimal totalRefundResCurrency;
    private BigDecimal totalRefundRptCurrency;
    private BigDecimal totalRefundPayCurrency;
    private BigDecimal redeemedVoucherAmount;
    private String userID;
    private Integer originalPaymentID;
    private Integer paymentReservationChannelID;
    private String ancillaryData01;
    private String ancillaryData02;
    private String ancillaryData03;
    private String ancillaryData04;
    private String ancillaryData05;

    /** 
     * Get the 'Key' element value. 
    					Description: The internal object key for this payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getKey() {
        return key;
    }

    /** 
     * Set the 'Key' element value. 
    					Description: The internal object key for this payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param key
     */
    public void setKey(String key) {
        this.key = key;
    }

    /** 
     * Get the 'ReservationPaymentID' element value. 
    					Description: The database level unique identifier for this payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getReservationPaymentID() {
        return reservationPaymentID;
    }

    /** 
     * Set the 'ReservationPaymentID' element value. 
    					Description: The database level unique identifier for this payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param reservationPaymentID
     */
    public void setReservationPaymentID(Integer reservationPaymentID) {
        this.reservationPaymentID = reservationPaymentID;
    }

    /** 
     * Get the 'CardHolder' element value. 
    					Description: The name of the cardholder of the payment in the event that the
    					payment is a credit card payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCardHolder() {
        return cardHolder;
    }

    /** 
     * Set the 'CardHolder' element value. 
    					Description: The name of the cardholder of the payment in the event that the
    					payment is a credit card payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param cardHolder
     */
    public void setCardHolder(String cardHolder) {
        this.cardHolder = cardHolder;
    }

    /** 
     * Get the 'PaymentAmount' element value. 
    					Description: The amount for the payment in the payment currency in the
    					CurrencyPaid field.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getPaymentAmount() {
        return paymentAmount;
    }

    /** 
     * Set the 'PaymentAmount' element value. 
    					Description: The amount for the payment in the payment currency in the
    					CurrencyPaid field.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param paymentAmount
     */
    public void setPaymentAmount(BigDecimal paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    /** 
     * Get the 'ExpirationDate' element value. 
    					Description: The expiration date for the payment type when applicable.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getExpirationDate() {
        return expirationDate;
    }

    /** 
     * Set the 'ExpirationDate' element value. 
    					Description: The expiration date for the payment type when applicable.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param expirationDate
     */
    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    /** 
     * Get the 'CardNumber' element value. 
    					Description: The credit card number for the payment. NOTE: This value will be
    					masked.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCardNumber() {
        return cardNumber;
    }

    /** 
     * Set the 'CardNumber' element value. 
    					Description: The credit card number for the payment. NOTE: This value will be
    					masked.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param cardNumber
     */
    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    /** 
     * Get the 'CVCode' element value. 
    					Description: The CVV code on the back of most credit cards.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCVCode() {
        return CVCode;
    }

    /** 
     * Set the 'CVCode' element value. 
    					Description: The CVV code on the back of most credit cards.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param CVCode
     */
    public void setCVCode(String CVCode) {
        this.CVCode = CVCode;
    }

    /** 
     * Get the 'Authorizationcode' element value. 
    					Description: The authorization code received by the credit card processor
    					authorizing the payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getAuthorizationcode() {
        return authorizationcode;
    }

    /** 
     * Set the 'Authorizationcode' element value. 
    					Description: The authorization code received by the credit card processor
    					authorizing the payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param authorizationcode
     */
    public void setAuthorizationcode(String authorizationcode) {
        this.authorizationcode = authorizationcode;
    }

    /** 
     * Get the 'TerminalID' element value. 
    					Description: Integer representing the credit card terminal that processed this
    					transaction.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getTerminalID() {
        return terminalID;
    }

    /** 
     * Set the 'TerminalID' element value. 
    					Description: Integer representing the credit card terminal that processed this
    					transaction.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param terminalID
     */
    public void setTerminalID(Integer terminalID) {
        this.terminalID = terminalID;
    }

    /** 
     * Get the 'CurrencyPaid' element value. Description: The currency for this payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCurrencyPaid() {
        return currencyPaid;
    }

    /** 
     * Set the 'CurrencyPaid' element value. Description: The currency for this payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param currencyPaid
     */
    public void setCurrencyPaid(String currencyPaid) {
        this.currencyPaid = currencyPaid;
    }

    /** 
     * Get the 'CheckNumber' element value. 
    					Description: The check number for the payment if this payment was made by
    					check.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getCheckNumber() {
        return checkNumber;
    }

    /** 
     * Set the 'CheckNumber' element value. 
    					Description: The check number for the payment if this payment was made by
    					check.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param checkNumber
     */
    public void setCheckNumber(Integer checkNumber) {
        this.checkNumber = checkNumber;
    }

    /** 
     * Get the 'Reference' element value. 
    					Description: A Reference code that can be used for refunds that is used by
    					certain credit card processors.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getReference() {
        return reference;
    }

    /** 
     * Set the 'Reference' element value. 
    					Description: A Reference code that can be used for refunds that is used by
    					certain credit card processors.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param reference
     */
    public void setReference(String reference) {
        this.reference = reference;
    }

    /** 
     * Get the 'Result' element value. 
    					Description: The result field that is used by certain credit card processors.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getResult() {
        return result;
    }

    /** 
     * Set the 'Result' element value. 
    					Description: The result field that is used by certain credit card processors.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param result
     */
    public void setResult(String result) {
        this.result = result;
    }

    /** 
     * Get the 'TransactionID' element value. 
    					Description: The transaction ID that can be used for refunds by certain credit
    					card processors.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getTransactionID() {
        return transactionID;
    }

    /** 
     * Set the 'TransactionID' element value. 
    					Description: The transaction ID that can be used for refunds by certain credit
    					card processors.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param transactionID
     */
    public void setTransactionID(String transactionID) {
        this.transactionID = transactionID;
    }

    /** 
     * Get the 'ValueCode' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getValueCode() {
        return valueCode;
    }

    /** 
     * Set the 'ValueCode' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param valueCode
     */
    public void setValueCode(String valueCode) {
        this.valueCode = valueCode;
    }

    /** 
     * Get the 'TransactionIndicator' element value. 
    					Description: Indicates the current state of the transaction.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getTransactionIndicator() {
        return transactionIndicator;
    }

    /** 
     * Set the 'TransactionIndicator' element value. 
    					Description: Indicates the current state of the transaction.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param transactionIndicator
     */
    public void setTransactionIndicator(Integer transactionIndicator) {
        this.transactionIndicator = transactionIndicator;
    }

    /** 
     * Get the 'SettlementBatch' element value. 
    					Description: Used by certain processors to indicate which settlement batch
    					this transaction has been or will be included.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getSettlementBatch() {
        return settlementBatch;
    }

    /** 
     * Set the 'SettlementBatch' element value. 
    					Description: Used by certain processors to indicate which settlement batch
    					this transaction has been or will be included.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param settlementBatch
     */
    public void setSettlementBatch(String settlementBatch) {
        this.settlementBatch = settlementBatch;
    }

    /** 
     * Get the 'AuthorizedAmount' element value. 
    					Description: The amount that was authorized by the credit card processor in
    					the event that the processor supports partial amounts.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getAuthorizedAmount() {
        return authorizedAmount;
    }

    /** 
     * Set the 'AuthorizedAmount' element value. 
    					Description: The amount that was authorized by the credit card processor in
    					the event that the processor supports partial amounts.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param authorizedAmount
     */
    public void setAuthorizedAmount(BigDecimal authorizedAmount) {
        this.authorizedAmount = authorizedAmount;
    }

    /** 
     * Get the 'VoucherNumber' element value. 
    					Description: The voucher number for the Radixx voucher that was used for this
    					payment in the event that this payment is a voucher payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getVoucherNumber() {
        return voucherNumber;
    }

    /** 
     * Set the 'VoucherNumber' element value. 
    					Description: The voucher number for the Radixx voucher that was used for this
    					payment in the event that this payment is a voucher payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param voucherNumber
     */
    public void setVoucherNumber(Integer voucherNumber) {
        this.voucherNumber = voucherNumber;
    }

    /** 
     * Get the 'FFNumber' element value. 
    					Description: The frequent flyer number for the passenger making this payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getFFNumber() {
        return FFNumber;
    }

    /** 
     * Set the 'FFNumber' element value. 
    					Description: The frequent flyer number for the passenger making this payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param FFNumber
     */
    public void setFFNumber(String FFNumber) {
        this.FFNumber = FFNumber;
    }

    /** 
     * Get the 'Miles' element value. 
    					Description: The number of miles to deduct from the frequent flyer system.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getMiles() {
        return miles;
    }

    /** 
     * Set the 'Miles' element value. 
    					Description: The number of miles to deduct from the frequent flyer system.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param miles
     */
    public void setMiles(Integer miles) {
        this.miles = miles;
    }

    /** 
     * Get the 'PaymentComment' element value. 
    					Description: Any comments added to the payment by the Call Center user or
    					application.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getPaymentComment() {
        return paymentComment;
    }

    /** 
     * Set the 'PaymentComment' element value. 
    					Description: Any comments added to the payment by the Call Center user or
    					application.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param paymentComment
     */
    public void setPaymentComment(String paymentComment) {
        this.paymentComment = paymentComment;
    }

    /** 
     * Get the 'BaseCurrency' element value. Description: The Reporting Currency of the
    					system.Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getBaseCurrency() {
        return baseCurrency;
    }

    /** 
     * Set the 'BaseCurrency' element value. Description: The Reporting Currency of the
    					system.Constraints: Optional (Not Required).
    				
     * 
     * @param baseCurrency
     */
    public void setBaseCurrency(String baseCurrency) {
        this.baseCurrency = baseCurrency;
    }

    /** 
     * Get the 'BaseAmount' element value. 
    					Description: The amount of the payment in the Reporting Currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getBaseAmount() {
        return baseAmount;
    }

    /** 
     * Set the 'BaseAmount' element value. 
    					Description: The amount of the payment in the Reporting Currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param baseAmount
     */
    public void setBaseAmount(BigDecimal baseAmount) {
        this.baseAmount = baseAmount;
    }

    /** 
     * Get the 'ExchangeRate' element value. 
    					Description: The exchange rate used to convert from the payment amount in the
    					CurrencyPaid to the ReservationCurrency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getExchangeRate() {
        return exchangeRate;
    }

    /** 
     * Set the 'ExchangeRate' element value. 
    					Description: The exchange rate used to convert from the payment amount in the
    					CurrencyPaid to the ReservationCurrency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param exchangeRate
     */
    public void setExchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    /** 
     * Get the 'ExchangeRateDate' element value. 
    					Description: The effect date of the exchange rate used to convert from the
    					payment amount in the CurrencyPaid to the ReservationCurrency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getExchangeRateDate() {
        return exchangeRateDate;
    }

    /** 
     * Set the 'ExchangeRateDate' element value. 
    					Description: The effect date of the exchange rate used to convert from the
    					payment amount in the CurrencyPaid to the ReservationCurrency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param exchangeRateDate
     */
    public void setExchangeRateDate(Date exchangeRateDate) {
        this.exchangeRateDate = exchangeRateDate;
    }

    /** 
     * Get the 'DocumentReceivedBy' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getDocumentReceivedBy() {
        return documentReceivedBy;
    }

    /** 
     * Set the 'DocumentReceivedBy' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param documentReceivedBy
     */
    public void setDocumentReceivedBy(String documentReceivedBy) {
        this.documentReceivedBy = documentReceivedBy;
    }

    /** 
     * Get the 'BatchProcessStart' element value. 
    					Description: The date time that this transaction was chosen for extract via a
    					batch extract process.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getBatchProcessStart() {
        return batchProcessStart;
    }

    /** 
     * Set the 'BatchProcessStart' element value. 
    					Description: The date time that this transaction was chosen for extract via a
    					batch extract process.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param batchProcessStart
     */
    public void setBatchProcessStart(Date batchProcessStart) {
        this.batchProcessStart = batchProcessStart;
    }

    /** 
     * Get the 'BatchProcessExtracted' element value. 
    					Description: Whether or not this record was extracted successfully in the
    					batch transaction.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getBatchProcessExtracted() {
        return batchProcessExtracted;
    }

    /** 
     * Set the 'BatchProcessExtracted' element value. 
    					Description: Whether or not this record was extracted successfully in the
    					batch transaction.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param batchProcessExtracted
     */
    public void setBatchProcessExtracted(Integer batchProcessExtracted) {
        this.batchProcessExtracted = batchProcessExtracted;
    }

    /** 
     * Get the 'TicketCouponNumber' element value. 
    					Description: The IATA ticket number for the payment if this payment is for an
    					IATA Electronic Ticket Transaction.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getTicketCouponNumber() {
        return ticketCouponNumber;
    }

    /** 
     * Set the 'TicketCouponNumber' element value. 
    					Description: The IATA ticket number for the payment if this payment is for an
    					IATA Electronic Ticket Transaction.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param ticketCouponNumber
     */
    public void setTicketCouponNumber(String ticketCouponNumber) {
        this.ticketCouponNumber = ticketCouponNumber;
    }

    /** 
     * Get the 'ATCANDateProcessed' element value. 
    					Description: The process date for ATCAN for UATP payments.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getATCANDateProcessed() {
        return ATCANDateProcessed;
    }

    /** 
     * Set the 'ATCANDateProcessed' element value. 
    					Description: The process date for ATCAN for UATP payments.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param ATCANDateProcessed
     */
    public void setATCANDateProcessed(Date ATCANDateProcessed) {
        this.ATCANDateProcessed = ATCANDateProcessed;
    }

    /** 
     * Get the 'TicketType' element value. 
    					Description: The type of ticket represented by this payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getTicketType() {
        return ticketType;
    }

    /** 
     * Set the 'TicketType' element value. 
    					Description: The type of ticket represented by this payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param ticketType
     */
    public void setTicketType(String ticketType) {
        this.ticketType = ticketType;
    }

    /** 
     * Get the 'GcxID' element value. 
    					Description: In the event that this payment was made using GCX Dynamic
    					Currency Conversion, this field is the transaction ID received
    					from GCX.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getGcxID() {
        return gcxID;
    }

    /** 
     * Set the 'GcxID' element value. 
    					Description: In the event that this payment was made using GCX Dynamic
    					Currency Conversion, this field is the transaction ID received
    					from GCX.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param gcxID
     */
    public void setGcxID(String gcxID) {
        this.gcxID = gcxID;
    }

    /** 
     * Get the 'GcxOptOption' element value. 
    					Description: In the event that this payment was made using GCX Dynamic
    					Currency Conversion, this field represents the GCX options that
    					was used in the conversion..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getGcxOptOption() {
        return gcxOptOption;
    }

    /** 
     * Set the 'GcxOptOption' element value. 
    					Description: In the event that this payment was made using GCX Dynamic
    					Currency Conversion, this field represents the GCX options that
    					was used in the conversion..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param gcxOptOption
     */
    public void setGcxOptOption(String gcxOptOption) {
        this.gcxOptOption = gcxOptOption;
    }

    /** 
     * Get the 'GcxExported' element value. 
    					Description: Whether or not this record was exported to GCX for settlement.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getGcxExported() {
        return gcxExported;
    }

    /** 
     * Set the 'GcxExported' element value. 
    					Description: Whether or not this record was exported to GCX for settlement.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param gcxExported
     */
    public void setGcxExported(Integer gcxExported) {
        this.gcxExported = gcxExported;
    }

    /** 
     * Get the 'GcxExportedDate' element value. 
    					Description: The date the record was exported to GCX for settlement.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getGcxExportedDate() {
        return gcxExportedDate;
    }

    /** 
     * Set the 'GcxExportedDate' element value. 
    					Description: The date the record was exported to GCX for settlement.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param gcxExportedDate
     */
    public void setGcxExportedDate(Date gcxExportedDate) {
        this.gcxExportedDate = gcxExportedDate;
    }

    /** 
     * Get the 'OriginalCurrency' element value. 
    					Description: The Original Currency for this payment in the event this payment
    					represents a refund.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getOriginalCurrency() {
        return originalCurrency;
    }

    /** 
     * Set the 'OriginalCurrency' element value. 
    					Description: The Original Currency for this payment in the event this payment
    					represents a refund.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param originalCurrency
     */
    public void setOriginalCurrency(String originalCurrency) {
        this.originalCurrency = originalCurrency;
    }

    /** 
     * Get the 'OriginalAmount' element value. 
    					Description: The Original amount for this payment in the event this payment
    					represents a refund.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getOriginalAmount() {
        return originalAmount;
    }

    /** 
     * Set the 'OriginalAmount' element value. 
    					Description: The Original amount for this payment in the event this payment
    					represents a refund.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param originalAmount
     */
    public void setOriginalAmount(BigDecimal originalAmount) {
        this.originalAmount = originalAmount;
    }

    /** 
     * Get the 'IATANum' element value. 
    					Description: The IATA number for the agency who's credit limit was used for
    					this payment..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getIATANum() {
        return IATANum;
    }

    /** 
     * Set the 'IATANum' element value. 
    					Description: The IATA number for the agency who's credit limit was used for
    					this payment..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param IATANum
     */
    public void setIATANum(String IATANum) {
        this.IATANum = IATANum;
    }

    /** 
     * Get the 'ProcessorID' element value. 
    					Description: The unique ID received from certain credit card processors..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getProcessorID() {
        return processorID;
    }

    /** 
     * Set the 'ProcessorID' element value. 
    					Description: The unique ID received from certain credit card processors..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param processorID
     */
    public void setProcessorID(String processorID) {
        this.processorID = processorID;
    }

    /** 
     * Get the 'MerchantID' element value. 
    					Description: The merchant ID that was used to receive a credit card
    					authorization.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getMerchantID() {
        return merchantID;
    }

    /** 
     * Set the 'MerchantID' element value. 
    					Description: The merchant ID that was used to receive a credit card
    					authorization.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param merchantID
     */
    public void setMerchantID(String merchantID) {
        this.merchantID = merchantID;
    }

    /** 
     * Get the 'ProcessorName' element value. 
    					Description: The name of the credit card processor that was used to obtain the
    					authorization.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getProcessorName() {
        return processorName;
    }

    /** 
     * Set the 'ProcessorName' element value. 
    					Description: The name of the credit card processor that was used to obtain the
    					authorization.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param processorName
     */
    public void setProcessorName(String processorName) {
        this.processorName = processorName;
    }

    /** 
     * Get the 'OriginalPaymentMethod' element value. 
    					Description: The original payment method that was used in the event that this
    					payment is a refund.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getOriginalPaymentMethod() {
        return originalPaymentMethod;
    }

    /** 
     * Set the 'OriginalPaymentMethod' element value. 
    					Description: The original payment method that was used in the event that this
    					payment is a refund.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param originalPaymentMethod
     */
    public void setOriginalPaymentMethod(String originalPaymentMethod) {
        this.originalPaymentMethod = originalPaymentMethod;
    }

    /** 
     * Get the 'TransactionStatus' element value. 
    					Description: The payment effective status for this payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getTransactionStatus() {
        return transactionStatus;
    }

    /** 
     * Set the 'TransactionStatus' element value. 
    					Description: The payment effective status for this payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param transactionStatus
     */
    public void setTransactionStatus(Integer transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    /** 
     * Get the 'ResponseMessage' element value. 
    					Description: The response message received from certain credit card
    					processors.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getResponseMessage() {
        return responseMessage;
    }

    /** 
     * Set the 'ResponseMessage' element value. 
    					Description: The response message received from certain credit card
    					processors.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param responseMessage
     */
    public void setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
    }

    /** 
     * Get the 'ResponseCode' element value. 
    					Description: The response code received from certain credit card processors.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getResponseCode() {
        return responseCode;
    }

    /** 
     * Set the 'ResponseCode' element value. 
    					Description: The response code received from certain credit card processors.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param responseCode
     */
    public void setResponseCode(String responseCode) {
        this.responseCode = responseCode;
    }

    /** 
     * Get the 'PersonOrgID' element value. 
    					Description: The PersonOrgID of the person responsible for the payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getPersonOrgID() {
        return personOrgID;
    }

    /** 
     * Set the 'PersonOrgID' element value. 
    					Description: The PersonOrgID of the person responsible for the payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param personOrgID
     */
    public void setPersonOrgID(Integer personOrgID) {
        this.personOrgID = personOrgID;
    }

    /** 
     * Get the 'FirstName' element value. 
    					Description: The First Name of the person responsible for the payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getFirstName() {
        return firstName;
    }

    /** 
     * Set the 'FirstName' element value. 
    					Description: The First Name of the person responsible for the payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param firstName
     */
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    /** 
     * Get the 'LastName' element value. 
    					Description: The Lastname of the person responsible for the payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getLastName() {
        return lastName;
    }

    /** 
     * Set the 'LastName' element value. 
    					Description: The Lastname of the person responsible for the payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param lastName
     */
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    /** 
     * Get the 'CompanyName' element value. 
    					Description: The Companyname for the person responsible for the payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCompanyName() {
        return companyName;
    }

    /** 
     * Set the 'CompanyName' element value. 
    					Description: The Companyname for the person responsible for the payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param companyName
     */
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    /** 
     * Get the 'Address' element value. 
    					Description: The first address line of the person responsible for the payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getAddress() {
        return address;
    }

    /** 
     * Set the 'Address' element value. 
    					Description: The first address line of the person responsible for the payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param address
     */
    public void setAddress(String address) {
        this.address = address;
    }

    /** 
     * Get the 'Address2' element value. 
    					Description: The second address line of the person responsible for the
    					payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getAddress2() {
        return address2;
    }

    /** 
     * Set the 'Address2' element value. 
    					Description: The second address line of the person responsible for the
    					payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param address2
     */
    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    /** 
     * Get the 'City' element value. 
    					Description: The city for the person responsible for the payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCity() {
        return city;
    }

    /** 
     * Set the 'City' element value. 
    					Description: The city for the person responsible for the payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param city
     */
    public void setCity(String city) {
        this.city = city;
    }

    /** 
     * Get the 'State' element value. 
    					Description: The state for the person responsible for the payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getState() {
        return state;
    }

    /** 
     * Set the 'State' element value. 
    					Description: The state for the person responsible for the payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param state
     */
    public void setState(String state) {
        this.state = state;
    }

    /** 
     * Get the 'Postal' element value. 
    					Description: The postal code for the person responsible for the payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getPostal() {
        return postal;
    }

    /** 
     * Set the 'Postal' element value. 
    					Description: The postal code for the person responsible for the payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param postal
     */
    public void setPostal(String postal) {
        this.postal = postal;
    }

    /** 
     * Get the 'Country' element value. 
    					Description: The Country for the person responsible for the payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCountry() {
        return country;
    }

    /** 
     * Set the 'Country' element value. 
    					Description: The Country for the person responsible for the payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param country
     */
    public void setCountry(String country) {
        this.country = country;
    }

    /** 
     * Get the 'PaymentMethod' element value. Description: The method or type of payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getPaymentMethod() {
        return paymentMethod;
    }

    /** 
     * Set the 'PaymentMethod' element value. Description: The method or type of payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param paymentMethod
     */
    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    /** 
     * Get the 'DatePaid' element value. 
    					Description: The accounting date, in GMT, for this payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getDatePaid() {
        return datePaid;
    }

    /** 
     * Set the 'DatePaid' element value. 
    					Description: The accounting date, in GMT, for this payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param datePaid
     */
    public void setDatePaid(Date datePaid) {
        this.datePaid = datePaid;
    }

    /** 
     * Get the 'UserData' element value. Description: Any miscellaneous user data.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getUserData() {
        return userData;
    }

    /** 
     * Set the 'UserData' element value. Description: Any miscellaneous user data.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param userData
     */
    public void setUserData(String userData) {
        this.userData = userData;
    }

    /** 
     * Get the 'CardVerification' element value. 
    					Description: The card verification code for certain credit card processors.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCardVerification() {
        return cardVerification;
    }

    /** 
     * Set the 'CardVerification' element value. 
    					Description: The card verification code for certain credit card processors.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param cardVerification
     */
    public void setCardVerification(String cardVerification) {
        this.cardVerification = cardVerification;
    }

    /** 
     * Get the 'GrossAmtResCurrency' element value. 
    					Description: The Gross Amount for this payment in the Reservation Currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getGrossAmtResCurrency() {
        return grossAmtResCurrency;
    }

    /** 
     * Set the 'GrossAmtResCurrency' element value. 
    					Description: The Gross Amount for this payment in the Reservation Currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param grossAmtResCurrency
     */
    public void setGrossAmtResCurrency(BigDecimal grossAmtResCurrency) {
        this.grossAmtResCurrency = grossAmtResCurrency;
    }

    /** 
     * Get the 'GrossAmtPayCurrency' element value. 
    					Description: The Gross Amount for this payment in the Reporting Currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getGrossAmtPayCurrency() {
        return grossAmtPayCurrency;
    }

    /** 
     * Set the 'GrossAmtPayCurrency' element value. 
    					Description: The Gross Amount for this payment in the Reporting Currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param grossAmtPayCurrency
     */
    public void setGrossAmtPayCurrency(BigDecimal grossAmtPayCurrency) {
        this.grossAmtPayCurrency = grossAmtPayCurrency;
    }

    /** 
     * Get the 'NetAmtResCurrency' element value. 
    					Description: The Net Amount (minus commission) for this payment in the
    					reservation currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getNetAmtResCurrency() {
        return netAmtResCurrency;
    }

    /** 
     * Set the 'NetAmtResCurrency' element value. 
    					Description: The Net Amount (minus commission) for this payment in the
    					reservation currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param netAmtResCurrency
     */
    public void setNetAmtResCurrency(BigDecimal netAmtResCurrency) {
        this.netAmtResCurrency = netAmtResCurrency;
    }

    /** 
     * Get the 'CommissionDeductedResCurrency' element value. 
    					Description: The commission deducted from this payment for travel agencies
    					paying by invoice in the reservation currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getCommissionDeductedResCurrency() {
        return commissionDeductedResCurrency;
    }

    /** 
     * Set the 'CommissionDeductedResCurrency' element value. 
    					Description: The commission deducted from this payment for travel agencies
    					paying by invoice in the reservation currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param commissionDeductedResCurrency
     */
    public void setCommissionDeductedResCurrency(
            BigDecimal commissionDeductedResCurrency) {
        this.commissionDeductedResCurrency = commissionDeductedResCurrency;
    }

    /** 
     * Get the 'CommissionDeductedPayCurrency' element value. 
    					Description: The commission deducted from this payment for travel agencies
    					paying by invoice in the payment currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getCommissionDeductedPayCurrency() {
        return commissionDeductedPayCurrency;
    }

    /** 
     * Set the 'CommissionDeductedPayCurrency' element value. 
    					Description: The commission deducted from this payment for travel agencies
    					paying by invoice in the payment currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param commissionDeductedPayCurrency
     */
    public void setCommissionDeductedPayCurrency(
            BigDecimal commissionDeductedPayCurrency) {
        this.commissionDeductedPayCurrency = commissionDeductedPayCurrency;
    }

    /** 
     * Get the 'RptNetFrmResCurrency' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getRptNetFrmResCurrency() {
        return rptNetFrmResCurrency;
    }

    /** 
     * Set the 'RptNetFrmResCurrency' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param rptNetFrmResCurrency
     */
    public void setRptNetFrmResCurrency(BigDecimal rptNetFrmResCurrency) {
        this.rptNetFrmResCurrency = rptNetFrmResCurrency;
    }

    /** 
     * Get the 'RptCommissionFromResCurrency' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getRptCommissionFromResCurrency() {
        return rptCommissionFromResCurrency;
    }

    /** 
     * Set the 'RptCommissionFromResCurrency' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param rptCommissionFromResCurrency
     */
    public void setRptCommissionFromResCurrency(
            BigDecimal rptCommissionFromResCurrency) {
        this.rptCommissionFromResCurrency = rptCommissionFromResCurrency;
    }

    /** 
     * Get the 'RptCommissionFromPayCurrency' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getRptCommissionFromPayCurrency() {
        return rptCommissionFromPayCurrency;
    }

    /** 
     * Set the 'RptCommissionFromPayCurrency' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param rptCommissionFromPayCurrency
     */
    public void setRptCommissionFromPayCurrency(
            BigDecimal rptCommissionFromPayCurrency) {
        this.rptCommissionFromPayCurrency = rptCommissionFromPayCurrency;
    }

    /** 
     * Get the 'TotalRefundResCurrency' element value. 
    					Description: Total amount refunded in Reservation Currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getTotalRefundResCurrency() {
        return totalRefundResCurrency;
    }

    /** 
     * Set the 'TotalRefundResCurrency' element value. 
    					Description: Total amount refunded in Reservation Currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param totalRefundResCurrency
     */
    public void setTotalRefundResCurrency(BigDecimal totalRefundResCurrency) {
        this.totalRefundResCurrency = totalRefundResCurrency;
    }

    /** 
     * Get the 'TotalRefundRptCurrency' element value. 
    					Description: Total amount refunded in Reporting Currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getTotalRefundRptCurrency() {
        return totalRefundRptCurrency;
    }

    /** 
     * Set the 'TotalRefundRptCurrency' element value. 
    					Description: Total amount refunded in Reporting Currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param totalRefundRptCurrency
     */
    public void setTotalRefundRptCurrency(BigDecimal totalRefundRptCurrency) {
        this.totalRefundRptCurrency = totalRefundRptCurrency;
    }

    /** 
     * Get the 'TotalRefundPayCurrency' element value. 
    					Description: Total Amount refunded in the Payment Currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getTotalRefundPayCurrency() {
        return totalRefundPayCurrency;
    }

    /** 
     * Set the 'TotalRefundPayCurrency' element value. 
    					Description: Total Amount refunded in the Payment Currency.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param totalRefundPayCurrency
     */
    public void setTotalRefundPayCurrency(BigDecimal totalRefundPayCurrency) {
        this.totalRefundPayCurrency = totalRefundPayCurrency;
    }

    /** 
     * Get the 'RedeemedVoucherAmount' element value. Description: The Amount for the redeemed voucher.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getRedeemedVoucherAmount() {
        return redeemedVoucherAmount;
    }

    /** 
     * Set the 'RedeemedVoucherAmount' element value. Description: The Amount for the redeemed voucher.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param redeemedVoucherAmount
     */
    public void setRedeemedVoucherAmount(BigDecimal redeemedVoucherAmount) {
        this.redeemedVoucherAmount = redeemedVoucherAmount;
    }

    /** 
     * Get the 'UserID' element value. 
    					Description: The user ID of the person or system processing the payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getUserID() {
        return userID;
    }

    /** 
     * Set the 'UserID' element value. 
    					Description: The user ID of the person or system processing the payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param userID
     */
    public void setUserID(String userID) {
        this.userID = userID;
    }

    /** 
     * Get the 'OriginalPaymentID' element value. 
    					Description: The Original Payment ID in the event this payment is a refund.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getOriginalPaymentID() {
        return originalPaymentID;
    }

    /** 
     * Set the 'OriginalPaymentID' element value. 
    					Description: The Original Payment ID in the event this payment is a refund.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param originalPaymentID
     */
    public void setOriginalPaymentID(Integer originalPaymentID) {
        this.originalPaymentID = originalPaymentID;
    }

    /** 
     * Get the 'PaymentReservationChannelID' element value. 
    					Description: The reservation channel that submitted the payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getPaymentReservationChannelID() {
        return paymentReservationChannelID;
    }

    /** 
     * Set the 'PaymentReservationChannelID' element value. 
    					Description: The reservation channel that submitted the payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param paymentReservationChannelID
     */
    public void setPaymentReservationChannelID(
            Integer paymentReservationChannelID) {
        this.paymentReservationChannelID = paymentReservationChannelID;
    }

    /** 
     * Get the 'AncillaryData01' element value. 
    					Description: Ancillary field 1 used by Radixx to store data specific to
    					certain payment processor types. Please refer to client account
    					manager to query on data stored within.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getAncillaryData01() {
        return ancillaryData01;
    }

    /** 
     * Set the 'AncillaryData01' element value. 
    					Description: Ancillary field 1 used by Radixx to store data specific to
    					certain payment processor types. Please refer to client account
    					manager to query on data stored within.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param ancillaryData01
     */
    public void setAncillaryData01(String ancillaryData01) {
        this.ancillaryData01 = ancillaryData01;
    }

    /** 
     * Get the 'AncillaryData02' element value. 
    					Description: Ancillary field 2 used by Radixx to store data specific to
    					certain payment processor types. Please refer to client account
    					manager to query on data stored within.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getAncillaryData02() {
        return ancillaryData02;
    }

    /** 
     * Set the 'AncillaryData02' element value. 
    					Description: Ancillary field 2 used by Radixx to store data specific to
    					certain payment processor types. Please refer to client account
    					manager to query on data stored within.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param ancillaryData02
     */
    public void setAncillaryData02(String ancillaryData02) {
        this.ancillaryData02 = ancillaryData02;
    }

    /** 
     * Get the 'AncillaryData03' element value. 
    					Description: Ancillary field 3 used by Radixx to store data specific to
    					certain payment processor types. Please refer to client account
    					manager to query on data stored within.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getAncillaryData03() {
        return ancillaryData03;
    }

    /** 
     * Set the 'AncillaryData03' element value. 
    					Description: Ancillary field 3 used by Radixx to store data specific to
    					certain payment processor types. Please refer to client account
    					manager to query on data stored within.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param ancillaryData03
     */
    public void setAncillaryData03(String ancillaryData03) {
        this.ancillaryData03 = ancillaryData03;
    }

    /** 
     * Get the 'AncillaryData04' element value. 
    					Description: Ancillary field 4 used by Radixx to store data specific to
    					certain payment processor types. Please refer to client account
    					manager to query on data stored within.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getAncillaryData04() {
        return ancillaryData04;
    }

    /** 
     * Set the 'AncillaryData04' element value. 
    					Description: Ancillary field 4 used by Radixx to store data specific to
    					certain payment processor types. Please refer to client account
    					manager to query on data stored within.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param ancillaryData04
     */
    public void setAncillaryData04(String ancillaryData04) {
        this.ancillaryData04 = ancillaryData04;
    }

    /** 
     * Get the 'AncillaryData05' element value. 
    					Description: Ancillary field 5 used by Radixx to store data specific to
    					certain payment processor types. Please refer to client account
    					manager to query on data stored within.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getAncillaryData05() {
        return ancillaryData05;
    }

    /** 
     * Set the 'AncillaryData05' element value. 
    					Description: Ancillary field 5 used by Radixx to store data specific to
    					certain payment processor types. Please refer to client account
    					manager to query on data stored within.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param ancillaryData05
     */
    public void setAncillaryData05(String ancillaryData05) {
        this.ancillaryData05 = ancillaryData05;
    }
}
