
package org.datacontract.schemas.radixx.connectpoint.reservation;

import java.util.Date;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsGenderTypes;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsRelationshipTypes;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Person">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:int" name="PersonOrgID"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FirstName"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="LastName"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="MiddleName"/>
 *     &lt;xs:element type="xs:int" name="Age"/>
 *     &lt;xs:element type="xs:dateTime" name="DOB"/>
 *     &lt;xs:element type="ns:Enumerations.GenderTypes" name="Gender"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Title"/>
 *     &lt;xs:element type="xs:int" name="NationalityLaguageID"/>
 *     &lt;xs:element type="ns:Enumerations.RelationshipTypes" name="RelationType"/>
 *     &lt;xs:element type="xs:int" name="WBCID"/>
 *     &lt;xs:element type="xs:int" name="PTCID"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="PTC"/>
 *     &lt;xs:element type="xs:int" name="TravelsWithPersonOrgID"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="RedressNumber"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="KnownTravelerNumber"/>
 *     &lt;xs:element type="xs:boolean" name="MarketingOptIn"/>
 *     &lt;xs:element type="xs:boolean" name="UseInventory"/>
 *     &lt;xs:element type="ns1:Address" nillable="true" name="Address"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Company"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Comments"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Passport"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Nationality"/>
 *     &lt;xs:element type="xs:long" name="ProfileId"/>
 *     &lt;xs:element type="xs:boolean" name="IsPrimaryPassenger"/>
 *     &lt;xs:element type="ns1:ArrayOfContactInfo" nillable="true" name="ContactInfos"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FrequentFlyerNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Suffix" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Person
{
    private int personOrgID;
    private String firstName;
    private String lastName;
    private String middleName;
    private int age;
    private Date DOB;
    private EnumerationsGenderTypes gender;
    private String title;
    private int nationalityLaguageID;
    private EnumerationsRelationshipTypes relationType;
    private int WBCID;
    private int PTCID;
    private String PTC;
    private int travelsWithPersonOrgID;
    private String redressNumber;
    private String knownTravelerNumber;
    private boolean marketingOptIn;
    private boolean useInventory;
    private Address address;
    private String company;
    private String comments;
    private String passport;
    private String nationality;
    private long profileId;
    private boolean isPrimaryPassenger;
    private ArrayOfContactInfo contactInfos;
    private String frequentFlyerNumber;
    private String suffix;

    /** 
     * Get the 'PersonOrgID' element value. 
    					Description: The database identifier for this person.
    				Constraints: Required.
     * 
     * @return value
     */
    public int getPersonOrgID() {
        return personOrgID;
    }

    /** 
     * Set the 'PersonOrgID' element value. 
    					Description: The database identifier for this person.
    				Constraints: Required.
     * 
     * @param personOrgID
     */
    public void setPersonOrgID(int personOrgID) {
        this.personOrgID = personOrgID;
    }

    /** 
     * Get the 'FirstName' element value. Description: The person's first name.
    				Constraints: Required.
    					Range: Length must be in the range -2147483648 and 2147483647.
    				
     * 
     * @return value
     */
    public String getFirstName() {
        return firstName;
    }

    /** 
     * Set the 'FirstName' element value. Description: The person's first name.
    				Constraints: Required.
    					Range: Length must be in the range -2147483648 and 2147483647.
    				
     * 
     * @param firstName
     */
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    /** 
     * Get the 'LastName' element value. Description: The person's last name.
    				Constraints: Required.Range: Length must be in the range 1 and 64.
    				
     * 
     * @return value
     */
    public String getLastName() {
        return lastName;
    }

    /** 
     * Set the 'LastName' element value. Description: The person's last name.
    				Constraints: Required.Range: Length must be in the range 1 and 64.
    				
     * 
     * @param lastName
     */
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    /** 
     * Get the 'MiddleName' element value. Description: The person's middle name.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				
     * 
     * @return value
     */
    public String getMiddleName() {
        return middleName;
    }

    /** 
     * Set the 'MiddleName' element value. Description: The person's middle name.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				
     * 
     * @param middleName
     */
    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    /** 
     * Get the 'Age' element value. Description: The person's age.Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public int getAge() {
        return age;
    }

    /** 
     * Set the 'Age' element value. Description: The person's age.Constraints: Optional (Not Required).
    				
     * 
     * @param age
     */
    public void setAge(int age) {
        this.age = age;
    }

    /** 
     * Get the 'DOB' element value. Description: The person's data of birth.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getDOB() {
        return DOB;
    }

    /** 
     * Set the 'DOB' element value. Description: The person's data of birth.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param DOB
     */
    public void setDOB(Date DOB) {
        this.DOB = DOB;
    }

    /** 
     * Get the 'Gender' element value. Description: The person's Gender.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public EnumerationsGenderTypes getGender() {
        return gender;
    }

    /** 
     * Set the 'Gender' element value. Description: The person's Gender.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param gender
     */
    public void setGender(EnumerationsGenderTypes gender) {
        this.gender = gender;
    }

    /** 
     * Get the 'Title' element value. Description: The person's title.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 20.
    				
     * 
     * @return value
     */
    public String getTitle() {
        return title;
    }

    /** 
     * Set the 'Title' element value. Description: The person's title.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 20.
    				
     * 
     * @param title
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /** 
     * Get the 'NationalityLaguageID' element value. 
    					Description: The IATCN Language ID of the person's nationality.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public int getNationalityLaguageID() {
        return nationalityLaguageID;
    }

    /** 
     * Set the 'NationalityLaguageID' element value. 
    					Description: The IATCN Language ID of the person's nationality.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param nationalityLaguageID
     */
    public void setNationalityLaguageID(int nationalityLaguageID) {
        this.nationalityLaguageID = nationalityLaguageID;
    }

    /** 
     * Get the 'RelationType' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public EnumerationsRelationshipTypes getRelationType() {
        return relationType;
    }

    /** 
     * Set the 'RelationType' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param relationType
     */
    public void setRelationType(EnumerationsRelationshipTypes relationType) {
        this.relationType = relationType;
    }

    /** 
     * Get the 'WBCID' element value. 
    					Description: Wieght and Balance Passenger Type Code ID for this passenger.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public int getWBCID() {
        return WBCID;
    }

    /** 
     * Set the 'WBCID' element value. 
    					Description: Wieght and Balance Passenger Type Code ID for this passenger.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param WBCID
     */
    public void setWBCID(int WBCID) {
        this.WBCID = WBCID;
    }

    /** 
     * Get the 'PTCID' element value. 
    					Description: The code representing the Passenger Type Code for the passenger
    					segment. (Radixx predefined ID 1=ADULT, 5=INFANT, 6=CHILD).
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public int getPTCID() {
        return PTCID;
    }

    /** 
     * Set the 'PTCID' element value. 
    					Description: The code representing the Passenger Type Code for the passenger
    					segment. (Radixx predefined ID 1=ADULT, 5=INFANT, 6=CHILD).
    				Constraints: Optional (Not Required).
    				
     * 
     * @param PTCID
     */
    public void setPTCID(int PTCID) {
        this.PTCID = PTCID;
    }

    /** 
     * Get the 'PTC' element value. 
    					Description: The iata standard code representing the Passenger Type Code for
    					the passenger segment. (industry predefined Codes ADT, INF, CHD).
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getPTC() {
        return PTC;
    }

    /** 
     * Set the 'PTC' element value. 
    					Description: The iata standard code representing the Passenger Type Code for
    					the passenger segment. (industry predefined Codes ADT, INF, CHD).
    				Constraints: Optional (Not Required).
    				
     * 
     * @param PTC
     */
    public void setPTC(String PTC) {
        this.PTC = PTC;
    }

    /** 
     * Get the 'TravelsWithPersonOrgID' element value. 
    					Description: If an infant is traveling with an adult then the infants person
    					org id will be populated in this property.
    				Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @return value
     */
    public int getTravelsWithPersonOrgID() {
        return travelsWithPersonOrgID;
    }

    /** 
     * Set the 'TravelsWithPersonOrgID' element value. 
    					Description: If an infant is traveling with an adult then the infants person
    					org id will be populated in this property.
    				Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @param travelsWithPersonOrgID
     */
    public void setTravelsWithPersonOrgID(int travelsWithPersonOrgID) {
        this.travelsWithPersonOrgID = travelsWithPersonOrgID;
    }

    /** 
     * Get the 'RedressNumber' element value. Description: Secure Flight Information.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getRedressNumber() {
        return redressNumber;
    }

    /** 
     * Set the 'RedressNumber' element value. Description: Secure Flight Information.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param redressNumber
     */
    public void setRedressNumber(String redressNumber) {
        this.redressNumber = redressNumber;
    }

    /** 
     * Get the 'KnownTravelerNumber' element value. Description: Secure Flight Information.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getKnownTravelerNumber() {
        return knownTravelerNumber;
    }

    /** 
     * Set the 'KnownTravelerNumber' element value. Description: Secure Flight Information.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param knownTravelerNumber
     */
    public void setKnownTravelerNumber(String knownTravelerNumber) {
        this.knownTravelerNumber = knownTravelerNumber;
    }

    /** 
     * Get the 'MarketingOptIn' element value. 
    					Description: Indicator if the passenger wishes to subscribe to marketing
    					information.
    				Constraints: Required.
     * 
     * @return value
     */
    public boolean isMarketingOptIn() {
        return marketingOptIn;
    }

    /** 
     * Set the 'MarketingOptIn' element value. 
    					Description: Indicator if the passenger wishes to subscribe to marketing
    					information.
    				Constraints: Required.
     * 
     * @param marketingOptIn
     */
    public void setMarketingOptIn(boolean marketingOptIn) {
        this.marketingOptIn = marketingOptIn;
    }

    /** 
     * Get the 'UseInventory' element value. Description: .Constraints: Required.
     * 
     * @return value
     */
    public boolean isUseInventory() {
        return useInventory;
    }

    /** 
     * Set the 'UseInventory' element value. Description: .Constraints: Required.
     * 
     * @param useInventory
     */
    public void setUseInventory(boolean useInventory) {
        this.useInventory = useInventory;
    }

    /** 
     * Get the 'Address' element value. Description: Address Object.Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Address getAddress() {
        return address;
    }

    /** 
     * Set the 'Address' element value. Description: Address Object.Constraints: Optional (Not Required).
    				
     * 
     * @param address
     */
    public void setAddress(Address address) {
        this.address = address;
    }

    /** 
     * Get the 'Company' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCompany() {
        return company;
    }

    /** 
     * Set the 'Company' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param company
     */
    public void setCompany(String company) {
        this.company = company;
    }

    /** 
     * Get the 'Comments' element value. 
    					Description: Any comments that are associated to this person.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getComments() {
        return comments;
    }

    /** 
     * Set the 'Comments' element value. 
    					Description: Any comments that are associated to this person.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param comments
     */
    public void setComments(String comments) {
        this.comments = comments;
    }

    /** 
     * Get the 'Passport' element value. Description: The passport number for this person.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getPassport() {
        return passport;
    }

    /** 
     * Set the 'Passport' element value. Description: The passport number for this person.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param passport
     */
    public void setPassport(String passport) {
        this.passport = passport;
    }

    /** 
     * Get the 'Nationality' element value. Description: The Nationality code for this
    					person.Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getNationality() {
        return nationality;
    }

    /** 
     * Set the 'Nationality' element value. Description: The Nationality code for this
    					person.Constraints: Optional (Not Required).
    				
     * 
     * @param nationality
     */
    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    /** 
     * Get the 'ProfileId' element value. 
    					Description: The ID of the Radixx profile to which this person is associated.
    					This can be used to determine the number of times a passenger has
    					travelled..
    				Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @return value
     */
    public long getProfileId() {
        return profileId;
    }

    /** 
     * Set the 'ProfileId' element value. 
    					Description: The ID of the Radixx profile to which this person is associated.
    					This can be used to determine the number of times a passenger has
    					travelled..
    				Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @param profileId
     */
    public void setProfileId(long profileId) {
        this.profileId = profileId;
    }

    /** 
     * Get the 'IsPrimaryPassenger' element value. 
    					Description: Idicator of the assumed primary passenger of the reservation.
    					There can only be one primary traveller..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public boolean isIsPrimaryPassenger() {
        return isPrimaryPassenger;
    }

    /** 
     * Set the 'IsPrimaryPassenger' element value. 
    					Description: Idicator of the assumed primary passenger of the reservation.
    					There can only be one primary traveller..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param isPrimaryPassenger
     */
    public void setIsPrimaryPassenger(boolean isPrimaryPassenger) {
        this.isPrimaryPassenger = isPrimaryPassenger;
    }

    /** 
     * Get the 'ContactInfos' element value. Description: Collection of contact informations.
    				Constraints: Optional (Not Required).
    				
    					Range: Value must be in the range 1 and 2147483647.
    				
     * 
     * @return value
     */
    public ArrayOfContactInfo getContactInfos() {
        return contactInfos;
    }

    /** 
     * Set the 'ContactInfos' element value. Description: Collection of contact informations.
    				Constraints: Optional (Not Required).
    				
    					Range: Value must be in the range 1 and 2147483647.
    				
     * 
     * @param contactInfos
     */
    public void setContactInfos(ArrayOfContactInfo contactInfos) {
        this.contactInfos = contactInfos;
    }

    /** 
     * Get the 'FrequentFlyerNumber' element value. 
    					Description: Frequent Flyer Number, to support pure data storage of FFN on the
    					Person record. No internal Radixx functionality works off of the
    					value stored.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getFrequentFlyerNumber() {
        return frequentFlyerNumber;
    }

    /** 
     * Set the 'FrequentFlyerNumber' element value. 
    					Description: Frequent Flyer Number, to support pure data storage of FFN on the
    					Person record. No internal Radixx functionality works off of the
    					value stored.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param frequentFlyerNumber
     */
    public void setFrequentFlyerNumber(String frequentFlyerNumber) {
        this.frequentFlyerNumber = frequentFlyerNumber;
    }

    /** 
     * Get the 'Suffix' element value. Description: The person's suffix.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 20.
    				
     * 
     * @return value
     */
    public String getSuffix() {
        return suffix;
    }

    /** 
     * Set the 'Suffix' element value. Description: The person's suffix.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 20.
    				
     * 
     * @param suffix
     */
    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }
}
