
package org.datacontract.schemas.radixx.connectpoint.reservation;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Response" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReservationContact">
 *   &lt;xs:complexContent mixed="false">
 *     &lt;xs:extension base="ns:Person">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:int" name="VendorID" minOccurs="0"/>
 *         &lt;xs:element type="xs:boolean" name="MarketingOptIn" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="RedressNum" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="KnownTravNum" minOccurs="0"/>
 *         &lt;xs:element type="ns:ArrayOfContactInfo" nillable="true" name="ContactInfos" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ReservationContact extends Person1
{
    private Integer vendorID;
    private Boolean marketingOptIn;
    private String redressNum;
    private String knownTravNum;
    private ArrayOfContactInfo1 contactInfos;

    /** 
     * Get the 'VendorID' element value. 
    							Description: The unique identifier for the vendor fulfilling the
    							vacation/travel package item.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Integer getVendorID() {
        return vendorID;
    }

    /** 
     * Set the 'VendorID' element value. 
    							Description: The unique identifier for the vendor fulfilling the
    							vacation/travel package item.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param vendorID
     */
    public void setVendorID(Integer vendorID) {
        this.vendorID = vendorID;
    }

    /** 
     * Get the 'MarketingOptIn' element value. 
    							Description: Whether or not this person has indicated they would like to
    							receive marketing information.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Boolean getMarketingOptIn() {
        return marketingOptIn;
    }

    /** 
     * Set the 'MarketingOptIn' element value. 
    							Description: Whether or not this person has indicated they would like to
    							receive marketing information.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param marketingOptIn
     */
    public void setMarketingOptIn(Boolean marketingOptIn) {
        this.marketingOptIn = marketingOptIn;
    }

    /** 
     * Get the 'RedressNum' element value. 
    							Description: The 'Redress Number' for this passenger segment for US TSA
    							purposes.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getRedressNum() {
        return redressNum;
    }

    /** 
     * Set the 'RedressNum' element value. 
    							Description: The 'Redress Number' for this passenger segment for US TSA
    							purposes.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param redressNum
     */
    public void setRedressNum(String redressNum) {
        this.redressNum = redressNum;
    }

    /** 
     * Get the 'KnownTravNum' element value. 
    							Description: The 'Known Traveller Number' for this passenger segment for
    							compliance with governmental security regimes.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getKnownTravNum() {
        return knownTravNum;
    }

    /** 
     * Set the 'KnownTravNum' element value. 
    							Description: The 'Known Traveller Number' for this passenger segment for
    							compliance with governmental security regimes.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param knownTravNum
     */
    public void setKnownTravNum(String knownTravNum) {
        this.knownTravNum = knownTravNum;
    }

    /** 
     * Get the 'ContactInfos' element value. 
    							Description: The collection of contact information for this
    							ReservationContact.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public ArrayOfContactInfo1 getContactInfos() {
        return contactInfos;
    }

    /** 
     * Set the 'ContactInfos' element value. 
    							Description: The collection of contact information for this
    							ReservationContact.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param contactInfos
     */
    public void setContactInfos(ArrayOfContactInfo1 contactInfos) {
        this.contactInfos = contactInfos;
    }
}
