
package org.datacontract.schemas.radixx.connectpoint.reservation;

import java.math.BigDecimal;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Response" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReservationPaymentMap">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="Key" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="ReservationPaymentID" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="AmountApplied" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="ReservationChargeID" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="DatePaid" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="OriginalReferencePaymentID" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="RefundAmount" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ReservationPaymentMap
{
    private String key;
    private Integer reservationPaymentID;
    private BigDecimal amountApplied;
    private Integer reservationChargeID;
    private Date datePaid;
    private Integer originalReferencePaymentID;
    private BigDecimal refundAmount;

    /** 
     * Get the 'Key' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getKey() {
        return key;
    }

    /** 
     * Set the 'Key' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param key
     */
    public void setKey(String key) {
        this.key = key;
    }

    /** 
     * Get the 'ReservationPaymentID' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getReservationPaymentID() {
        return reservationPaymentID;
    }

    /** 
     * Set the 'ReservationPaymentID' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param reservationPaymentID
     */
    public void setReservationPaymentID(Integer reservationPaymentID) {
        this.reservationPaymentID = reservationPaymentID;
    }

    /** 
     * Get the 'AmountApplied' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getAmountApplied() {
        return amountApplied;
    }

    /** 
     * Set the 'AmountApplied' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param amountApplied
     */
    public void setAmountApplied(BigDecimal amountApplied) {
        this.amountApplied = amountApplied;
    }

    /** 
     * Get the 'ReservationChargeID' element value. 
    					Description: A sequence that uniquely identifies this charge.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getReservationChargeID() {
        return reservationChargeID;
    }

    /** 
     * Set the 'ReservationChargeID' element value. 
    					Description: A sequence that uniquely identifies this charge.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param reservationChargeID
     */
    public void setReservationChargeID(Integer reservationChargeID) {
        this.reservationChargeID = reservationChargeID;
    }

    /** 
     * Get the 'DatePaid' element value. 
    					Description: The accounting date, in GMT, for this payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getDatePaid() {
        return datePaid;
    }

    /** 
     * Set the 'DatePaid' element value. 
    					Description: The accounting date, in GMT, for this payment.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param datePaid
     */
    public void setDatePaid(Date datePaid) {
        this.datePaid = datePaid;
    }

    /** 
     * Get the 'OriginalReferencePaymentID' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getOriginalReferencePaymentID() {
        return originalReferencePaymentID;
    }

    /** 
     * Set the 'OriginalReferencePaymentID' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param originalReferencePaymentID
     */
    public void setOriginalReferencePaymentID(Integer originalReferencePaymentID) {
        this.originalReferencePaymentID = originalReferencePaymentID;
    }

    /** 
     * Get the 'RefundAmount' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getRefundAmount() {
        return refundAmount;
    }

    /** 
     * Set the 'RefundAmount' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param refundAmount
     */
    public void setRefundAmount(BigDecimal refundAmount) {
        this.refundAmount = refundAmount;
    }
}
