
package org.datacontract.schemas.radixx.connectpoint.reservation;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetrievePNR.ActionTypes">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="GetReservation"/>
 *     &lt;xs:enumeration value="GetReservationViewOnly"/>
 *     &lt;xs:enumeration value="GetReservationWithETicketInformation"/>
 *     &lt;xs:enumeration value="GetReservationWithETicketInformationViewOnly"/>
 *     &lt;xs:enumeration value="GetReservationFromSession"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum RetrievePNRActionTypes {
    /** 
     * 
    <summary>Action to retreive PNR information</summary>
    
     */
    GET_RESERVATION("GetReservation"), /** 
                                        * 
                                       <summary>Action to retreive PNR information Modify Functions will
                                       not be permitted</summary>
                                       
                                        */
    GET_RESERVATION_VIEW_ONLY("GetReservationViewOnly"), /** 
                                                          * 
                                                         <summary>Action to retreive PNR information, inclusive of
                                                         eticketing info</summary>
                                                         
                                                          */
    GET_RESERVATION_WITH_E_TICKET_INFORMATION(
            "GetReservationWithETicketInformation"), /** 
                                                      * 
                                                     <summary>Action to retreive PNR information, inclusive of
                                                     eticketing info</summary>
                                                     
                                                      */
    GET_RESERVATION_WITH_E_TICKET_INFORMATION_VIEW_ONLY(
            "GetReservationWithETicketInformationViewOnly"), /** 
                                                              * 
                                                             <summary>Action to retreive PNR information from data in session,
                                                             not from the system</summary>
                                                             
                                                              */
    GET_RESERVATION_FROM_SESSION("GetReservationFromSession");
    private final String value;

    private RetrievePNRActionTypes(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static RetrievePNRActionTypes convert(String value) {
        for (RetrievePNRActionTypes inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
