
package org.datacontract.schemas.radixx.connectpoint.reservation;

import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Response" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatAssignment">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="Key" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="PhysicalFlightID" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="ActualDepartureDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FlightNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="ScheduledDeparturetime" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="ScheduledArrivaltime" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="BoardingPassNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Seat" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="RowNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Gate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="OldSeat" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="OldRowNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="Boarded" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CheckInAgent" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="CheckInDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CouponStatusIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="BoardingSequence" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="LastModifiedDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="BoardingPassPrinted" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FrequentFlyerCarrierCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FrequentFlyerNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FrequentFlyerSSRCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FrequentFlyerMemberTierLevel" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FrequentFlyerMemberRating" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="FrequentFlyerNumberActionTracker" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="ReservationChannelID" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="FrequentFlyerInfoReservationChannelID" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="FrequentFlyerNumberLAstModifiedDate" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SeatAssignment
{
    private String key;
    private Integer physicalFlightID;
    private Date actualDepartureDate;
    private String flightNumber;
    private Date scheduledDeparturetime;
    private Date scheduledArrivaltime;
    private Integer boardingPassNumber;
    private String seat;
    private Integer rowNumber;
    private String gate;
    private String oldSeat;
    private Integer oldRowNumber;
    private Boolean boarded;
    private String checkInAgent;
    private Date checkInDate;
    private String couponStatusIndicator;
    private String boardingSequence;
    private Date lastModifiedDate;
    private Integer boardingPassPrinted;
    private String frequentFlyerCarrierCode;
    private String frequentFlyerNumber;
    private String frequentFlyerSSRCode;
    private String frequentFlyerMemberTierLevel;
    private String frequentFlyerMemberRating;
    private Integer frequentFlyerNumberActionTracker;
    private Integer reservationChannelID;
    private Integer frequentFlyerInfoReservationChannelID;
    private Date frequentFlyerNumberLAstModifiedDate;

    /** 
     * Get the 'Key' element value. 
    					Description: The internal object Key for this object.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getKey() {
        return key;
    }

    /** 
     * Set the 'Key' element value. 
    					Description: The internal object Key for this object.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param key
     */
    public void setKey(String key) {
        this.key = key;
    }

    /** 
     * Get the 'PhysicalFlightID' element value. 
    					Description: The database identifier for the physical flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getPhysicalFlightID() {
        return physicalFlightID;
    }

    /** 
     * Set the 'PhysicalFlightID' element value. 
    					Description: The database identifier for the physical flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param physicalFlightID
     */
    public void setPhysicalFlightID(Integer physicalFlightID) {
        this.physicalFlightID = physicalFlightID;
    }

    /** 
     * Get the 'ActualDepartureDate' element value. 
    					Description: The actual date/time of departure from the point of origin in the
    					time zone of the origin airport.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getActualDepartureDate() {
        return actualDepartureDate;
    }

    /** 
     * Set the 'ActualDepartureDate' element value. 
    					Description: The actual date/time of departure from the point of origin in the
    					time zone of the origin airport.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param actualDepartureDate
     */
    public void setActualDepartureDate(Date actualDepartureDate) {
        this.actualDepartureDate = actualDepartureDate;
    }

    /** 
     * Get the 'FlightNumber' element value. Description: The flight number.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getFlightNumber() {
        return flightNumber;
    }

    /** 
     * Set the 'FlightNumber' element value. Description: The flight number.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param flightNumber
     */
    public void setFlightNumber(String flightNumber) {
        this.flightNumber = flightNumber;
    }

    /** 
     * Get the 'ScheduledDeparturetime' element value. 
    					Description: The actual date/time of departure from the point of origin in the
    					time zone of the origin airport.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getScheduledDeparturetime() {
        return scheduledDeparturetime;
    }

    /** 
     * Set the 'ScheduledDeparturetime' element value. 
    					Description: The actual date/time of departure from the point of origin in the
    					time zone of the origin airport.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param scheduledDeparturetime
     */
    public void setScheduledDeparturetime(Date scheduledDeparturetime) {
        this.scheduledDeparturetime = scheduledDeparturetime;
    }

    /** 
     * Get the 'ScheduledArrivaltime' element value. 
    					Description: The scheduled date/time of arrival at the destination in the time
    					zone of the destination airport.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getScheduledArrivaltime() {
        return scheduledArrivaltime;
    }

    /** 
     * Set the 'ScheduledArrivaltime' element value. 
    					Description: The scheduled date/time of arrival at the destination in the time
    					zone of the destination airport.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param scheduledArrivaltime
     */
    public void setScheduledArrivaltime(Date scheduledArrivaltime) {
        this.scheduledArrivaltime = scheduledArrivaltime;
    }

    /** 
     * Get the 'BoardingPassNumber' element value. 
    					Description: The number of the boarding pass issued to this passenger.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getBoardingPassNumber() {
        return boardingPassNumber;
    }

    /** 
     * Set the 'BoardingPassNumber' element value. 
    					Description: The number of the boarding pass issued to this passenger.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param boardingPassNumber
     */
    public void setBoardingPassNumber(Integer boardingPassNumber) {
        this.boardingPassNumber = boardingPassNumber;
    }

    /** 
     * Get the 'Seat' element value. 
    					Description: The seat assigned to this passenger on this physical flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getSeat() {
        return seat;
    }

    /** 
     * Set the 'Seat' element value. 
    					Description: The seat assigned to this passenger on this physical flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param seat
     */
    public void setSeat(String seat) {
        this.seat = seat;
    }

    /** 
     * Get the 'RowNumber' element value. 
    					Description: The row assigned to this passenger on this physical flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getRowNumber() {
        return rowNumber;
    }

    /** 
     * Set the 'RowNumber' element value. 
    					Description: The row assigned to this passenger on this physical flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param rowNumber
     */
    public void setRowNumber(Integer rowNumber) {
        this.rowNumber = rowNumber;
    }

    /** 
     * Get the 'Gate' element value. 
    					Description: The gate from which this flight will depart.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getGate() {
        return gate;
    }

    /** 
     * Set the 'Gate' element value. 
    					Description: The gate from which this flight will depart.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param gate
     */
    public void setGate(String gate) {
        this.gate = gate;
    }

    /** 
     * Get the 'OldSeat' element value. 
    					Description: The old seat number for this passenger on this flight in the
    					event this passenger was moved to a new seat.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getOldSeat() {
        return oldSeat;
    }

    /** 
     * Set the 'OldSeat' element value. 
    					Description: The old seat number for this passenger on this flight in the
    					event this passenger was moved to a new seat.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param oldSeat
     */
    public void setOldSeat(String oldSeat) {
        this.oldSeat = oldSeat;
    }

    /** 
     * Get the 'OldRowNumber' element value. 
    					Description: The old row number for this passenger on this flight in the event
    					this passenger was moved to a new seat.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getOldRowNumber() {
        return oldRowNumber;
    }

    /** 
     * Set the 'OldRowNumber' element value. 
    					Description: The old row number for this passenger on this flight in the event
    					this passenger was moved to a new seat.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param oldRowNumber
     */
    public void setOldRowNumber(Integer oldRowNumber) {
        this.oldRowNumber = oldRowNumber;
    }

    /** 
     * Get the 'Boarded' element value. 
    					Description: Indicates whether or not this passenger boarded this physical
    					flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Boolean getBoarded() {
        return boarded;
    }

    /** 
     * Set the 'Boarded' element value. 
    					Description: Indicates whether or not this passenger boarded this physical
    					flight.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param boarded
     */
    public void setBoarded(Boolean boarded) {
        this.boarded = boarded;
    }

    /** 
     * Get the 'CheckInAgent' element value. 
    					Description: The agent that checked the passenger in.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCheckInAgent() {
        return checkInAgent;
    }

    /** 
     * Set the 'CheckInAgent' element value. 
    					Description: The agent that checked the passenger in.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param checkInAgent
     */
    public void setCheckInAgent(String checkInAgent) {
        this.checkInAgent = checkInAgent;
    }

    /** 
     * Get the 'CheckInDate' element value. 
    					Description: The date, in GMT, that the passenger was checked in.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getCheckInDate() {
        return checkInDate;
    }

    /** 
     * Set the 'CheckInDate' element value. 
    					Description: The date, in GMT, that the passenger was checked in.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param checkInDate
     */
    public void setCheckInDate(Date checkInDate) {
        this.checkInDate = checkInDate;
    }

    /** 
     * Get the 'CouponStatusIndicator' element value. 
    					Description: The IATA coupon status for the issues ticket.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getCouponStatusIndicator() {
        return couponStatusIndicator;
    }

    /** 
     * Set the 'CouponStatusIndicator' element value. 
    					Description: The IATA coupon status for the issues ticket.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param couponStatusIndicator
     */
    public void setCouponStatusIndicator(String couponStatusIndicator) {
        this.couponStatusIndicator = couponStatusIndicator;
    }

    /** 
     * Get the 'BoardingSequence' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getBoardingSequence() {
        return boardingSequence;
    }

    /** 
     * Set the 'BoardingSequence' element value. Description: .Constraints: Optional (Not Required).
    				
     * 
     * @param boardingSequence
     */
    public void setBoardingSequence(String boardingSequence) {
        this.boardingSequence = boardingSequence;
    }

    /** 
     * Get the 'LastModifiedDate' element value. 
    					Description: The date this record use last modified in GMT.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getLastModifiedDate() {
        return lastModifiedDate;
    }

    /** 
     * Set the 'LastModifiedDate' element value. 
    					Description: The date this record use last modified in GMT.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param lastModifiedDate
     */
    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    /** 
     * Get the 'BoardingPassPrinted' element value. 
    					Description: Whether or not the boarding pass has been printed.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getBoardingPassPrinted() {
        return boardingPassPrinted;
    }

    /** 
     * Set the 'BoardingPassPrinted' element value. 
    					Description: Whether or not the boarding pass has been printed.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param boardingPassPrinted
     */
    public void setBoardingPassPrinted(Integer boardingPassPrinted) {
        this.boardingPassPrinted = boardingPassPrinted;
    }

    /** 
     * Get the 'FrequentFlyerCarrierCode' element value. 
    					Description: The carrier code for the frequent flyer number for this passenger
    					as entered in the DCS.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getFrequentFlyerCarrierCode() {
        return frequentFlyerCarrierCode;
    }

    /** 
     * Set the 'FrequentFlyerCarrierCode' element value. 
    					Description: The carrier code for the frequent flyer number for this passenger
    					as entered in the DCS.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param frequentFlyerCarrierCode
     */
    public void setFrequentFlyerCarrierCode(String frequentFlyerCarrierCode) {
        this.frequentFlyerCarrierCode = frequentFlyerCarrierCode;
    }

    /** 
     * Get the 'FrequentFlyerNumber' element value. 
    					Description: The frequent flyer number for this passenger as entered in the
    					DCS.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getFrequentFlyerNumber() {
        return frequentFlyerNumber;
    }

    /** 
     * Set the 'FrequentFlyerNumber' element value. 
    					Description: The frequent flyer number for this passenger as entered in the
    					DCS.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param frequentFlyerNumber
     */
    public void setFrequentFlyerNumber(String frequentFlyerNumber) {
        this.frequentFlyerNumber = frequentFlyerNumber;
    }

    /** 
     * Get the 'FrequentFlyerSSRCode' element value. 
    					Description: The SSR Code used to represent the frequent flyer passenger in
    					the DCS.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getFrequentFlyerSSRCode() {
        return frequentFlyerSSRCode;
    }

    /** 
     * Set the 'FrequentFlyerSSRCode' element value. 
    					Description: The SSR Code used to represent the frequent flyer passenger in
    					the DCS.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param frequentFlyerSSRCode
     */
    public void setFrequentFlyerSSRCode(String frequentFlyerSSRCode) {
        this.frequentFlyerSSRCode = frequentFlyerSSRCode;
    }

    /** 
     * Get the 'FrequentFlyerMemberTierLevel' element value. 
    					Description: The Frequent Flyer Tier Level for this passenger as entered in
    					the DCS.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getFrequentFlyerMemberTierLevel() {
        return frequentFlyerMemberTierLevel;
    }

    /** 
     * Set the 'FrequentFlyerMemberTierLevel' element value. 
    					Description: The Frequent Flyer Tier Level for this passenger as entered in
    					the DCS.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param frequentFlyerMemberTierLevel
     */
    public void setFrequentFlyerMemberTierLevel(
            String frequentFlyerMemberTierLevel) {
        this.frequentFlyerMemberTierLevel = frequentFlyerMemberTierLevel;
    }

    /** 
     * Get the 'FrequentFlyerMemberRating' element value. 
    					Description: The Frequent Flyer Member Rating for this passenger as entered in
    					the DCS.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getFrequentFlyerMemberRating() {
        return frequentFlyerMemberRating;
    }

    /** 
     * Set the 'FrequentFlyerMemberRating' element value. 
    					Description: The Frequent Flyer Member Rating for this passenger as entered in
    					the DCS.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param frequentFlyerMemberRating
     */
    public void setFrequentFlyerMemberRating(String frequentFlyerMemberRating) {
        this.frequentFlyerMemberRating = frequentFlyerMemberRating;
    }

    /** 
     * Get the 'FrequentFlyerNumberActionTracker' element value. 
    					Description: The frequent Flyer Action Tracking Number for this passenger as
    					entered in the DCS.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getFrequentFlyerNumberActionTracker() {
        return frequentFlyerNumberActionTracker;
    }

    /** 
     * Set the 'FrequentFlyerNumberActionTracker' element value. 
    					Description: The frequent Flyer Action Tracking Number for this passenger as
    					entered in the DCS.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param frequentFlyerNumberActionTracker
     */
    public void setFrequentFlyerNumberActionTracker(
            Integer frequentFlyerNumberActionTracker) {
        this.frequentFlyerNumberActionTracker = frequentFlyerNumberActionTracker;
    }

    /** 
     * Get the 'ReservationChannelID' element value. 
    					Description: The reservation channel that created the boarding card for this
    					passenger.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getReservationChannelID() {
        return reservationChannelID;
    }

    /** 
     * Set the 'ReservationChannelID' element value. 
    					Description: The reservation channel that created the boarding card for this
    					passenger.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param reservationChannelID
     */
    public void setReservationChannelID(Integer reservationChannelID) {
        this.reservationChannelID = reservationChannelID;
    }

    /** 
     * Get the 'FrequentFlyerInfoReservationChannelID' element value. 
    					Description: The reservation channel that modified the frequent flyer
    					information.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Integer getFrequentFlyerInfoReservationChannelID() {
        return frequentFlyerInfoReservationChannelID;
    }

    /** 
     * Set the 'FrequentFlyerInfoReservationChannelID' element value. 
    					Description: The reservation channel that modified the frequent flyer
    					information.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param frequentFlyerInfoReservationChannelID
     */
    public void setFrequentFlyerInfoReservationChannelID(
            Integer frequentFlyerInfoReservationChannelID) {
        this.frequentFlyerInfoReservationChannelID = frequentFlyerInfoReservationChannelID;
    }

    /** 
     * Get the 'FrequentFlyerNumberLAstModifiedDate' element value. 
    					Description: The date and time in GMT that the frequent flyer number was last
    					modified.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getFrequentFlyerNumberLAstModifiedDate() {
        return frequentFlyerNumberLAstModifiedDate;
    }

    /** 
     * Set the 'FrequentFlyerNumberLAstModifiedDate' element value. 
    					Description: The date and time in GMT that the frequent flyer number was last
    					modified.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param frequentFlyerNumberLAstModifiedDate
     */
    public void setFrequentFlyerNumberLAstModifiedDate(
            Date frequentFlyerNumberLAstModifiedDate) {
        this.frequentFlyerNumberLAstModifiedDate = frequentFlyerNumberLAstModifiedDate;
    }
}
