
package org.datacontract.schemas.radixx.connectpoint.reservation;

import java.math.BigDecimal;
import java.util.Date;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsCurrencyCodeTypes;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpecialService">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="CodeType"/>
 *     &lt;xs:element type="xs:int" name="ServiceID"/>
 *     &lt;xs:element type="xs:int" name="SSRCategory"/>
 *     &lt;xs:element type="xs:int" name="LogicalFlightID"/>
 *     &lt;xs:element type="xs:dateTime" name="DepartureDate"/>
 *     &lt;xs:element type="xs:decimal" name="Amount"/>
 *     &lt;xs:element type="xs:boolean" name="OverrideAmount"/>
 *     &lt;xs:element type="ns:Enumerations.CurrencyCodeTypes" name="CurrencyCode"/>
 *     &lt;xs:element type="xs:boolean" name="Commissionable" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="Refundable" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ChargeComment"/>
 *     &lt;xs:element type="xs:int" name="PersonOrgID"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SpecialService
{
    private String codeType;
    private int serviceID;
    private int SSRCategory;
    private int logicalFlightID;
    private Date departureDate;
    private BigDecimal amount;
    private boolean overrideAmount;
    private EnumerationsCurrencyCodeTypes currencyCode;
    private Boolean commissionable;
    private Boolean refundable;
    private String chargeComment;
    private int personOrgID;

    /** 
     * Get the 'CodeType' element value. 
    					Description: The Code Type Represents the category for this charge.
    				Constraints: Required.Range: Length must be in the range 1 and 4.
    				
     * 
     * @return value
     */
    public String getCodeType() {
        return codeType;
    }

    /** 
     * Set the 'CodeType' element value. 
    					Description: The Code Type Represents the category for this charge.
    				Constraints: Required.Range: Length must be in the range 1 and 4.
    				
     * 
     * @param codeType
     */
    public void setCodeType(String codeType) {
        this.codeType = codeType;
    }

    /** 
     * Get the 'ServiceID' element value. Description: .Constraints: Required.
     * 
     * @return value
     */
    public int getServiceID() {
        return serviceID;
    }

    /** 
     * Set the 'ServiceID' element value. Description: .Constraints: Required.
     * 
     * @param serviceID
     */
    public void setServiceID(int serviceID) {
        this.serviceID = serviceID;
    }

    /** 
     * Get the 'SSRCategory' element value. Description: .Constraints: Required.
     * 
     * @return value
     */
    public int getSSRCategory() {
        return SSRCategory;
    }

    /** 
     * Set the 'SSRCategory' element value. Description: .Constraints: Required.
     * 
     * @param SSRCategory
     */
    public void setSSRCategory(int SSRCategory) {
        this.SSRCategory = SSRCategory;
    }

    /** 
     * Get the 'LogicalFlightID' element value. 
    					Description: Logical Flight ID of the segment that the SSR will be tied too..
    				Constraints: Required.
     * 
     * @return value
     */
    public int getLogicalFlightID() {
        return logicalFlightID;
    }

    /** 
     * Set the 'LogicalFlightID' element value. 
    					Description: Logical Flight ID of the segment that the SSR will be tied too..
    				Constraints: Required.
     * 
     * @param logicalFlightID
     */
    public void setLogicalFlightID(int logicalFlightID) {
        this.logicalFlightID = logicalFlightID;
    }

    /** 
     * Get the 'DepartureDate' element value. 
    					Description: Departure date of the segment that the SSR will be tied too..
    				Constraints: Required.
     * 
     * @return value
     */
    public Date getDepartureDate() {
        return departureDate;
    }

    /** 
     * Set the 'DepartureDate' element value. 
    					Description: Departure date of the segment that the SSR will be tied too..
    				Constraints: Required.
     * 
     * @param departureDate
     */
    public void setDepartureDate(Date departureDate) {
        this.departureDate = departureDate;
    }

    /** 
     * Get the 'Amount' element value. Description: Amount of the SSR.
    				Constraints: Required.
     * 
     * @return value
     */
    public BigDecimal getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. Description: Amount of the SSR.
    				Constraints: Required.
     * 
     * @param amount
     */
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'OverrideAmount' element value. 
    					Description: Indicator to Overrride the base amount of the SSR amount that is
    					in the System. (This functionality requires the
    					Radixx.ConnectPoint.consumer to be at a higher security privelege.
    				Constraints: Required.
     * 
     * @return value
     */
    public boolean isOverrideAmount() {
        return overrideAmount;
    }

    /** 
     * Set the 'OverrideAmount' element value. 
    					Description: Indicator to Overrride the base amount of the SSR amount that is
    					in the System. (This functionality requires the
    					Radixx.ConnectPoint.consumer to be at a higher security privelege.
    				Constraints: Required.
     * 
     * @param overrideAmount
     */
    public void setOverrideAmount(boolean overrideAmount) {
        this.overrideAmount = overrideAmount;
    }

    /** 
     * Get the 'CurrencyCode' element value. 
    					Description: Currency of the reservation and the SSR charge.
    				Constraints: Required.
     * 
     * @return value
     */
    public EnumerationsCurrencyCodeTypes getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' element value. 
    					Description: Currency of the reservation and the SSR charge.
    				Constraints: Required.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(EnumerationsCurrencyCodeTypes currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the 'Commissionable' element value. 
    					Description: Indicator to if the service is commissionable.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Boolean getCommissionable() {
        return commissionable;
    }

    /** 
     * Set the 'Commissionable' element value. 
    					Description: Indicator to if the service is commissionable.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param commissionable
     */
    public void setCommissionable(Boolean commissionable) {
        this.commissionable = commissionable;
    }

    /** 
     * Get the 'Refundable' element value. 
    					Description: Indicator to if the service is refundable.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Boolean getRefundable() {
        return refundable;
    }

    /** 
     * Set the 'Refundable' element value. 
    					Description: Indicator to if the service is refundable.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param refundable
     */
    public void setRefundable(Boolean refundable) {
        this.refundable = refundable;
    }

    /** 
     * Get the 'ChargeComment' element value. 
    					Description: any comments to be added to provide additonal information.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 255.
    				
     * 
     * @return value
     */
    public String getChargeComment() {
        return chargeComment;
    }

    /** 
     * Set the 'ChargeComment' element value. 
    					Description: any comments to be added to provide additonal information.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 255.
    				
     * 
     * @param chargeComment
     */
    public void setChargeComment(String chargeComment) {
        this.chargeComment = chargeComment;
    }

    /** 
     * Get the 'PersonOrgID' element value. 
    					Description: The person org id created by the system that will be associated
    					with the SSR.
    				Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @return value
     */
    public int getPersonOrgID() {
        return personOrgID;
    }

    /** 
     * Set the 'PersonOrgID' element value. 
    					Description: The person org id created by the system that will be associated
    					with the SSR.
    				Constraints: Required.
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @param personOrgID
     */
    public void setPersonOrgID(int personOrgID) {
        this.personOrgID = personOrgID;
    }
}
