
package org.datacontract.schemas.radixx.connectpoint.reservation;

import java.util.Date;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsCurrencyCodeTypes;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsImportBookingAction;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Response" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ViewImportPNR.Reservation">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="SeriesNumber"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ConfirmationNumber"/>
 *     &lt;xs:element type="ns:Enumerations.ImportBookingAction" name="BookingAction"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="BookingCarrier"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="IATANumber"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ExternalAppID"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ExternalBookingReference"/>
 *     &lt;xs:element type="xs:dateTime" name="OriginalBookingDate"/>
 *     &lt;xs:element type="ns:Enumerations.CurrencyCodeTypes" name="ReservationCurrency"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="User"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="PromoCode"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="RecieptLanguageCode"/>
 *     &lt;xs:element type="xs:int" name="ReservationChannel"/>
 *     &lt;xs:element type="ns1:ArrayOfViewImportPNR.Reservation.Segment" nillable="true" name="Segments"/>
 *     &lt;xs:element type="ns1:ArrayOfViewImportPNR.Reservation.Person" nillable="true" name="Persons"/>
 *     &lt;xs:element type="ns1:ArrayOfViewImportPNR.Reservation.Comment" nillable="true" name="Comments"/>
 *     &lt;xs:element type="ns1:ArrayOfViewImportPNR.Reservation.ImportError" nillable="true" name="Errors"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ViewImportPNRReservation
{
    private String seriesNumber;
    private String confirmationNumber;
    private EnumerationsImportBookingAction bookingAction;
    private String bookingCarrier;
    private String IATANumber;
    private String externalAppID;
    private String externalBookingReference;
    private Date originalBookingDate;
    private EnumerationsCurrencyCodeTypes reservationCurrency;
    private String user;
    private String promoCode;
    private String recieptLanguageCode;
    private int reservationChannel;
    private ArrayOfViewImportPNRReservationSegment segments;
    private ArrayOfViewImportPNRReservationPerson persons;
    private ArrayOfViewImportPNRReservationComment comments;
    private ArrayOfViewImportPNRReservationImportError errors;

    /** 
     * Get the 'SeriesNumber' element value. 
    					Description: The series number associated with the confirmation number current
    					default should be 299.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 3.
    				
     * 
     * @return value
     */
    public String getSeriesNumber() {
        return seriesNumber;
    }

    /** 
     * Set the 'SeriesNumber' element value. 
    					Description: The series number associated with the confirmation number current
    					default should be 299.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 3.
    				
     * 
     * @param seriesNumber
     */
    public void setSeriesNumber(String seriesNumber) {
        this.seriesNumber = seriesNumber;
    }

    /** 
     * Get the 'ConfirmationNumber' element value. 
    					Description: The confirmation number issued during initial booking.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 30.
    				
     * 
     * @return value
     */
    public String getConfirmationNumber() {
        return confirmationNumber;
    }

    /** 
     * Set the 'ConfirmationNumber' element value. 
    					Description: The confirmation number issued during initial booking.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 30.
    				
     * 
     * @param confirmationNumber
     */
    public void setConfirmationNumber(String confirmationNumber) {
        this.confirmationNumber = confirmationNumber;
    }

    /** 
     * Get the 'BookingAction' element value. 
    					Description: This is meant for possible future usage. the current default
    					value 1 (SystemDetermined).
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public EnumerationsImportBookingAction getBookingAction() {
        return bookingAction;
    }

    /** 
     * Set the 'BookingAction' element value. 
    					Description: This is meant for possible future usage. the current default
    					value 1 (SystemDetermined).
    				Constraints: Optional (Not Required).
    				
     * 
     * @param bookingAction
     */
    public void setBookingAction(EnumerationsImportBookingAction bookingAction) {
        this.bookingAction = bookingAction;
    }

    /** 
     * Get the 'BookingCarrier' element value. 
    					Description: The carrier code that the action will be performed for.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 3.
    				Format: AlphaNumeric.
     * 
     * @return value
     */
    public String getBookingCarrier() {
        return bookingCarrier;
    }

    /** 
     * Set the 'BookingCarrier' element value. 
    					Description: The carrier code that the action will be performed for.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 3.
    				Format: AlphaNumeric.
     * 
     * @param bookingCarrier
     */
    public void setBookingCarrier(String bookingCarrier) {
        this.bookingCarrier = bookingCarrier;
    }

    /** 
     * Get the 'IATANumber' element value. 
    					Description: The IataNumber that the action will be performed for.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 20.
    				Format: AlphaNumericCodeMixedDotDash.
    				
     * 
     * @return value
     */
    public String getIATANumber() {
        return IATANumber;
    }

    /** 
     * Set the 'IATANumber' element value. 
    					Description: The IataNumber that the action will be performed for.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 20.
    				Format: AlphaNumericCodeMixedDotDash.
    				
     * 
     * @param IATANumber
     */
    public void setIATANumber(String IATANumber) {
        this.IATANumber = IATANumber;
    }

    /** 
     * Get the 'ExternalAppID' element value. 
    					Description: This value is usually the same as the the IataNumber that the
    					action will be performed for. If the IATA in the Radixx system is
    					not standard then this value will be the True IATA Standard IATA.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 20.
    				Format: AlphaNumeric.
     * 
     * @return value
     */
    public String getExternalAppID() {
        return externalAppID;
    }

    /** 
     * Set the 'ExternalAppID' element value. 
    					Description: This value is usually the same as the the IataNumber that the
    					action will be performed for. If the IATA in the Radixx system is
    					not standard then this value will be the True IATA Standard IATA.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 20.
    				Format: AlphaNumeric.
     * 
     * @param externalAppID
     */
    public void setExternalAppID(String externalAppID) {
        this.externalAppID = externalAppID;
    }

    /** 
     * Get the 'ExternalBookingReference' element value. 
    					Description: The value submitted here needs to be the linkage of the
    					information being imported into the Radixx system and the external
    					system. It should be unique per new booking and if Modification
    					action is being performed it needs to match the original submitted
    					externalbooking reference in order for the modification to work.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 20.
    				Format: AlphaNumeric.
     * 
     * @return value
     */
    public String getExternalBookingReference() {
        return externalBookingReference;
    }

    /** 
     * Set the 'ExternalBookingReference' element value. 
    					Description: The value submitted here needs to be the linkage of the
    					information being imported into the Radixx system and the external
    					system. It should be unique per new booking and if Modification
    					action is being performed it needs to match the original submitted
    					externalbooking reference in order for the modification to work.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 20.
    				Format: AlphaNumeric.
     * 
     * @param externalBookingReference
     */
    public void setExternalBookingReference(String externalBookingReference) {
        this.externalBookingReference = externalBookingReference;
    }

    /** 
     * Get the 'OriginalBookingDate' element value. 
    					Description: The date the booking was created in the external system.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getOriginalBookingDate() {
        return originalBookingDate;
    }

    /** 
     * Set the 'OriginalBookingDate' element value. 
    					Description: The date the booking was created in the external system.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param originalBookingDate
     */
    public void setOriginalBookingDate(Date originalBookingDate) {
        this.originalBookingDate = originalBookingDate;
    }

    /** 
     * Get the 'ReservationCurrency' element value. 
    					Description: The currency that the booking is being submitted in.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public EnumerationsCurrencyCodeTypes getReservationCurrency() {
        return reservationCurrency;
    }

    /** 
     * Set the 'ReservationCurrency' element value. 
    					Description: The currency that the booking is being submitted in.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param reservationCurrency
     */
    public void setReservationCurrency(
            EnumerationsCurrencyCodeTypes reservationCurrency) {
        this.reservationCurrency = reservationCurrency;
    }

    /** 
     * Get the 'User' element value. 
    					Description: The Radixx user id that the action will be performed for.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 15.
    				Format: AlphaNumeric.
     * 
     * @return value
     */
    public String getUser() {
        return user;
    }

    /** 
     * Set the 'User' element value. 
    					Description: The Radixx user id that the action will be performed for.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 15.
    				Format: AlphaNumeric.
     * 
     * @param user
     */
    public void setUser(String user) {
        this.user = user;
    }

    /** 
     * Get the 'PromoCode' element value. 
    					Description: If a promotion code was used submit the value here.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 20.
    				Format: AlphaNumeric.
     * 
     * @return value
     */
    public String getPromoCode() {
        return promoCode;
    }

    /** 
     * Set the 'PromoCode' element value. 
    					Description: If a promotion code was used submit the value here.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 20.
    				Format: AlphaNumeric.
     * 
     * @param promoCode
     */
    public void setPromoCode(String promoCode) {
        this.promoCode = promoCode;
    }

    /** 
     * Get the 'RecieptLanguageCode' element value. 
    					Description: This value is the ISO Standard language code that thte receipt
    					and other emailed data will be displayed/submitted in..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 6.
    				Format: AlphaNumeric.
     * 
     * @return value
     */
    public String getRecieptLanguageCode() {
        return recieptLanguageCode;
    }

    /** 
     * Set the 'RecieptLanguageCode' element value. 
    					Description: This value is the ISO Standard language code that thte receipt
    					and other emailed data will be displayed/submitted in..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 6.
    				Format: AlphaNumeric.
     * 
     * @param recieptLanguageCode
     */
    public void setRecieptLanguageCode(String recieptLanguageCode) {
        this.recieptLanguageCode = recieptLanguageCode;
    }

    /** 
     * Get the 'ReservationChannel' element value. 
    					Description: If the Radixx reservation Channel is known then the value should
    					be submitted here otherwise the default should be 5(TPAPI).
    				Constraints: Optional (Not Required).
    				
    					Range: Value must be in the range 1 and 2147483647.
    				
     * 
     * @return value
     */
    public int getReservationChannel() {
        return reservationChannel;
    }

    /** 
     * Set the 'ReservationChannel' element value. 
    					Description: If the Radixx reservation Channel is known then the value should
    					be submitted here otherwise the default should be 5(TPAPI).
    				Constraints: Optional (Not Required).
    				
    					Range: Value must be in the range 1 and 2147483647.
    				
     * 
     * @param reservationChannel
     */
    public void setReservationChannel(int reservationChannel) {
        this.reservationChannel = reservationChannel;
    }

    /** 
     * Get the 'Segments' element value. Description: The collection of Segments.
    				Constraints: Optional (Not Required).
    				Range: Value must be in the range 1 and 99.
    				
     * 
     * @return value
     */
    public ArrayOfViewImportPNRReservationSegment getSegments() {
        return segments;
    }

    /** 
     * Set the 'Segments' element value. Description: The collection of Segments.
    				Constraints: Optional (Not Required).
    				Range: Value must be in the range 1 and 99.
    				
     * 
     * @param segments
     */
    public void setSegments(ArrayOfViewImportPNRReservationSegment segments) {
        this.segments = segments;
    }

    /** 
     * Get the 'Persons' element value. Description: The collection of Persons.
    				Constraints: Optional (Not Required).
    				Range: Value must be in the range 1 and 99.
    				
     * 
     * @return value
     */
    public ArrayOfViewImportPNRReservationPerson getPersons() {
        return persons;
    }

    /** 
     * Set the 'Persons' element value. Description: The collection of Persons.
    				Constraints: Optional (Not Required).
    				Range: Value must be in the range 1 and 99.
    				
     * 
     * @param persons
     */
    public void setPersons(ArrayOfViewImportPNRReservationPerson persons) {
        this.persons = persons;
    }

    /** 
     * Get the 'Comments' element value. Description: The collection of Comments.
    				Constraints: Optional (Not Required).
    				Range: Value must be in the range 0 and 99.
    				
     * 
     * @return value
     */
    public ArrayOfViewImportPNRReservationComment getComments() {
        return comments;
    }

    /** 
     * Set the 'Comments' element value. Description: The collection of Comments.
    				Constraints: Optional (Not Required).
    				Range: Value must be in the range 0 and 99.
    				
     * 
     * @param comments
     */
    public void setComments(ArrayOfViewImportPNRReservationComment comments) {
        this.comments = comments;
    }

    /** 
     * Get the 'Errors' element value. Description: The collection of Error.
    				Constraints: Optional (Not Required).
    				Range: Value must be in the range 0 and 99.
    				
     * 
     * @return value
     */
    public ArrayOfViewImportPNRReservationImportError getErrors() {
        return errors;
    }

    /** 
     * Set the 'Errors' element value. Description: The collection of Error.
    				Constraints: Optional (Not Required).
    				Range: Value must be in the range 0 and 99.
    				
     * 
     * @param errors
     */
    public void setErrors(ArrayOfViewImportPNRReservationImportError errors) {
        this.errors = errors;
    }
}
