
package org.datacontract.schemas.radixx.connectpoint.reservation;

import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Response" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ViewImportPNR.Reservation.Person">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:int" name="PersonOrgID"/>
 *     &lt;xs:element type="xs:int" name="PTCID"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="PTC"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Title"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="LastName"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FirstName"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="MiddleName"/>
 *     &lt;xs:element type="xs:dateTime" name="DateOfBirth"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Gender"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Phone"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Mobile"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Email"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Address"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="City"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Postal"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Province"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Country"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="DocumentID"/>
 *     &lt;xs:element type="xs:dateTime" name="DocumentExpDate"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="SecureFlightRedressNumber"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="SecureFlightKnownTravellerNumber"/>
 *     &lt;xs:element type="ns:ArrayOfViewImportPNR.Reservation.Person.ApisInformation" nillable="true" name="ApisInfo"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ViewImportPNRReservationPerson
{
    private int personOrgID;
    private int PTCID;
    private String PTC;
    private String title;
    private String lastName;
    private String firstName;
    private String middleName;
    private Date dateOfBirth;
    private String gender;
    private String phone;
    private String mobile;
    private String email;
    private String address;
    private String city;
    private String postal;
    private String province;
    private String country;
    private String documentID;
    private Date documentExpDate;
    private String secureFlightRedressNumber;
    private String secureFlightKnownTravellerNumber;
    private ArrayOfViewImportPNRReservationPersonApisInformation apisInfo;

    /** 
     * Get the 'PersonOrgID' element value. 
    					Description: The unique identifier for the passenger..
    				Constraints: Optional (Not Required).
    				
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @return value
     */
    public int getPersonOrgID() {
        return personOrgID;
    }

    /** 
     * Set the 'PersonOrgID' element value. 
    					Description: The unique identifier for the passenger..
    				Constraints: Optional (Not Required).
    				
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @param personOrgID
     */
    public void setPersonOrgID(int personOrgID) {
        this.personOrgID = personOrgID;
    }

    /** 
     * Get the 'PTCID' element value. 
    					Description: The code representing the Passenger Type Code for the passenger
    					segment..
    				Constraints: Optional (Not Required).
    				
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @return value
     */
    public int getPTCID() {
        return PTCID;
    }

    /** 
     * Set the 'PTCID' element value. 
    					Description: The code representing the Passenger Type Code for the passenger
    					segment..
    				Constraints: Optional (Not Required).
    				
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @param PTCID
     */
    public void setPTCID(int PTCID) {
        this.PTCID = PTCID;
    }

    /** 
     * Get the 'PTC' element value. 
    					Description: The iata standard code representing the Passenger Type Code for
    					the passenger segment. (industry predefined Codes ADT, INF, CHD).
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getPTC() {
        return PTC;
    }

    /** 
     * Set the 'PTC' element value. 
    					Description: The iata standard code representing the Passenger Type Code for
    					the passenger segment. (industry predefined Codes ADT, INF, CHD).
    				Constraints: Optional (Not Required).
    				
     * 
     * @param PTC
     */
    public void setPTC(String PTC) {
        this.PTC = PTC;
    }

    /** 
     * Get the 'Title' element value. 
    					Description: The salutation for the passenger (e.g. Mr., Miss.)..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 20.
    				
     * 
     * @return value
     */
    public String getTitle() {
        return title;
    }

    /** 
     * Set the 'Title' element value. 
    					Description: The salutation for the passenger (e.g. Mr., Miss.)..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 20.
    				
     * 
     * @param title
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /** 
     * Get the 'LastName' element value. Description: The passenger's last name..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				
     * 
     * @return value
     */
    public String getLastName() {
        return lastName;
    }

    /** 
     * Set the 'LastName' element value. Description: The passenger's last name..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				
     * 
     * @param lastName
     */
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    /** 
     * Get the 'FirstName' element value. Description: The passenger's first name..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				
     * 
     * @return value
     */
    public String getFirstName() {
        return firstName;
    }

    /** 
     * Set the 'FirstName' element value. Description: The passenger's first name..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				
     * 
     * @param firstName
     */
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    /** 
     * Get the 'MiddleName' element value. Description: The passenger's middle name..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				
     * 
     * @return value
     */
    public String getMiddleName() {
        return middleName;
    }

    /** 
     * Set the 'MiddleName' element value. Description: The passenger's middle name..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				
     * 
     * @param middleName
     */
    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    /** 
     * Get the 'DateOfBirth' element value. Description: The passenger's date of birth..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getDateOfBirth() {
        return dateOfBirth;
    }

    /** 
     * Set the 'DateOfBirth' element value. Description: The passenger's date of birth..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param dateOfBirth
     */
    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    /** 
     * Get the 'Gender' element value. 
    					Description: The code specifying the gender of the passenger..
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public String getGender() {
        return gender;
    }

    /** 
     * Set the 'Gender' element value. 
    					Description: The code specifying the gender of the passenger..
    				Constraints: Optional (Not Required).
    				
     * 
     * @param gender
     */
    public void setGender(String gender) {
        this.gender = gender;
    }

    /** 
     * Get the 'Phone' element value. Description: The contact phone number..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				Format: AlphaNumeric.
     * 
     * @return value
     */
    public String getPhone() {
        return phone;
    }

    /** 
     * Set the 'Phone' element value. Description: The contact phone number..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				Format: AlphaNumeric.
     * 
     * @param phone
     */
    public void setPhone(String phone) {
        this.phone = phone;
    }

    /** 
     * Get the 'Mobile' element value. Description: The contact mobile number..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				Format: AlphaNumeric.
     * 
     * @return value
     */
    public String getMobile() {
        return mobile;
    }

    /** 
     * Set the 'Mobile' element value. Description: The contact mobile number..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				Format: AlphaNumeric.
     * 
     * @param mobile
     */
    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    /** 
     * Get the 'Email' element value. Description: The contact email address..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				Format: AlphaNumeric.
     * 
     * @return value
     */
    public String getEmail() {
        return email;
    }

    /** 
     * Set the 'Email' element value. Description: The contact email address..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				Format: AlphaNumeric.
     * 
     * @param email
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /** 
     * Get the 'Address' element value. Description: The contact email address..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				Format: AlphaNumeric.
     * 
     * @return value
     */
    public String getAddress() {
        return address;
    }

    /** 
     * Set the 'Address' element value. Description: The contact email address..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				Format: AlphaNumeric.
     * 
     * @param address
     */
    public void setAddress(String address) {
        this.address = address;
    }

    /** 
     * Get the 'City' element value. Description: The city for the person.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 50.
    				Format: AlphaNumeric.
     * 
     * @return value
     */
    public String getCity() {
        return city;
    }

    /** 
     * Set the 'City' element value. Description: The city for the person.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 50.
    				Format: AlphaNumeric.
     * 
     * @param city
     */
    public void setCity(String city) {
        this.city = city;
    }

    /** 
     * Get the 'Postal' element value. Description: The postal code for the person.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 10.
    				Format: AlphaNumeric.
     * 
     * @return value
     */
    public String getPostal() {
        return postal;
    }

    /** 
     * Set the 'Postal' element value. Description: The postal code for the person.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 10.
    				Format: AlphaNumeric.
     * 
     * @param postal
     */
    public void setPostal(String postal) {
        this.postal = postal;
    }

    /** 
     * Get the 'Province' element value. Description: The province or state for the
    					person.Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				Format: AlphaNumeric.
     * 
     * @return value
     */
    public String getProvince() {
        return province;
    }

    /** 
     * Set the 'Province' element value. Description: The province or state for the
    					person.Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				Format: AlphaNumeric.
     * 
     * @param province
     */
    public void setProvince(String province) {
        this.province = province;
    }

    /** 
     * Get the 'Country' element value. Description: The Country for the person.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 30.
    				Format: AlphaNumeric.
     * 
     * @return value
     */
    public String getCountry() {
        return country;
    }

    /** 
     * Set the 'Country' element value. Description: The Country for the person.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 30.
    				Format: AlphaNumeric.
     * 
     * @param country
     */
    public void setCountry(String country) {
        this.country = country;
    }

    /** 
     * Get the 'DocumentID' element value. 
    					Description: The passport information if available.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 30.
    				Format: AlphaNumeric.
     * 
     * @return value
     */
    public String getDocumentID() {
        return documentID;
    }

    /** 
     * Set the 'DocumentID' element value. 
    					Description: The passport information if available.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 30.
    				Format: AlphaNumeric.
     * 
     * @param documentID
     */
    public void setDocumentID(String documentID) {
        this.documentID = documentID;
    }

    /** 
     * Get the 'DocumentExpDate' element value. 
    					Description: The passport expiration date information if available.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public Date getDocumentExpDate() {
        return documentExpDate;
    }

    /** 
     * Set the 'DocumentExpDate' element value. 
    					Description: The passport expiration date information if available.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param documentExpDate
     */
    public void setDocumentExpDate(Date documentExpDate) {
        this.documentExpDate = documentExpDate;
    }

    /** 
     * Get the 'SecureFlightRedressNumber' element value. Description: Secure Flight Information.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 30.
    				Format: AlphaNumeric.
     * 
     * @return value
     */
    public String getSecureFlightRedressNumber() {
        return secureFlightRedressNumber;
    }

    /** 
     * Set the 'SecureFlightRedressNumber' element value. Description: Secure Flight Information.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 30.
    				Format: AlphaNumeric.
     * 
     * @param secureFlightRedressNumber
     */
    public void setSecureFlightRedressNumber(String secureFlightRedressNumber) {
        this.secureFlightRedressNumber = secureFlightRedressNumber;
    }

    /** 
     * Get the 'SecureFlightKnownTravellerNumber' element value. Description: Secure Flight Information.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 30.
    				Format: AlphaNumeric.
     * 
     * @return value
     */
    public String getSecureFlightKnownTravellerNumber() {
        return secureFlightKnownTravellerNumber;
    }

    /** 
     * Set the 'SecureFlightKnownTravellerNumber' element value. Description: Secure Flight Information.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 30.
    				Format: AlphaNumeric.
     * 
     * @param secureFlightKnownTravellerNumber
     */
    public void setSecureFlightKnownTravellerNumber(
            String secureFlightKnownTravellerNumber) {
        this.secureFlightKnownTravellerNumber = secureFlightKnownTravellerNumber;
    }

    /** 
     * Get the 'ApisInfo' element value. Description: The collection of ApisInfos.
    				Constraints: Optional (Not Required).
    				Range: Value must be in the range 0 and 99.
    				
     * 
     * @return value
     */
    public ArrayOfViewImportPNRReservationPersonApisInformation getApisInfo() {
        return apisInfo;
    }

    /** 
     * Set the 'ApisInfo' element value. Description: The collection of ApisInfos.
    				Constraints: Optional (Not Required).
    				Range: Value must be in the range 0 and 99.
    				
     * 
     * @param apisInfo
     */
    public void setApisInfo(
            ArrayOfViewImportPNRReservationPersonApisInformation apisInfo) {
        this.apisInfo = apisInfo;
    }
}
